/*
 * Decompiled with CFR 0.152.
 */
package b100.json.element;

import b100.json.element.JsonArray;
import b100.json.element.JsonBoolean;
import b100.json.element.JsonElement;
import b100.json.element.JsonEntry;
import b100.json.element.JsonNumber;
import b100.json.element.JsonString;
import b100.utils.InvalidCharacterException;
import b100.utils.StringReader;
import b100.utils.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JsonObject
implements JsonElement,
Iterable<JsonEntry> {
    private List<JsonEntry> entries;
    private boolean compact;

    public JsonObject() {
        this.compact = false;
        this.entries = new ArrayList<JsonEntry>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonObject(StringReader reader) {
        block1: {
            this();
            reader.skipWhitespace();
            reader.expectAndSkip('{');
            while (true) {
                reader.skipWhitespace();
                if (reader.get() != '\"') break block1;
                String id = new JsonString((StringReader)reader).value;
                reader.skipWhitespace();
                reader.expectAndSkip(':');
                JsonElement element = JsonElement.readElement(reader);
                this.set(id, element);
                reader.skipWhitespace();
                if (reader.get() != ',') break;
                reader.next();
            }
            if (reader.get() != '}') throw new InvalidCharacterException(reader);
            reader.next();
            return;
        }
        if (reader.get() != '}') throw new InvalidCharacterException(reader);
        reader.next();
    }

    @Override
    public void write(StringWriter writer) {
        writer.write("{");
        writer.addTab();
        int i = 0;
        for (JsonEntry entry : this.entries) {
            if (!this.isCompact()) {
                writer.write('\n');
            } else {
                writer.write(' ');
            }
            new JsonString(entry.name).write(writer);
            writer.write(": ");
            entry.value.write(writer);
            if (i < this.entries.size() - 1) {
                writer.write(',');
            }
            ++i;
        }
        if (i > 0) {
            if (!this.isCompact()) {
                writer.write('\n');
            } else {
                writer.write(' ');
            }
        }
        writer.removeTab();
        writer.write("}");
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.write(writer);
        return writer.toString();
    }

    public JsonObject getOrCreateObject(String id) {
        JsonObject object = this.getObject(id);
        if (object == null) {
            object = new JsonObject();
            this.set(id, object);
        }
        return object;
    }

    public JsonEntry getOrCreateEntry(String string) {
        JsonEntry entry = this.getEntry(string);
        if (entry == null) {
            entry = new JsonEntry(string, null);
            this.entries.add(entry);
        }
        return entry;
    }

    public JsonEntry getEntry(String string) {
        for (JsonEntry e : this.entries) {
            if (!e.equalsId(string)) continue;
            return e;
        }
        return null;
    }

    public JsonElement get(String id) {
        JsonEntry entry = this.getEntry(id);
        return entry != null ? entry.value : null;
    }

    public JsonObject getObject(String id) {
        JsonElement element = this.get(id);
        return element != null ? element.getAsObject() : null;
    }

    public JsonArray getArray(String id) {
        JsonElement element = this.get(id);
        return element != null ? element.getAsArray() : null;
    }

    public JsonString getJsonString(String id) {
        return this.get(id).getAsString();
    }

    public JsonNumber getJsonNumber(String id) {
        return this.get(id).getAsNumber();
    }

    public JsonBoolean getJsonBoolean(String id) {
        return this.get(id).getAsBoolean();
    }

    public String getString(String id) {
        return this.get((String)id).getAsString().value;
    }

    public Number getNumber(String id) {
        return this.get((String)id).getAsNumber().value;
    }

    public int getInt(String id) {
        return this.getNumber(id).intValue();
    }

    public long getLong(String id) {
        return this.getNumber(id).longValue();
    }

    public double getDouble(String id) {
        return this.getNumber(id).doubleValue();
    }

    public float getFloat(String id) {
        return this.getNumber(id).floatValue();
    }

    public byte getByte(String id) {
        return this.getNumber(id).byteValue();
    }

    public short getShort(String id) {
        return this.getNumber(id).shortValue();
    }

    public boolean getBoolean(String id) {
        return this.get((String)id).getAsBoolean().value;
    }

    public int getInt(String id, int defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id);
        if (entry.value == null || !(entry.value instanceof JsonNumber)) {
            entry.value = new JsonNumber(defaultValue);
        }
        return entry.value.getAsNumber().getInteger();
    }

    public long getLong(String id, long defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id);
        if (entry.value == null || !(entry.value instanceof JsonNumber)) {
            entry.value = new JsonNumber(defaultValue);
        }
        return entry.value.getAsNumber().getLong();
    }

    public float getFloat(String id, float defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id);
        if (entry.value == null || !(entry.value instanceof JsonNumber)) {
            entry.value = new JsonNumber(defaultValue);
        }
        return entry.value.getAsNumber().getFloat();
    }

    public double getDouble(String id, double defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id);
        if (entry.value == null || !(entry.value instanceof JsonNumber)) {
            entry.value = new JsonNumber(defaultValue);
        }
        return entry.value.getAsNumber().getDouble();
    }

    public short getShort(String id, short defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id);
        if (entry.value == null || !(entry.value instanceof JsonNumber)) {
            entry.value = new JsonNumber(defaultValue);
        }
        return entry.value.getAsNumber().getShort();
    }

    public byte getByte(String id, byte defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id);
        if (entry.value == null || !(entry.value instanceof JsonNumber)) {
            entry.value = new JsonNumber(defaultValue);
        }
        return entry.value.getAsNumber().getByte();
    }

    public boolean getBoolean(String id, boolean defaultValue) {
        JsonEntry entry = this.getOrCreateEntry(id);
        if (entry.value == null || !(entry.value instanceof JsonBoolean)) {
            entry.value = new JsonBoolean(defaultValue);
        }
        return entry.value.getAsBoolean().value;
    }

    public JsonObject set(String id, JsonElement element) {
        this.getOrCreateEntry((String)id).value = element;
        return this;
    }

    public JsonObject set(String id, String s) {
        return this.set(id, new JsonString(s));
    }

    public JsonObject set(String id, int n) {
        return this.set(id, new JsonNumber(n));
    }

    public JsonObject set(String id, long n) {
        return this.set(id, new JsonNumber(n));
    }

    public JsonObject set(String id, float n) {
        return this.set(id, new JsonNumber(n));
    }

    public JsonObject set(String id, double n) {
        return this.set(id, new JsonNumber(n));
    }

    public JsonObject set(String id, short n) {
        return this.set(id, new JsonNumber(n));
    }

    public JsonObject set(String id, byte n) {
        return this.set(id, new JsonNumber(n));
    }

    public JsonObject set(String id, boolean b) {
        return this.set(id, new JsonBoolean(b));
    }

    public List<JsonElement> elementList() {
        ArrayList<JsonElement> elements = new ArrayList<JsonElement>();
        for (JsonEntry entry : this.entries) {
            elements.add(entry.value);
        }
        return elements;
    }

    public List<String> idList() {
        ArrayList<String> elements = new ArrayList<String>();
        for (JsonEntry entry : this.entries) {
            elements.add(entry.name);
        }
        return elements;
    }

    public List<JsonEntry> entryList() {
        return this.entries;
    }

    public boolean has(String id) {
        return this.getEntry(id) != null;
    }

    public boolean has(String name, JsonElement element) {
        JsonEntry entry = this.getEntry(name);
        if (entry != null) {
            return entry.value.equals(element);
        }
        return false;
    }

    public boolean has(String name, String string) {
        JsonEntry entry = this.getEntry(name);
        if (entry != null && entry.value.isString()) {
            return entry.value.getAsString().value.equals(string);
        }
        return false;
    }

    @Override
    public Iterator<JsonEntry> iterator() {
        return this.entries.iterator();
    }

    public void setCompact(boolean b) {
        this.compact = true;
    }

    public boolean isCompact() {
        return this.compact;
    }
}

