/*
 * Decompiled with CFR 0.152.
 */
package b100.utils;

import b100.utils.Utils;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;

public abstract class ImageUtils {
    public static void copyImageToClipboard(BufferedImage image) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new TransferableImage(image), null);
    }

    private static class TransferableImage
    implements Transferable {
        private Image image;

        public TransferableImage(Image image) {
            this.image = Utils.requireNonNull(image);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor == DataFlavor.imageFlavor) {
                return this.image;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

