/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.Vec3D;

public class AxisAlignedBB {
    private static List boundingBoxes = new ArrayList();
    private static int numBoundingBoxesInUse = 0;
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;

    public static AxisAlignedBB getBoundingBox(double d, double d1, double d2, double d3, double d4, double d5) {
        return new AxisAlignedBB(d, d1, d2, d3, d4, d5);
    }

    public static void func_28196_a() {
        boundingBoxes.clear();
        numBoundingBoxesInUse = 0;
    }

    public static void clearBoundingBoxPool() {
        numBoundingBoxesInUse = 0;
    }

    public static AxisAlignedBB getBoundingBoxFromPool(double d, double d1, double d2, double d3, double d4, double d5) {
        if (numBoundingBoxesInUse >= boundingBoxes.size()) {
            boundingBoxes.add(AxisAlignedBB.getBoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        }
        return ((AxisAlignedBB)boundingBoxes.get(numBoundingBoxesInUse++)).setBounds(d, d1, d2, d3, d4, d5);
    }

    private AxisAlignedBB(double d, double d1, double d2, double d3, double d4, double d5) {
        this.minX = d;
        this.minY = d1;
        this.minZ = d2;
        this.maxX = d3;
        this.maxY = d4;
        this.maxZ = d5;
    }

    public AxisAlignedBB setBounds(double d, double d1, double d2, double d3, double d4, double d5) {
        this.minX = d;
        this.minY = d1;
        this.minZ = d2;
        this.maxX = d3;
        this.maxY = d4;
        this.maxZ = d5;
        return this;
    }

    public AxisAlignedBB addCoord(double d, double d1, double d2) {
        double d3 = this.minX;
        double d4 = this.minY;
        double d5 = this.minZ;
        double d6 = this.maxX;
        double d7 = this.maxY;
        double d8 = this.maxZ;
        if (d < 0.0) {
            d3 += d;
        }
        if (d > 0.0) {
            d6 += d;
        }
        if (d1 < 0.0) {
            d4 += d1;
        }
        if (d1 > 0.0) {
            d7 += d1;
        }
        if (d2 < 0.0) {
            d5 += d2;
        }
        if (d2 > 0.0) {
            d8 += d2;
        }
        return AxisAlignedBB.getBoundingBoxFromPool(d3, d4, d5, d6, d7, d8);
    }

    public AxisAlignedBB expand(double d, double d1, double d2) {
        double d3 = this.minX - d;
        double d4 = this.minY - d1;
        double d5 = this.minZ - d2;
        double d6 = this.maxX + d;
        double d7 = this.maxY + d1;
        double d8 = this.maxZ + d2;
        return AxisAlignedBB.getBoundingBoxFromPool(d3, d4, d5, d6, d7, d8);
    }

    public AxisAlignedBB getOffsetBoundingBox(double d, double d1, double d2) {
        return AxisAlignedBB.getBoundingBoxFromPool(this.minX + d, this.minY + d1, this.minZ + d2, this.maxX + d, this.maxY + d1, this.maxZ + d2);
    }

    public double calculateXOffset(AxisAlignedBB axisalignedbb, double d) {
        double d2;
        double d1;
        if (axisalignedbb.maxY <= this.minY || axisalignedbb.minY >= this.maxY) {
            return d;
        }
        if (axisalignedbb.maxZ <= this.minZ || axisalignedbb.minZ >= this.maxZ) {
            return d;
        }
        if (d > 0.0 && axisalignedbb.maxX <= this.minX && (d1 = this.minX - axisalignedbb.maxX) < d) {
            d = d1;
        }
        if (d < 0.0 && axisalignedbb.minX >= this.maxX && (d2 = this.maxX - axisalignedbb.minX) > d) {
            d = d2;
        }
        return d;
    }

    public double calculateYOffset(AxisAlignedBB axisalignedbb, double d) {
        double d2;
        double d1;
        if (axisalignedbb.maxX <= this.minX || axisalignedbb.minX >= this.maxX) {
            return d;
        }
        if (axisalignedbb.maxZ <= this.minZ || axisalignedbb.minZ >= this.maxZ) {
            return d;
        }
        if (d > 0.0 && axisalignedbb.maxY <= this.minY && (d1 = this.minY - axisalignedbb.maxY) < d) {
            d = d1;
        }
        if (d < 0.0 && axisalignedbb.minY >= this.maxY && (d2 = this.maxY - axisalignedbb.minY) > d) {
            d = d2;
        }
        return d;
    }

    public double calculateZOffset(AxisAlignedBB axisalignedbb, double d) {
        double d2;
        double d1;
        if (axisalignedbb.maxX <= this.minX || axisalignedbb.minX >= this.maxX) {
            return d;
        }
        if (axisalignedbb.maxY <= this.minY || axisalignedbb.minY >= this.maxY) {
            return d;
        }
        if (d > 0.0 && axisalignedbb.maxZ <= this.minZ && (d1 = this.minZ - axisalignedbb.maxZ) < d) {
            d = d1;
        }
        if (d < 0.0 && axisalignedbb.minZ >= this.maxZ && (d2 = this.maxZ - axisalignedbb.minZ) > d) {
            d = d2;
        }
        return d;
    }

    public boolean intersectsWith(AxisAlignedBB axisalignedbb) {
        if (axisalignedbb.maxX <= this.minX || axisalignedbb.minX >= this.maxX) {
            return false;
        }
        if (axisalignedbb.maxY <= this.minY || axisalignedbb.minY >= this.maxY) {
            return false;
        }
        return axisalignedbb.maxZ > this.minZ && axisalignedbb.minZ < this.maxZ;
    }

    public AxisAlignedBB offset(double d, double d1, double d2) {
        this.minX += d;
        this.minY += d1;
        this.minZ += d2;
        this.maxX += d;
        this.maxY += d1;
        this.maxZ += d2;
        return this;
    }

    public boolean isVecInside(Vec3D vec3d) {
        if (vec3d.xCoord <= this.minX || vec3d.xCoord >= this.maxX) {
            return false;
        }
        if (vec3d.yCoord <= this.minY || vec3d.yCoord >= this.maxY) {
            return false;
        }
        return vec3d.zCoord > this.minZ && vec3d.zCoord < this.maxZ;
    }

    public double getAverageEdgeLength() {
        double d = this.maxX - this.minX;
        double d1 = this.maxY - this.minY;
        double d2 = this.maxZ - this.minZ;
        return (d + d1 + d2) / 3.0;
    }

    public AxisAlignedBB getInsetBoundingBox(double d, double d1, double d2) {
        double d3 = this.minX + d;
        double d4 = this.minY + d1;
        double d5 = this.minZ + d2;
        double d6 = this.maxX - d;
        double d7 = this.maxY - d1;
        double d8 = this.maxZ - d2;
        return AxisAlignedBB.getBoundingBoxFromPool(d3, d4, d5, d6, d7, d8);
    }

    public AxisAlignedBB copy() {
        return AxisAlignedBB.getBoundingBoxFromPool(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public MovingObjectPosition func_1169_a(Vec3D vec3d, Vec3D vec3d1) {
        Vec3D vec3d2 = vec3d.getIntermediateWithXValue(vec3d1, this.minX);
        Vec3D vec3d3 = vec3d.getIntermediateWithXValue(vec3d1, this.maxX);
        Vec3D vec3d4 = vec3d.getIntermediateWithYValue(vec3d1, this.minY);
        Vec3D vec3d5 = vec3d.getIntermediateWithYValue(vec3d1, this.maxY);
        Vec3D vec3d6 = vec3d.getIntermediateWithZValue(vec3d1, this.minZ);
        Vec3D vec3d7 = vec3d.getIntermediateWithZValue(vec3d1, this.maxZ);
        if (!this.isVecInYZ(vec3d2)) {
            vec3d2 = null;
        }
        if (!this.isVecInYZ(vec3d3)) {
            vec3d3 = null;
        }
        if (!this.isVecInXZ(vec3d4)) {
            vec3d4 = null;
        }
        if (!this.isVecInXZ(vec3d5)) {
            vec3d5 = null;
        }
        if (!this.isVecInXY(vec3d6)) {
            vec3d6 = null;
        }
        if (!this.isVecInXY(vec3d7)) {
            vec3d7 = null;
        }
        Vec3D vec3d8 = null;
        if (vec3d2 != null && (vec3d8 == null || vec3d.squareDistanceTo(vec3d2) < vec3d.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d2;
        }
        if (vec3d3 != null && (vec3d8 == null || vec3d.squareDistanceTo(vec3d3) < vec3d.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d3;
        }
        if (vec3d4 != null && (vec3d8 == null || vec3d.squareDistanceTo(vec3d4) < vec3d.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d4;
        }
        if (vec3d5 != null && (vec3d8 == null || vec3d.squareDistanceTo(vec3d5) < vec3d.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d5;
        }
        if (vec3d6 != null && (vec3d8 == null || vec3d.squareDistanceTo(vec3d6) < vec3d.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d6;
        }
        if (vec3d7 != null && (vec3d8 == null || vec3d.squareDistanceTo(vec3d7) < vec3d.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d7;
        }
        if (vec3d8 == null) {
            return null;
        }
        int byte0 = -1;
        if (vec3d8 == vec3d2) {
            byte0 = 4;
        }
        if (vec3d8 == vec3d3) {
            byte0 = 5;
        }
        if (vec3d8 == vec3d4) {
            byte0 = 0;
        }
        if (vec3d8 == vec3d5) {
            byte0 = 1;
        }
        if (vec3d8 == vec3d6) {
            byte0 = 2;
        }
        if (vec3d8 == vec3d7) {
            byte0 = 3;
        }
        return new MovingObjectPosition(0, 0, 0, byte0, vec3d8);
    }

    private boolean isVecInYZ(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInXZ(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInXY(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY;
    }

    public void setBB(AxisAlignedBB axisalignedbb) {
        this.minX = axisalignedbb.minX;
        this.minY = axisalignedbb.minY;
        this.minZ = axisalignedbb.minZ;
        this.maxX = axisalignedbb.maxX;
        this.maxY = axisalignedbb.maxY;
        this.maxZ = axisalignedbb.maxZ;
    }

    public String toString() {
        return "box[" + this.minX + ", " + this.minY + ", " + this.minZ + " -> " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }
}

