/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityBoat;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public class BlockAlgae
extends Block {
    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
        if (!world.isMultiplayerAndNotHost && entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Item.toolShears.itemID) {
            entityplayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            world.dropItem(i, j, k, new ItemStack(this.blockID, 1, 0));
        } else {
            super.harvestBlock(world, entityplayer, i, j, k, l);
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        return -1;
    }

    protected BlockAlgae(int i, Material material) {
        super(i, material);
        this.setBlockBounds(0.0f, -0.125f, 0.0f, 1.0f, 0.00625f, 1.0f);
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        if (entity instanceof EntityBoat) {
            world.playSoundEffectForPlayer(null, 2001, i, j, k, this.blockID);
            world.setBlockWithNotify(i, j, k, 0);
            this.onBlockDestroyedByPlayer(world, i, j, k, 0);
            this.onBlockRemoval(world, i, j, k);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j, k);
        return l == 0 && world.getBlockMaterial(i, j - 1, k) == Material.water;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (world.getBlockId(i, j - 1, k) != Block.fluidWaterStill.blockID) {
            world.setBlock(i, j, k, 0);
        }
    }

    @Override
    public int getRenderType() {
        return 24;
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.01f, 0.0f, 1.0f, 0.0125f, 1.0f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (l == 1) {
            return true;
        }
        return super.shouldSideBeRendered(iblockaccess, i, j, k, l);
    }
}

