/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockChest;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.World;

public class BlockChestPainted
extends BlockChest {
    public BlockChestPainted(int i) {
        super(i);
    }

    @Override
    public int getRenderType() {
        return 22;
    }

    @Override
    public int getRenderColor(int i) {
        return Block.planksOakPainted.getRenderColor((i & 0xF0) >> 4);
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i, int j, int k) {
        int meta = world.getBlockMetadata(i, j, k);
        return this.getRenderColor(meta);
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        return super.getBlockTexture(iblockaccess, x, y, z, side) + BlockChestPainted.texCoordToIndex(-9, 16);
    }

    @Override
    protected int damageDropped(int i) {
        return i & 0xF0;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (i == 1 || i == 0) {
            return BlockChestPainted.texCoordToIndex(0, 17);
        }
        if (i == 3) {
            return BlockChestPainted.texCoordToIndex(2, 17);
        }
        return BlockChestPainted.texCoordToIndex(1, 17);
    }

    public static int getMetadataForColour(int i) {
        return ~i << 4 & 0xF0;
    }
}

