/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BlockRail;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.World;

public class BlockDetectorRail
extends BlockRail {
    public BlockDetectorRail(int i) {
        super(i, true);
        this.setTickOnLoad(true);
    }

    @Override
    public int tickRate() {
        return 20;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int l = world.getBlockMetadata(i, j, k);
        if ((l & 8) != 0) {
            return;
        }
        this.setStateIfMinecartInteractsWithRail(world, i, j, k, l);
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int l = world.getBlockMetadata(i, j, k);
        if ((l & 8) == 0) {
            return;
        }
        this.setStateIfMinecartInteractsWithRail(world, i, j, k, l);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return (iblockaccess.getBlockMetadata(i, j, k) & 8) != 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        if ((world.getBlockMetadata(i, j, k) & 8) == 0) {
            return false;
        }
        return l == 1;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        return this.atlasIndices[i];
    }

    private void setStateIfMinecartInteractsWithRail(World world, int i, int j, int k, int l) {
        boolean flag = (l & 8) != 0;
        boolean flag1 = false;
        float f = 0.125f;
        List<Entity> list = world.getEntitiesWithinAABB(EntityMinecart.class, AxisAlignedBB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        if (list.size() > 0) {
            flag1 = true;
        }
        if (flag1 && !flag) {
            world.setBlockMetadataWithNotify(i, j, k, l | 8);
            world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
            world.markBlocksDirty(i, j, k, i, j, k);
        }
        if (!flag1 && flag) {
            world.setBlockMetadataWithNotify(i, j, k, l & 7);
            world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
            world.markBlocksDirty(i, j, k, i, j, k);
        }
        if (flag1) {
            world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
        }
    }
}

