/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainerRotatable;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityArrowGolden;
import net.minecraft.src.EntityCannonball;
import net.minecraft.src.EntityEgg;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPebble;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySnowball;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityDispenser;
import net.minecraft.src.World;

public class BlockDispenser
extends BlockContainerRotatable {
    private Random random = new Random();

    public BlockDispenser(int i) {
        super(i, Material.rock);
    }

    @Override
    public int tickRate() {
        return 4;
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.dispenserCobbleStone.blockID;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        this.setDispenserDefaultDirection(world, i, j, k);
    }

    private void setDispenserDefaultDirection(World world, int i, int j, int k) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int l = world.getBlockId(i, j, k - 1);
        int i1 = world.getBlockId(i, j, k + 1);
        int j1 = world.getBlockId(i - 1, j, k);
        int k1 = world.getBlockId(i + 1, j, k);
        int byte0 = 3;
        if (Block.opaqueCubeLookup[l] && !Block.opaqueCubeLookup[i1]) {
            byte0 = 3;
        }
        if (Block.opaqueCubeLookup[i1] && !Block.opaqueCubeLookup[l]) {
            byte0 = 2;
        }
        if (Block.opaqueCubeLookup[j1] && !Block.opaqueCubeLookup[k1]) {
            byte0 = 5;
        }
        if (Block.opaqueCubeLookup[k1] && !Block.opaqueCubeLookup[j1]) {
            byte0 = 4;
        }
        world.setBlockMetadataWithNotify(i, j, k, byte0);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (world.isMultiplayerAndNotHost) {
            return true;
        }
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)world.getBlockTileEntity(i, j, k);
        entityplayer.displayGUIDispenser(tileentitydispenser);
        return true;
    }

    private void dispenseItem(World world, int i, int j, int k, Random random) {
        int l = world.getBlockMetadata(i, j, k);
        int i1 = 0;
        int j1 = 0;
        if (l == 3) {
            j1 = 1;
        } else if (l == 2) {
            j1 = -1;
        } else {
            i1 = l == 5 ? 1 : -1;
        }
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)world.getBlockTileEntity(i, j, k);
        ItemStack itemstack = tileentitydispenser.getRandomStackFromInventory();
        double d = (double)i + (double)i1 * 0.6 + 0.5;
        double d1 = (double)j + 0.5;
        double d2 = (double)k + (double)j1 * 0.6 + 0.5;
        if (itemstack == null) {
            world.playSoundEffect(1001, i, j, k, 0);
        } else {
            if (itemstack.itemID == Item.ammoArrow.itemID || itemstack.itemID == Item.ammoArrowGold.itemID) {
                EntityArrow entityarrow = itemstack.itemID == Item.ammoArrow.itemID ? new EntityArrow(world, d, d1, d2, 0) : new EntityArrowGolden(world, d, d1, d2);
                entityarrow.setArrowHeading(i1, 0.1f, j1, 1.1f, 6.0f);
                entityarrow.doesArrowBelongToPlayer = true;
                world.entityJoinedWorld(entityarrow);
                world.playSoundEffect(1002, i, j, k, 0);
            } else if (itemstack.itemID == Item.ammoChargeExplosive.itemID) {
                EntityCannonball entitycannonball = new EntityCannonball(world, d, d1, d2);
                entitycannonball.setCannonballHeading(i1, 0.1, j1, 1.1f, 6.0f);
                world.entityJoinedWorld(entitycannonball);
                world.playSoundEffect(1002, i, j, k, 0);
            } else if (itemstack.itemID == Item.eggChicken.itemID) {
                EntityEgg entityegg = new EntityEgg(world, d, d1, d2);
                entityegg.setEggHeading(i1, 0.1, j1, 1.1f, 6.0f);
                world.entityJoinedWorld(entityegg);
                world.playSoundEffect(1002, i, j, k, 0);
            } else if (itemstack.itemID == Item.ammoSnowball.itemID) {
                EntitySnowball entitysnowball = new EntitySnowball(world, d, d1, d2);
                entitysnowball.setSnowballHeading(i1, 0.1, j1, 1.1f, 6.0f);
                world.entityJoinedWorld(entitysnowball);
                world.playSoundEffect(1002, i, j, k, 0);
            } else if (itemstack.itemID == Item.ammoPebble.itemID) {
                EntityPebble pebble = new EntityPebble(world, d, d1, d2);
                pebble.setSnowballHeading(i1, 0.1, j1, 1.1f, 6.0f);
                world.entityJoinedWorld(pebble);
                world.playSoundEffect(1002, i, j, k, 0);
            } else {
                EntityItem entityitem = new EntityItem(world, d, d1 - 0.3, d2, itemstack);
                double d3 = random.nextDouble() * 0.1 + 0.2;
                entityitem.motionX = (double)i1 * d3;
                entityitem.motionY = 0.2f;
                entityitem.motionZ = (double)j1 * d3;
                entityitem.motionX += random.nextGaussian() * (double)0.0075f * 6.0;
                entityitem.motionY += random.nextGaussian() * (double)0.0075f * 6.0;
                entityitem.motionZ += random.nextGaussian() * (double)0.0075f * 6.0;
                world.entityJoinedWorld(entityitem);
                world.playSoundEffect(1000, i, j, k, 0);
            }
            world.playSoundEffect(2000, i, j, k, i1 + 1 + (j1 + 1) * 3);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (l > 0 && Block.blocksList[l].canProvidePower()) {
            boolean flag;
            boolean bl = flag = world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k);
            if (flag) {
                world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
            }
        }
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k)) {
            this.dispenseItem(world, i, j, k, random);
        }
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityDispenser();
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        if (world.getBlockTileEntity(i, j, k) != null) {
            TileEntityDispenser tileentitydispenser = (TileEntityDispenser)world.getBlockTileEntity(i, j, k);
            for (int l = 0; l < tileentitydispenser.getSizeInventory(); ++l) {
                ItemStack itemstack = tileentitydispenser.getStackInSlot(l);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.random.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)i + f, (float)j + f1, (float)k + f2, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.random.nextGaussian() * f3;
                    entityitem.motionY = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.random.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(world, i, j, k);
    }
}

