/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class BlockDoor
extends Block {
    public final boolean isTop;

    public BlockDoor(int i, boolean isTop, Material material) {
        super(i, material);
        this.isTop = isTop;
        float f = 0.5f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.atlasIndices[side];
        }
        int k = this.getState(meta);
        if ((k == 0 || k == 2) ^ side <= 3) {
            return this.atlasIndices[side];
        }
        int l = k / 2 + (side & 1 ^ k);
        int i1 = this.atlasIndices[side];
        if (((l += (meta & 4) / 4) & 1) != 0) {
            i1 = -i1;
        }
        return i1;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 7;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.getSelectedBoundingBoxFromPool(world, i, j, k);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i, int j, int k) {
        this.setDoorRotation(this.getState(world.getBlockMetadata(i, j, k)));
    }

    public void setDoorRotation(int i) {
        float f = 0.1875f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        if (i == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        }
        if (i == 1) {
            this.setBlockBounds(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (i == 2) {
            this.setBlockBounds(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        }
        if (i == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer entityplayer) {
        if (this.blockMaterial == Material.iron) {
            return false;
        }
        int l = world.getBlockMetadata(x, y, z);
        if (this.isTop) {
            if (Block.blocksList[world.getBlockId(x, y - 1, z)] instanceof BlockDoor) {
                Block.blocksList[world.getBlockId(x, y - 1, z)].blockActivated(world, x, y - 1, z, entityplayer);
            }
            return true;
        }
        if (Block.blocksList[world.getBlockId(x, y + 1, z)] instanceof BlockDoor) {
            world.setBlockMetadataWithNotify(x, y + 1, z, l ^ 4);
        }
        world.setBlockMetadataWithNotify(x, y, z, l ^ 4);
        world.markBlocksDirty(x, y - 1, z, x, y, z);
        world.playSoundEffectForPlayer(entityplayer, 1003, x, y, z, 0);
        return true;
    }

    public void onPoweredBlockChange(World world, int x, int y, int z, boolean isPowered) {
        boolean isOpen;
        int l = world.getBlockMetadata(x, y, z);
        if ((l & 8) > 0) {
            boolean bl = isPowered = !isPowered;
        }
        if (this.isTop) {
            if (Block.blocksList[world.getBlockId(x, y - 1, z)] instanceof BlockDoor) {
                ((BlockDoor)Block.blocksList[world.getBlockId(x, y - 1, z)]).onPoweredBlockChange(world, x, y - 1, z, isPowered);
            }
            return;
        }
        boolean bl = isOpen = (world.getBlockMetadata(x, y, z) & 4) > 0;
        if (isOpen == isPowered) {
            return;
        }
        if (Block.blocksList[world.getBlockId(x, y + 1, z)] instanceof BlockDoor) {
            world.setBlockMetadataWithNotify(x, y + 1, z, l ^ 4);
        }
        world.setBlockMetadataWithNotify(x, y, z, l ^ 4);
        world.markBlocksDirty(x, y - 1, z, x, y, z);
        world.playSoundEffectForPlayer(null, 1003, x, y, z, 0);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        if (this.isTop) {
            Block otherBlock = Block.blocksList[world.getBlockId(i, j - 1, k)];
            if (!(otherBlock instanceof BlockDoor)) {
                world.setBlockWithNotify(i, j, k, 0);
            }
            if (l > 0 && Block.blocksList[l].canProvidePower()) {
                otherBlock.onNeighborBlockChange(world, i, j - 1, k, l);
            }
        } else {
            boolean flag = false;
            Block otherBlock = Block.blocksList[world.getBlockId(i, j + 1, k)];
            if (!(otherBlock instanceof BlockDoor)) {
                world.setBlockWithNotify(i, j, k, 0);
                flag = true;
            }
            if (!world.canPlaceOnSurfaceOfBlock(i, j - 1, k)) {
                world.setBlockWithNotify(i, j, k, 0);
                this.dropBlockAsItem(world, i, j, k, i1);
                flag = true;
                if (otherBlock instanceof BlockDoor) {
                    world.setBlockWithNotify(i, j + 1, k, 0);
                }
            }
            if (flag) {
                if (!world.isMultiplayerAndNotHost) {
                    // empty if block
                }
            } else if (l > 0 && Block.blocksList[l].canProvidePower()) {
                boolean flag1 = world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k);
                this.onPoweredBlockChange(world, i, j, k, flag1);
            }
        }
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        int myId = world.getBlockId(x, y, z);
        int myMetadata = world.getBlockMetadata(x, y, z);
        int upId = world.getBlockId(x, y + 1, z);
        if (myId == Block.doorPlanksOakBottom.blockID && upId == Block.doorPlanksOakBottom.blockID) {
            world.setBlockAndMetadata(x, y + 1, z, Block.doorPlanksOakTop.blockID, myMetadata);
        } else if (myId == Block.doorIronBottom.blockID && upId == Block.doorIronBottom.blockID) {
            world.setBlockAndMetadata(x, y + 1, z, Block.doorIronTop.blockID, myMetadata);
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        if (this.blockMaterial == Material.iron) {
            return Item.doorIron.itemID;
        }
        return Item.doorOak.itemID;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.collisionRayTrace(world, i, j, k, vec3d, vec3d1);
    }

    public int getState(int i) {
        if ((i & 4) == 0) {
            return i - 1 & 3;
        }
        return i & 3;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        if (j >= Minecraft.WORLD_HEIGHT_BLOCKS - 1) {
            return false;
        }
        return world.canPlaceOnSurfaceOfBlock(i, j - 1, k) && super.canPlaceBlockAt(world, i, j, k) && super.canPlaceBlockAt(world, i, j + 1, k);
    }

    public static boolean isOpen(int i) {
        return (i & 4) != 0;
    }

    @Override
    public int getMobilityFlag() {
        return 1;
    }
}

