/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockFarmland
extends Block {
    public BlockFarmland(int i) {
        super(i, Material.ground);
        this.setTickOnLoad(true);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        this.setLightOpacity(255);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int side, int meta) {
        if (side == 1) {
            if (meta > 0) {
                return BlockFarmland.texCoordToIndex(6, 5);
            }
            return BlockFarmland.texCoordToIndex(7, 5);
        }
        return this.atlasIndices[side];
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool(i + 0, j + 0, k + 0, i + 1, j + 1, k + 1);
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.dirt.idDropped(0, random);
    }

    private boolean isCropsNearby(World world, int i, int j, int k) {
        boolean l = false;
        for (int i1 = i - 0; i1 <= i + 0; ++i1) {
            for (int j1 = k - 0; j1 <= k + 0; ++j1) {
                if (world.getBlockId(i1, j + 1, j1) != Block.cropsWheat.blockID) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    private boolean isWaterNearby(World world, int i, int j, int k) {
        for (int l = i - 4; l <= i + 4; ++l) {
            for (int i1 = j; i1 <= j + 1; ++i1) {
                for (int j1 = k - 4; j1 <= k + 4; ++j1) {
                    if (world.getBlockMaterial(l, i1, j1) != Material.water) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void onEntityWalking(World world, int i, int j, int k, Entity entity) {
        if (world.rand.nextInt(4) == 0 && entity instanceof EntityPlayer) {
            if (((EntityPlayer)entity).inventory.armorInventory[0] != null && ((EntityPlayer)entity).inventory.armorInventory[0].getItem() == Item.armorBootsLeather) {
                return;
            }
            world.setBlockWithNotify(i, j, k, Block.dirt.blockID);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        super.onNeighborBlockChange(world, i, j, k, l);
        Material material = world.getBlockMaterial(i, j + 1, k);
        if (material.isSolid()) {
            world.setBlockWithNotify(i, j, k, Block.dirt.blockID);
        }
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (random.nextInt(5) == 0) {
            if (this.isWaterNearby(world, i, j, k) || world.canBlockBeRainedOn(i, j + 1, k)) {
                world.setBlockMetadataWithNotify(i, j, k, 7);
            } else {
                int l = world.getBlockMetadata(i, j, k);
                if (l > 0) {
                    world.setBlockMetadataWithNotify(i, j, k, l - 1);
                } else if (!this.isCropsNearby(world, i, j, k)) {
                    world.setBlockWithNotify(i, j, k, Block.dirt.blockID);
                }
            }
        }
    }
}

