/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.ColorizerWater;
import net.minecraft.src.Entity;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public abstract class BlockFluid
extends Block {
    public BlockFluid(int i, Material material) {
        super(i, material);
        float f = 0.0f;
        float f1 = 0.0f;
        this.setBlockBounds(0.0f + f1, 0.0f + f, 0.0f + f1, 1.0f + f1, 1.0f + f, 1.0f + f1);
        this.setTickOnLoad(true);
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i, int j, int k) {
        if (this.blockMaterial == Material.water && ((Boolean)Minecraft.getMinecraft().gameSettings.biomeWater.value).booleanValue()) {
            double localTemperature = iblockaccess.getWorldChunkManager().getTemperature(i, k);
            double localHumidity = iblockaccess.getWorldChunkManager().getHumidity(i, k);
            return ColorizerWater.getWaterColor(localTemperature, localHumidity);
        }
        return 0xFFFFFF;
    }

    public static float getPercentAir(int i) {
        if (i >= 8) {
            i = 0;
        }
        float f = (float)(i + 1) / 8.0f;
        return f;
    }

    protected int getFlowDecay(World world, int i, int j, int k) {
        if (world.getBlockMaterial(i, j, k) != this.blockMaterial) {
            return -1;
        }
        return world.getBlockMetadata(i, j, k);
    }

    protected int getEffectiveFlowDecay(IBlockAccess iblockaccess, int i, int j, int k) {
        if (iblockaccess.getBlockMaterial(i, j, k) != this.blockMaterial) {
            return -1;
        }
        int l = iblockaccess.getBlockMetadata(i, j, k);
        if (l >= 8) {
            l = 0;
        }
        return l;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean canCollideCheck(int i, boolean flag) {
        return flag && i == 0;
    }

    @Override
    public boolean getIsBlockSolid(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        Material material = iblockaccess.getBlockMaterial(i, j, k);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.ice) {
            return false;
        }
        if (l == 1) {
            return true;
        }
        return super.getIsBlockSolid(iblockaccess, i, j, k, l);
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        Material material = iblockaccess.getBlockMaterial(i, j, k);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.ice) {
            return true;
        }
        if (l == 1) {
            return true;
        }
        return super.shouldSideBeRendered(iblockaccess, i, j, k, l);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public int getRenderType() {
        return 4;
    }

    @Override
    public int idDropped(int i, Random random) {
        return 0;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    private Vec3D getFlowVector(IBlockAccess iblockaccess, int i, int j, int k) {
        Vec3D vec3d = Vec3D.createVector(0.0, 0.0, 0.0);
        int l = this.getEffectiveFlowDecay(iblockaccess, i, j, k);
        for (int i1 = 0; i1 < 4; ++i1) {
            int i2;
            int j1 = i;
            int k1 = j;
            int l1 = k;
            if (i1 == 0) {
                --j1;
            }
            if (i1 == 1) {
                --l1;
            }
            if (i1 == 2) {
                ++j1;
            }
            if (i1 == 3) {
                ++l1;
            }
            if ((i2 = this.getEffectiveFlowDecay(iblockaccess, j1, k1, l1)) < 0) {
                if (iblockaccess.getBlockMaterial(j1, k1, l1).getIsSolid() || (i2 = this.getEffectiveFlowDecay(iblockaccess, j1, k1 - 1, l1)) < 0) continue;
                int j2 = i2 - (l - 8);
                vec3d = vec3d.addVector((j1 - i) * j2, (k1 - j) * j2, (l1 - k) * j2);
                continue;
            }
            if (i2 < 0) continue;
            int k2 = i2 - l;
            vec3d = vec3d.addVector((j1 - i) * k2, (k1 - j) * k2, (l1 - k) * k2);
        }
        if (iblockaccess.getBlockMetadata(i, j, k) >= 8) {
            boolean flag = false;
            if (flag || this.getIsBlockSolid(iblockaccess, i, j, k - 1, 2)) {
                flag = true;
            }
            if (flag || this.getIsBlockSolid(iblockaccess, i, j, k + 1, 3)) {
                flag = true;
            }
            if (flag || this.getIsBlockSolid(iblockaccess, i - 1, j, k, 4)) {
                flag = true;
            }
            if (flag || this.getIsBlockSolid(iblockaccess, i + 1, j, k, 5)) {
                flag = true;
            }
            if (flag || this.getIsBlockSolid(iblockaccess, i, j + 1, k - 1, 2)) {
                flag = true;
            }
            if (flag || this.getIsBlockSolid(iblockaccess, i, j + 1, k + 1, 3)) {
                flag = true;
            }
            if (flag || this.getIsBlockSolid(iblockaccess, i - 1, j + 1, k, 4)) {
                flag = true;
            }
            if (flag || this.getIsBlockSolid(iblockaccess, i + 1, j + 1, k, 5)) {
                flag = true;
            }
            if (flag) {
                vec3d = vec3d.normalize().addVector(0.0, -6.0, 0.0);
            }
        }
        vec3d = vec3d.normalize();
        return vec3d;
    }

    @Override
    public void velocityToAddToEntity(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
        if (entity.noClip) {
            return;
        }
        Vec3D vec3d1 = this.getFlowVector(world, i, j, k);
        vec3d.xCoord += vec3d1.xCoord;
        vec3d.yCoord += vec3d1.yCoord;
        vec3d.zCoord += vec3d1.zCoord;
    }

    @Override
    public int tickRate() {
        if (this.blockMaterial == Material.water) {
            return 5;
        }
        return this.blockMaterial != Material.lava ? 0 : 30;
    }

    @Override
    public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
        float f1;
        if (Minecraft.getMinecraft().fullbright) {
            return 1.0f;
        }
        float f = iblockaccess.getLightBrightness(i, j, k);
        return f <= (f1 = iblockaccess.getLightBrightness(i, j + 1, k)) ? f1 : f;
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        super.updateTick(world, i, j, k, random);
    }

    @Override
    public int getRenderBlockPass() {
        return this.blockMaterial != Material.water ? 0 : 1;
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        int l;
        if (this.blockMaterial == Material.water && random.nextInt(64) == 0 && (l = world.getBlockMetadata(i, j, k)) > 0 && l < 8) {
            world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "liquid.water", random.nextFloat() * 0.25f + 0.75f, random.nextFloat() * 1.0f + 0.5f);
        }
        if (this.blockMaterial == Material.lava && world.getBlockMaterial(i, j + 1, k) == Material.air && !world.isBlockOpaqueCube(i, j + 1, k) && random.nextInt(100) == 0) {
            double d = (float)i + random.nextFloat();
            double d1 = (double)j + this.maxY;
            double d2 = (float)k + random.nextFloat();
            world.spawnParticle("lava", d, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static double func_293_a(IBlockAccess iblockaccess, int i, int j, int k, Material material) {
        Vec3D vec3d = null;
        if (material == Material.water) {
            vec3d = ((BlockFluid)Block.fluidWaterFlowing).getFlowVector(iblockaccess, i, j, k);
        }
        if (material == Material.lava) {
            vec3d = ((BlockFluid)Block.fluidLavaFlowing).getFlowVector(iblockaccess, i, j, k);
        }
        if (vec3d.xCoord == 0.0 && vec3d.zCoord == 0.0) {
            return -1000.0;
        }
        return Math.atan2(vec3d.zCoord, vec3d.xCoord) - 1.5707963267948966;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        this.checkForHarden(world, i, j, k);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        this.checkForHarden(world, i, j, k);
    }

    private void checkForHarden(World world, int i, int j, int k) {
        int l;
        boolean flag;
        if (world.getBlockId(i, j, k) != this.blockID) {
            return;
        }
        if (this.blockMaterial == Material.lava) {
            flag = false;
            if (flag || world.getBlockMaterial(i, j, k - 1) == Material.water) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(i, j, k + 1) == Material.water) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(i - 1, j, k) == Material.water) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(i + 1, j, k) == Material.water) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(i, j + 1, k) == Material.water) {
                flag = true;
            }
            if (flag) {
                l = world.getBlockMetadata(i, j, k);
                if (l == 0) {
                    world.setBlockWithNotify(i, j, k, Block.obsidian.blockID);
                } else if (l <= 2) {
                    world.setBlockWithNotify(i, j, k, Block.cobbleGranite.blockID);
                } else if (l <= 4) {
                    world.setBlockWithNotify(i, j, k, Block.cobbleStone.blockID);
                } else {
                    world.setBlockWithNotify(i, j, k, Block.cobbleBasalt.blockID);
                }
                this.triggerLavaMixEffects(world, i, j, k);
            }
        }
        if (this.blockMaterial == Material.water) {
            flag = false;
            if (flag || world.getBlockMaterial(i, j, k - 1) == Material.lava) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(i, j, k + 1) == Material.lava) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(i - 1, j, k) == Material.lava) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(i + 1, j, k) == Material.lava) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(i, j + 1, k) == Material.lava) {
                flag = true;
            }
            if (flag && (l = world.getBlockMetadata(i, j, k)) == 0) {
                world.setBlockWithNotify(i, j, k, Block.cobbleLimestone.blockID);
                this.triggerLavaMixEffects(world, i, j, k);
            }
        }
    }

    protected void triggerLavaMixEffects(World world, int i, int j, int k) {
        world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            world.spawnParticle("largesmoke", (double)i + Math.random(), (double)j + 1.2, (double)k + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

