/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.Dimension;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockFluidFlowing
extends BlockFluid {
    int numAdjacentSources = 0;
    boolean[] isOptimalFlowDirection = new boolean[4];
    int[] flowCost = new int[4];

    public BlockFluidFlowing(int i, Material material) {
        super(i, material);
    }

    private void func_30003_j(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        world.setBlockAndMetadata(i, j, k, this.blockID + 1, l);
        world.markBlocksDirty(i, j, k, i, j, k);
        world.markBlockNeedsUpdate(i, j, k);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random random) {
        int l = this.getFlowDecay(world, x, y, z);
        int byte0 = 1;
        if (this.blockMaterial == Material.lava && world.dimension != Dimension.nether) {
            byte0 = 2;
        }
        boolean flag = true;
        if (l > 0) {
            int i1 = -100;
            this.numAdjacentSources = 0;
            i1 = this.getSmallestFlowDecay(world, x - 1, y, z, i1);
            i1 = this.getSmallestFlowDecay(world, x + 1, y, z, i1);
            i1 = this.getSmallestFlowDecay(world, x, y, z - 1, i1);
            int j1 = (i1 = this.getSmallestFlowDecay(world, x, y, z + 1, i1)) + byte0;
            if (j1 >= 8 || i1 < 0) {
                j1 = -1;
            }
            if (this.getFlowDecay(world, x, y + 1, z) >= 0) {
                int l1 = this.getFlowDecay(world, x, y + 1, z);
                j1 = l1 >= 8 ? l1 : l1 + 8;
            }
            if (this.numAdjacentSources >= 2 && this.blockMaterial == Material.water) {
                if (world.getBlockMaterial(x, y - 1, z).isSolid()) {
                    j1 = 0;
                } else if (world.getBlockMaterial(x, y - 1, z) == this.blockMaterial && world.getBlockMetadata(x, y - 1, z) == 0) {
                    j1 = 0;
                }
            }
            if (this.blockMaterial == Material.lava && l < 8 && j1 < 8 && j1 > l && random.nextInt(4) != 0) {
                j1 = l;
                flag = false;
            }
            if (j1 != l) {
                l = j1;
                if (l < 0) {
                    world.setBlockWithNotify(x, y, z, 0);
                } else {
                    world.setBlockMetadataWithNotify(x, y, z, l);
                    world.scheduleBlockUpdate(x, y, z, this.blockID, this.tickRate());
                    world.notifyBlocksOfNeighborChange(x, y, z, this.blockID);
                }
            } else if (flag) {
                this.func_30003_j(world, x, y, z);
            }
        } else {
            this.func_30003_j(world, x, y, z);
        }
        if (this.liquidCanDisplaceBlock(world, x, y - 1, z)) {
            int id = world.getBlockId(x, y - 1, z);
            int meta = world.getBlockMetadata(x, y - 1, z);
            if (id > 0) {
                Block.blocksList[id].dropBlockAsItem(world, x, y - 1, z, meta);
            }
            if (l >= 8) {
                world.setBlockAndMetadataWithNotify(x, y - 1, z, this.blockID, l);
            } else {
                world.setBlockAndMetadataWithNotify(x, y - 1, z, this.blockID, l + 8);
            }
        } else if (l >= 0 && (l == 0 || this.blockBlocksFlow(world, x, y - 1, z))) {
            boolean[] aflag = this.getOptimalFlowDirections(world, x, y, z);
            int k1 = l + byte0;
            if (l >= 8) {
                k1 = 1;
            }
            if (k1 >= 8) {
                return;
            }
            if (aflag[0]) {
                this.flowIntoBlock(world, x - 1, y, z, k1);
            }
            if (aflag[1]) {
                this.flowIntoBlock(world, x + 1, y, z, k1);
            }
            if (aflag[2]) {
                this.flowIntoBlock(world, x, y, z - 1, k1);
            }
            if (aflag[3]) {
                this.flowIntoBlock(world, x, y, z + 1, k1);
            }
        }
    }

    private void flowIntoBlock(World world, int i, int j, int k, int l) {
        if (this.liquidCanDisplaceBlock(world, i, j, k)) {
            int i1 = world.getBlockId(i, j, k);
            if (i1 > 0) {
                if (this.blockMaterial == Material.lava) {
                    this.triggerLavaMixEffects(world, i, j, k);
                } else {
                    Block.blocksList[i1].dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
                }
            }
            world.setBlockAndMetadataWithNotify(i, j, k, this.blockID, l);
        }
    }

    private int calculateFlowCost(World world, int i, int j, int k, int l, int i1) {
        int j1 = 1000;
        for (int k1 = 0; k1 < 4; ++k1) {
            int k2;
            if (k1 == 0 && i1 == 1 || k1 == 1 && i1 == 0 || k1 == 2 && i1 == 3 || k1 == 3 && i1 == 2) continue;
            int l1 = i;
            int i2 = j;
            int j2 = k;
            if (k1 == 0) {
                --l1;
            }
            if (k1 == 1) {
                ++l1;
            }
            if (k1 == 2) {
                --j2;
            }
            if (k1 == 3) {
                ++j2;
            }
            if (this.blockBlocksFlow(world, l1, i2, j2) || world.getBlockMaterial(l1, i2, j2) == this.blockMaterial && world.getBlockMetadata(l1, i2, j2) == 0) continue;
            if (!this.blockBlocksFlow(world, l1, i2 - 1, j2)) {
                return l;
            }
            if (l >= 4 || (k2 = this.calculateFlowCost(world, l1, i2, j2, l + 1, k1)) >= j1) continue;
            j1 = k2;
        }
        return j1;
    }

    private boolean[] getOptimalFlowDirections(World world, int i, int j, int k) {
        for (int l = 0; l < 4; ++l) {
            this.flowCost[l] = 1000;
            int j1 = i;
            int i2 = j;
            int j2 = k;
            if (l == 0) {
                --j1;
            }
            if (l == 1) {
                ++j1;
            }
            if (l == 2) {
                --j2;
            }
            if (l == 3) {
                ++j2;
            }
            if (this.blockBlocksFlow(world, j1, i2, j2) || world.getBlockMaterial(j1, i2, j2) == this.blockMaterial && world.getBlockMetadata(j1, i2, j2) == 0) continue;
            this.flowCost[l] = !this.blockBlocksFlow(world, j1, i2 - 1, j2) ? 0 : this.calculateFlowCost(world, j1, i2, j2, 1, l);
        }
        int i1 = this.flowCost[0];
        for (int k1 = 1; k1 < 4; ++k1) {
            if (this.flowCost[k1] >= i1) continue;
            i1 = this.flowCost[k1];
        }
        for (int l1 = 0; l1 < 4; ++l1) {
            this.isOptimalFlowDirection[l1] = this.flowCost[l1] == i1;
        }
        return this.isOptimalFlowDirection;
    }

    private boolean blockBlocksFlow(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j, k);
        if (l == Block.doorPlanksOakBottom.blockID || l == Block.doorIronBottom.blockID || l == Block.doorPlanksOakTop.blockID || l == Block.doorIronTop.blockID || l == Block.signPostPlanksOak.blockID || l == Block.ladderOak.blockID || l == Block.sugarcane.blockID) {
            return true;
        }
        if (l == 0) {
            return false;
        }
        Material material = Block.blocksList[l].blockMaterial;
        return material.getIsSolid();
    }

    protected int getSmallestFlowDecay(World world, int i, int j, int k, int l) {
        int i1 = this.getFlowDecay(world, i, j, k);
        if (i1 < 0) {
            return l;
        }
        if (i1 == 0) {
            ++this.numAdjacentSources;
        }
        if (i1 >= 8) {
            i1 = 0;
        }
        return l >= 0 && i1 >= l ? l : i1;
    }

    private boolean liquidCanDisplaceBlock(World world, int i, int j, int k) {
        Material material = world.getBlockMaterial(i, j, k);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.lava) {
            return false;
        }
        return !this.blockBlocksFlow(world, i, j, k);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        if (world.getBlockId(i, j, k) == this.blockID) {
            world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
        }
    }
}

