/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockFluidStill
extends BlockFluid {
    public BlockFluidStill(int i, Material material) {
        super(i, material);
        this.setTickOnLoad(false);
        if (material == Material.lava) {
            this.setTickOnLoad(true);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        super.onNeighborBlockChange(world, i, j, k, l);
        if (l == 1) {
            return;
        }
        if (world.getBlockId(i, j, k) == this.blockID) {
            this.func_30004_j(world, i, j, k);
        }
    }

    private void func_30004_j(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        world.editingBlocks = true;
        world.setBlockAndMetadata(i, j, k, this.blockID - 1, l);
        world.markBlocksDirty(i, j, k, i, j, k);
        world.scheduleBlockUpdate(i, j, k, this.blockID - 1, this.tickRate());
        world.editingBlocks = false;
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (this.blockMaterial == Material.lava) {
            int l = random.nextInt(3);
            for (int i1 = 0; i1 < l; ++i1) {
                int j1 = world.getBlockId(i += random.nextInt(3) - 1, ++j, k += random.nextInt(3) - 1);
                if (j1 == 0) {
                    if (!this.func_301_k(world, i - 1, j, k) && !this.func_301_k(world, i + 1, j, k) && !this.func_301_k(world, i, j, k - 1) && !this.func_301_k(world, i, j, k + 1) && !this.func_301_k(world, i, j - 1, k) && !this.func_301_k(world, i, j + 1, k)) continue;
                    world.setBlockWithNotify(i, j, k, Block.fire.blockID);
                    return;
                }
                if (!Block.blocksList[j1].blockMaterial.getIsSolid()) continue;
                return;
            }
        }
    }

    private boolean func_301_k(World world, int i, int j, int k) {
        return world.getBlockMaterial(i, j, k).getBurning();
    }
}

