/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockRedstone
extends Block {
    public BlockRedstone(int i, Material material) {
        super(i, material);
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return true;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return this.isPoweringTo(world, i, j, k, l);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        this.func_319_i(world, i, j, k);
    }

    private void func_319_i(World world, int i, int j, int k) {
        Random random = world.rand;
        double d = 0.0625;
        for (int l = 0; l < 6; ++l) {
            double d1 = (float)i + random.nextFloat();
            double d2 = (float)j + random.nextFloat();
            double d3 = (float)k + random.nextFloat();
            if (l == 0 && !world.isBlockOpaqueCube(i, j + 1, k)) {
                d2 = (double)(j + 1) + d;
            }
            if (l == 1 && !world.isBlockOpaqueCube(i, j - 1, k)) {
                d2 = (double)(j + 0) - d;
            }
            if (l == 2 && !world.isBlockOpaqueCube(i, j, k + 1)) {
                d3 = (double)(k + 1) + d;
            }
            if (l == 3 && !world.isBlockOpaqueCube(i, j, k - 1)) {
                d3 = (double)(k + 0) - d;
            }
            if (l == 4 && !world.isBlockOpaqueCube(i + 1, j, k)) {
                d1 = (double)(i + 1) + d;
            }
            if (l == 5 && !world.isBlockOpaqueCube(i - 1, j, k)) {
                d1 = (double)(i + 0) - d;
            }
            if (!(d1 < (double)i || d1 > (double)(i + 1) || d2 < 0.0 || d2 > (double)(j + 1) || d3 < (double)k) && !(d3 > (double)(k + 1))) continue;
            world.spawnParticle("reddust", d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }
}

