/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public abstract class BlockSaplingBase
extends BlockFlower {
    public BlockSaplingBase(int i) {
        super(i);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
    }

    @Override
    public boolean canThisPlantGrowOnThisBlockID(int i) {
        return i == Block.sand.blockID || super.canThisPlantGrowOnThisBlockID(i);
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        if (world.getBlockId(i, j - 1, k) == Block.sand.blockID) {
            world.setBlockWithNotify(i, j, k, Block.deadbush.blockID);
        }
        super.updateTick(world, i, j, k, random);
        int growthRate = 30;
        if (world.currentSeason != null) {
            growthRate = MathHelper.floor_float((float)growthRate / world.currentSeason.cropGrowthFactor);
        }
        if (world.getBlockLightValue(i, j + 1, k) >= 9 && random.nextInt(growthRate) == 0) {
            int l = world.getBlockMetadata(i, j, k);
            if ((l & 8) == 0) {
                world.setBlockMetadataWithNotify(i, j, k, l | 8);
            } else {
                this.growTree(world, i, j, k, random);
            }
        }
    }

    public abstract void growTree(World var1, int var2, int var3, int var4, Random var5);
}

