/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSaplingBase;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenTreeShapeTaigaBushy;
import net.minecraft.src.WorldGenTreeShapeTaigaTall;
import net.minecraft.src.WorldGenerator;

public class BlockSaplingPine
extends BlockSaplingBase {
    public BlockSaplingPine(int i) {
        super(i);
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        super.updateTick(world, i, j, k, random);
        int growthRate = 30;
        if (world.getBlockLightValue(i, j + 1, k) >= 9 && random.nextInt(growthRate) == 0) {
            int l = world.getBlockMetadata(i, j, k);
            if ((l & 8) == 0) {
                world.setBlockMetadataWithNotify(i, j, k, l | 8);
            } else {
                this.growTree(world, i, j, k, random);
            }
        }
    }

    @Override
    public void growTree(World world, int i, int j, int k, Random random) {
        WorldGenTreeShapeTaigaTall treeBig = new WorldGenTreeShapeTaigaTall(Block.leavesPine.blockID, Block.logPine.blockID);
        WorldGenTreeShapeTaigaBushy treeSmall = new WorldGenTreeShapeTaigaBushy(Block.leavesPine.blockID, Block.logPine.blockID);
        world.setBlock(i, j, k, 0);
        if (!((WorldGenerator)treeSmall).generate(world, random, i, j, k) && !((WorldGenerator)treeBig).generate(world, random, i, j, k)) {
            world.setBlock(i, j, k, this.blockID);
        }
    }
}

