/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainerRotatable;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntitySensor;
import net.minecraft.src.World;

public class BlockSensor
extends BlockContainerRotatable {
    private boolean isActive;

    public BlockSensor(int i, boolean isActive) {
        super(i, Material.glass);
        this.isActive = isActive;
    }

    @Override
    public int getBlockOverbright(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (!this.isActive) {
            return -1;
        }
        int i1 = iblockaccess.getBlockMetadata(i, j, k);
        if (l == i1) {
            return BlockSensor.texCoordToIndex(1, 16);
        }
        return -1;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        this.setDefaultDirection(world, i, j, k);
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (!this.isActive) {
            return;
        }
        BlockSensor.spawnParticles(world, i, j, k);
    }

    public static void updateSensorBlockState(boolean flag, World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        if (flag) {
            world.setBlockWithNotify(x, y, z, Block.motionsensorActive.blockID);
        }
        if (!flag) {
            world.setBlockWithNotify(x, y, z, Block.motionsensorIdle.blockID);
        }
        world.setBlockMetadataWithNotify(x, y, z, l);
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        super.onBlockRemoval(world, i, j, k);
    }

    private static void spawnParticles(World world, int i, int j, int k) {
        Random random = world.rand;
        double d = 0.0625;
        for (int l = 0; l < 6; ++l) {
            double d1 = (float)i + random.nextFloat();
            double d2 = (float)j + random.nextFloat();
            double d3 = (float)k + random.nextFloat();
            if (l == 0 && !world.isBlockOpaqueCube(i, j + 1, k)) {
                d2 = (double)(j + 1) + d;
            }
            if (l == 1 && !world.isBlockOpaqueCube(i, j - 1, k)) {
                d2 = (double)j - d;
            }
            if (l == 2 && !world.isBlockOpaqueCube(i, j, k + 1)) {
                d3 = (double)(k + 1) + d;
            }
            if (l == 3 && !world.isBlockOpaqueCube(i, j, k - 1)) {
                d3 = (double)k - d;
            }
            if (l == 4 && !world.isBlockOpaqueCube(i + 1, j, k)) {
                d1 = (double)(i + 1) + d;
            }
            if (l == 5 && !world.isBlockOpaqueCube(i - 1, j, k)) {
                d1 = (double)i - d;
            }
            if (!(d1 < (double)i || d1 > (double)(i + 1) || d2 < 0.0 || d2 > (double)(j + 1) || d3 < (double)k) && !(d3 > (double)(k + 1))) continue;
            world.spawnParticle("reddust", d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return this.isPoweringTo(world, i, j, k, l);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return this.isActive;
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.motionsensorIdle.blockID;
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntitySensor();
    }
}

