/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockWeb;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class BlockSpikes
extends BlockWeb {
    public BlockSpikes(int i, Material mat) {
        super(i, mat);
    }

    @Override
    public int getRenderType() {
        return 19;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        return world.canPlaceOnSurfaceOfBlock(i, j - 1, k) || world.getBlockId(i, j - 1, k) == Block.mobspawner.blockID;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        boolean flag;
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        boolean bl = flag = !world.canPlaceOnSurfaceOfBlock(i, j - 1, k) && world.getBlockId(i, j - 1, k) != Block.mesh.blockID && world.getBlockId(i, j - 1, k) != Block.mobspawner.blockID;
        if (flag) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        }
        if (l > 0 && Block.blocksList[l].canProvidePower()) {
            boolean isPowered = world.isBlockIndirectlyGettingPowered(i, j, k);
            this.onPoweredBlockChange(world, i, j, k, isPowered);
        }
    }

    public void onPoweredBlockChange(World world, int i, int j, int k, boolean isPowered) {
        boolean flag1;
        int l = world.getBlockMetadata(i, j, k);
        boolean bl = flag1 = (l & 1) > 0;
        if (flag1 == isPowered) {
            return;
        }
        world.setBlockMetadataWithNotify(i, j, k, l ^ 1);
        if ((l & 1) < 1) {
            world.playSoundEffectForPlayer(null, 1006, i, j, k, 0);
        } else {
            world.playSoundEffectForPlayer(null, 1007, i, j, k, 0);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        float f = 0.0625f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)x + f, y, (float)z + f, (float)(x + 1) - f, (float)y + 0.1875f, (float)(z + 1) - f);
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        int metaData = world.getBlockMetadata(i, j, k);
        if (BlockSpikes.isSpikesUp(metaData) && entity instanceof EntityLiving) {
            if (entity instanceof EntityPlayer && entity.isSneaking()) {
                return;
            }
            entity.attackEntityFrom(null, 5, DamageType.COMBAT);
            entity.isInWeb = true;
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        return this.blockID;
    }

    public static boolean isSpikesUp(int i) {
        return (i & 1) != 1;
    }
}

