/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Dimension;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockSponge
extends Block {
    boolean isWet;

    public BlockSponge(int i, boolean isWet) {
        super(i, Material.sponge);
        this.isWet = isWet;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        int l;
        super.onBlockAdded(world, i, j, k);
        int byte0 = 2;
        if (world.dimension.dimId == Dimension.nether.dimId && this.isWet) {
            world.setBlockWithNotify(i, j, k, Block.spongeDry.blockID);
            world.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            for (l = 0; l < 8; ++l) {
                world.spawnParticle("largesmoke", (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
        }
        if (!this.isWet && this.inWater(world, i, j, k)) {
            for (l = i - byte0; l <= i + byte0; ++l) {
                for (int i1 = j - byte0; i1 <= j + byte0; ++i1) {
                    for (int j1 = k - byte0; j1 <= k + byte0; ++j1) {
                        if (world.getBlockMaterial(l, i1, j1) != Material.water) continue;
                        world.setBlockWithNotify(l, i1, j1, 0);
                    }
                }
            }
        }
    }

    public boolean inWater(World world, int x, int y, int z) {
        if (world.getBlockMaterial(x + 1, y, z) == Material.water) {
            return true;
        }
        if (world.getBlockMaterial(x - 1, y, z) == Material.water) {
            return true;
        }
        if (world.getBlockMaterial(x, y + 1, z) == Material.water) {
            return true;
        }
        if (world.getBlockMaterial(x, y - 1, z) == Material.water) {
            return true;
        }
        if (world.getBlockMaterial(x, y, z + 1) == Material.water) {
            return true;
        }
        return world.getBlockMaterial(x, y, z - 1) == Material.water;
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        if (!this.isWet) {
            int byte0 = 2;
            for (int l = i - byte0; l <= i + byte0; ++l) {
                for (int i1 = j - byte0; i1 <= j + byte0; ++i1) {
                    for (int j1 = k - byte0; j1 <= k + byte0; ++j1) {
                        world.notifyBlocksOfNeighborChange(l, i1, j1, world.getBlockId(l, i1, j1));
                    }
                }
            }
        }
    }
}

