/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class BlockStairs
extends Block {
    private Block modelBlock;

    public BlockStairs(int i, Block block) {
        super(i, block.blockMaterial);
        this.modelBlock = block;
        this.atlasIndices = block.atlasIndices;
        this.setHardness(block.blockHardness);
        this.setResistance(block.blockResistance / 3.0f);
        this.setStepSound(block.stepSound);
        this.setLightOpacity(255);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i, int j, int k) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return super.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 10;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return super.shouldSideBeRendered(iblockaccess, i, j, k, l);
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, ArrayList arraylist) {
        int l = world.getBlockMetadata(i, j, k) & 3;
        if (l == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
        } else if (l == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
        } else if (l == 2) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        this.modelBlock.randomDisplayTick(world, i, j, k, random);
    }

    @Override
    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        this.modelBlock.onBlockClicked(world, i, j, k, entityplayer);
    }

    @Override
    public void onBlockDestroyedByPlayer(World world, int i, int j, int k, int l) {
        this.modelBlock.onBlockDestroyedByPlayer(world, i, j, k, l);
    }

    @Override
    public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
        return this.modelBlock.getBlockBrightness(iblockaccess, i, j, k);
    }

    @Override
    public float getExplosionResistance(Entity entity) {
        return this.modelBlock.getExplosionResistance(entity);
    }

    @Override
    public int getRenderBlockPass() {
        return this.modelBlock.getRenderBlockPass();
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return this.modelBlock.quantityDropped(metadata, random);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        return this.modelBlock.getBlockTextureFromSideAndMetadata(i, j);
    }

    @Override
    public int getBlockTextureFromSide(int i) {
        return this.modelBlock.getBlockTextureFromSide(i);
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return this.modelBlock.getBlockTexture(iblockaccess, i, j, k, l);
    }

    @Override
    public int tickRate() {
        return this.modelBlock.tickRate();
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return this.modelBlock.getSelectedBoundingBoxFromPool(world, i, j, k);
    }

    @Override
    public void velocityToAddToEntity(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
        this.modelBlock.velocityToAddToEntity(world, i, j, k, entity, vec3d);
    }

    @Override
    public boolean isCollidable() {
        return this.modelBlock.isCollidable();
    }

    @Override
    public boolean canCollideCheck(int i, boolean flag) {
        return this.modelBlock.canCollideCheck(i, flag);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        return this.modelBlock.canPlaceBlockAt(world, i, j, k);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        this.onNeighborBlockChange(world, i, j, k, 0);
        this.modelBlock.onBlockAdded(world, i, j, k);
    }

    @Override
    public void onEntityWalking(World world, int i, int j, int k, Entity entity) {
        this.modelBlock.onEntityWalking(world, i, j, k, entity);
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        this.modelBlock.updateTick(world, i, j, k, random);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return this.modelBlock.blockActivated(world, i, j, k, entityplayer);
    }

    @Override
    public void onBlockDestroyedByExplosion(World world, int i, int j, int k) {
        this.modelBlock.onBlockDestroyedByExplosion(world, i, j, k);
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Direction side, EntityLiving player, double sideHeight) {
        int rotation = player.getHorizontalPlacementDirection(side).getIndex();
        if (rotation == 0) {
            world.setBlockMetadataWithNotify(x, y, z, 2 | world.getBlockMetadata(x, y, z) & 0xF0);
        }
        if (rotation == 1) {
            world.setBlockMetadataWithNotify(x, y, z, 1 | world.getBlockMetadata(x, y, z) & 0xF0);
        }
        if (rotation == 2) {
            world.setBlockMetadataWithNotify(x, y, z, 3 | world.getBlockMetadata(x, y, z) & 0xF0);
        }
        if (rotation == 3) {
            world.setBlockMetadataWithNotify(x, y, z, 0 | world.getBlockMetadata(x, y, z) & 0xF0);
        }
    }
}

