/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockSugarcane
extends Block {
    public BlockSugarcane(int i) {
        super(i, Material.plants);
        float f = 0.375f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        this.setTickOnLoad(true);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random random) {
        if (world.isAirBlock(x, y + 1, z)) {
            int l = 1;
            while (world.getBlockId(x, y - l, z) == this.blockID) {
                ++l;
            }
            if (l < 3) {
                int i1 = world.getBlockMetadata(x, y, z);
                if (i1 == 15) {
                    world.setBlockWithNotify(x, y + 1, z, this.blockID);
                    world.setBlockMetadataWithNotify(x, y, z, 0);
                } else {
                    world.setBlockMetadataWithNotify(x, y, z, i1 + 1);
                }
            }
        }
    }

    public void growReedOnTop(World world, int x, int y, int z) {
        int l = 1;
        while (world.getBlockId(x, y + l, z) == this.blockID) {
            ++l;
        }
        if (world.isAirBlock(x, y + l, z)) {
            world.setBlockWithNotify(x, y + l, z, this.blockID);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j - 1, k);
        if (l == this.blockID) {
            return true;
        }
        if (Block.blocksList[l] == null || !Block.blocksList[l].plantable) {
            return false;
        }
        if (world.getBlockMaterial(i - 1, j - 1, k) == Material.water) {
            return true;
        }
        if (world.getBlockMaterial(i + 1, j - 1, k) == Material.water) {
            return true;
        }
        if (world.getBlockMaterial(i, j - 1, k - 1) == Material.water) {
            return true;
        }
        return world.getBlockMaterial(i, j - 1, k + 1) == Material.water;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        this.checkBlockCoordValid(world, i, j, k);
    }

    protected final void checkBlockCoordValid(World world, int i, int j, int k) {
        if (!this.canBlockStay(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        }
    }

    @Override
    public boolean canBlockStay(World world, int i, int j, int k) {
        return this.canPlaceBlockAt(world, i, j, k);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public int idDropped(int i, Random random) {
        return Item.sugarcane.itemID;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 1;
    }
}

