/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainerRotatable;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityTrommel;
import net.minecraft.src.World;

public class BlockTrommel
extends BlockContainerRotatable {
    private boolean isActive;
    protected static boolean keepTrommelInventory = false;
    private Random random;

    public BlockTrommel(int i, Material material, boolean isActive) {
        super(i, material);
        this.isActive = isActive;
        this.random = new Random();
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        this.setDefaultDirection(world, i, j, k);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (!world.isMultiplayerAndNotHost) {
            TileEntityTrommel tileEntityTrommel = (TileEntityTrommel)world.getBlockTileEntity(i, j, k);
            entityplayer.displayGUITrommel(tileEntityTrommel);
        }
        return true;
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (!this.isActive) {
            return;
        }
        float f = (float)i + random.nextFloat();
        float f6 = (float)j + random.nextFloat() * 0.5f + 1.0f;
        float f12 = (float)k + random.nextFloat();
        world.spawnParticle("smoke", f, f6, f12, 0.0, 0.0, 0.0);
    }

    public static void updateTrommelBlockState(boolean flag, World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        TileEntity tileentity = world.getBlockTileEntity(i, j, k);
        keepTrommelInventory = true;
        if (flag) {
            world.setBlockWithNotify(i, j, k, Block.trommelActive.blockID);
        } else {
            world.setBlockWithNotify(i, j, k, Block.trommelIdle.blockID);
        }
        keepTrommelInventory = false;
        world.setBlockMetadataWithNotify(i, j, k, l);
        tileentity.validate();
        world.setBlockTileEntity(i, j, k, tileentity);
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.trommelIdle.blockID;
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        if (!keepTrommelInventory && world.getBlockTileEntity(i, j, k) != null) {
            TileEntityTrommel tileentitytrommel = (TileEntityTrommel)world.getBlockTileEntity(i, j, k);
            for (int l = 0; l < tileentitytrommel.getSizeInventory(); ++l) {
                ItemStack itemstack = tileentitytrommel.getStackInSlot(l);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.random.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)i + f, (float)j + f1, (float)k + f2, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.random.nextGaussian() * f3;
                    entityitem.motionY = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.random.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(world, i, j, k);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityTrommel();
    }
}

