/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ICrafting;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import net.minecraft.src.SlotCreative;
import net.minecraft.src.helper.Listener;

public abstract class Container {
    public List<ItemStack> inventoryItemStacks = new ArrayList<ItemStack>();
    public List<Slot> inventorySlots = new ArrayList<Slot>();
    public int windowId = 0;
    private short field_20917_a = 0;
    protected List<ICrafting> crafters = new ArrayList<ICrafting>();
    private Set<EntityPlayer> field_20918_b = new HashSet<EntityPlayer>();
    public Listener<Slot> slotUpdateListener;

    protected void addSlot(Slot slot) {
        slot.id = this.inventorySlots.size();
        this.inventorySlots.add(slot);
        this.inventoryItemStacks.add(null);
    }

    public void onContainerInit(ICrafting icrafting) {
        if (this.crafters.contains(icrafting)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.crafters.add(icrafting);
        icrafting.updateCraftingInventory(this, this.func_28127_b());
        this.updateInventory();
    }

    public List<ItemStack> func_28127_b() {
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            arraylist.add(this.inventorySlots.get(i).getStack());
        }
        return arraylist;
    }

    public void updateInventory() {
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            ItemStack itemstack = this.inventorySlots.get(i).getStack();
            ItemStack itemstack1 = this.inventoryItemStacks.get(i);
            if (ItemStack.areItemStacksEqual(itemstack1, itemstack)) continue;
            itemstack1 = itemstack != null ? itemstack.copy() : null;
            this.inventoryItemStacks.set(i, itemstack1);
            for (int j = 0; j < this.crafters.size(); ++j) {
                this.crafters.get(j).updateInventorySlot(this, i, itemstack1);
            }
        }
    }

    public Slot func_20127_a(IInventory iinventory, int i) {
        for (int j = 0; j < this.inventorySlots.size(); ++j) {
            Slot slot = this.inventorySlots.get(j);
            if (!slot.isHere(iinventory, i)) continue;
            return slot;
        }
        return null;
    }

    public Slot getSlot(int i) {
        try {
            return this.inventorySlots.get(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    public abstract void quickMoveItems(int var1, EntityPlayer var2, boolean var3, boolean var4);

    public ItemStack clickInventorySlot(int slotID, int button, boolean shift, boolean control, EntityPlayer player) {
        if (button < 0 || button > 1) {
            this.onCraftMatrixChanged(null);
            return null;
        }
        InventoryPlayer inventoryplayer = player.inventory;
        if (slotID == -999) {
            if (inventoryplayer.getHeldItemStack() != null && slotID == -999) {
                if (button == 0) {
                    player.dropPlayerItem(inventoryplayer.getHeldItemStack());
                    inventoryplayer.setHeldItemStack(null);
                }
                if (button == 1) {
                    player.dropPlayerItem(inventoryplayer.getHeldItemStack().splitStack(1));
                    if (inventoryplayer.getHeldItemStack().stackSize == 0) {
                        inventoryplayer.setHeldItemStack(null);
                    }
                }
            }
            this.onCraftMatrixChanged(inventoryplayer);
            return null;
        }
        Slot slot = this.getSlot(slotID);
        if (slot == null) {
            this.onCraftMatrixChanged(inventoryplayer);
            return null;
        }
        boolean isCreativeSlot = slot instanceof SlotCreative;
        ItemStack clickedItemStack = null;
        if (!(!shift && !control || isCreativeSlot && inventoryplayer.getHeldItemStack() != null)) {
            if (slot.getStack() == null) {
                return null;
            }
            clickedItemStack = slot.getStack().copy();
            this.quickMoveItems(slotID, player, shift, control);
            this.onCraftMatrixChanged(player.inventory);
            return clickedItemStack;
        }
        slot.onSlotChanged();
        ItemStack stackInSlot = slot.getStack();
        ItemStack stackInHand = inventoryplayer.getHeldItemStack();
        if (stackInSlot != null) {
            if (isCreativeSlot) {
                if (stackInHand != null && stackInHand.canStackWith(stackInSlot)) {
                    clickedItemStack = stackInHand.copy();
                    if (stackInHand.stackSize < stackInHand.getMaxStackSize()) {
                        clickedItemStack.stackSize = shift ? clickedItemStack.getMaxStackSize() : ++clickedItemStack.stackSize;
                    }
                    inventoryplayer.setHeldItemStack(clickedItemStack);
                    return clickedItemStack;
                }
                if (stackInHand != null) {
                    clickedItemStack = null;
                    inventoryplayer.setHeldItemStack(clickedItemStack);
                    return clickedItemStack;
                }
            } else {
                clickedItemStack = stackInSlot.copy();
            }
        }
        if (stackInSlot == null) {
            if (stackInHand != null && slot.canPutStackInSlot(stackInHand)) {
                int i1;
                int n = i1 = button != 0 ? 1 : stackInHand.stackSize;
                if (i1 > slot.getSlotStackLimit()) {
                    i1 = slot.getSlotStackLimit();
                }
                slot.putStack(stackInHand.splitStack(i1));
                if (stackInHand.stackSize == 0) {
                    inventoryplayer.setHeldItemStack(null);
                }
            }
        } else if (stackInHand == null) {
            int j1 = button != 0 ? (stackInSlot.stackSize + 1) / 2 : stackInSlot.stackSize;
            ItemStack itemstack5 = slot.decrStackSize(j1);
            inventoryplayer.setHeldItemStack(itemstack5);
            if (stackInSlot.stackSize == 0) {
                slot.putStack(null);
            }
            slot.onPickupFromSlot(inventoryplayer.getHeldItemStack());
        } else if (slot.canPutStackInSlot(stackInHand)) {
            if (!stackInSlot.canStackWith(stackInHand)) {
                if (stackInHand.stackSize <= slot.getSlotStackLimit()) {
                    ItemStack itemstack4 = stackInSlot;
                    slot.putStack(stackInHand);
                    inventoryplayer.setHeldItemStack(itemstack4);
                }
            } else {
                int splitSize;
                int n = splitSize = button != 0 ? 1 : stackInHand.stackSize;
                if (splitSize > slot.getSlotStackLimit() - stackInSlot.stackSize) {
                    splitSize = slot.getSlotStackLimit() - stackInSlot.stackSize;
                }
                if (splitSize > stackInHand.getMaxStackSize() - stackInSlot.stackSize) {
                    splitSize = stackInHand.getMaxStackSize() - stackInSlot.stackSize;
                }
                stackInHand.splitStack(splitSize);
                if (stackInHand.stackSize == 0) {
                    inventoryplayer.setHeldItemStack(null);
                }
                stackInSlot.stackSize += splitSize;
            }
        } else if (stackInSlot.canStackWith(stackInHand) && stackInSlot.stackSize + stackInHand.stackSize <= stackInHand.getMaxStackSize()) {
            ItemStack craftedStack = stackInSlot;
            slot.putStack(null);
            slot.onPickupFromSlot(craftedStack);
            if (craftedStack.canStackWith(stackInHand) && stackInHand.stackSize + craftedStack.stackSize <= stackInHand.getMaxStackSize()) {
                stackInHand.stackSize += craftedStack.stackSize;
            } else {
                player.dropPlayerItem(craftedStack);
            }
        }
        this.onCraftMatrixChanged(player.inventory);
        return clickedItemStack;
    }

    public void onCraftGuiClosed(EntityPlayer entityplayer) {
        InventoryPlayer inventoryplayer = entityplayer.inventory;
        if (inventoryplayer.getHeldItemStack() != null) {
            entityplayer.dropPlayerItem(inventoryplayer.getHeldItemStack());
            inventoryplayer.setHeldItemStack(null);
        }
    }

    public void onCraftMatrixChanged(IInventory iinventory) {
        this.updateInventory();
    }

    public boolean getCanCraft(EntityPlayer entityplayer) {
        return !this.field_20918_b.contains(entityplayer);
    }

    public void setCanCraft(EntityPlayer entityplayer, boolean flag) {
        if (flag) {
            this.field_20918_b.remove(entityplayer);
        } else {
            this.field_20918_b.add(entityplayer);
        }
    }

    public void putStackInSlot(int i, ItemStack itemstack) {
        this.getSlot(i).putStack(itemstack);
    }

    public void putStacksInSlots(ItemStack[] aitemstack) {
        for (int i = 0; i < aitemstack.length; ++i) {
            this.getSlot(i).putStack(aitemstack[i]);
        }
    }

    public void updateClientProgressBar(int id, int value) {
    }

    public short func_20111_a(InventoryPlayer inventoryplayer) {
        this.field_20917_a = (short)(this.field_20917_a + 1);
        return this.field_20917_a;
    }

    public void func_20113_a(short word0) {
    }

    public void func_20110_b(short word0) {
    }

    public abstract boolean isUsableByPlayer(EntityPlayer var1);

    protected boolean onStackMergeShiftClick(ItemStack itemStack, int minSlot, int maxSlot, boolean sendToLastSlot) {
        ItemStack iStack;
        Slot iSlot;
        int i;
        if (itemStack == null) {
            return false;
        }
        boolean insert = false;
        for (i = minSlot; i < maxSlot; ++i) {
            ItemStack stack = this.getSlot(i).getStack();
            if (stack != null && (!itemStack.canStackWith(stack) || stack.stackSize >= stack.getMaxStackSize())) continue;
            insert = true;
            break;
        }
        if (!insert) {
            return false;
        }
        for (i = 0; i < maxSlot - minSlot; ++i) {
            int a;
            iSlot = this.getSlot(sendToLastSlot ? maxSlot - 1 - i : minSlot + i);
            iStack = iSlot.getStack();
            if (!itemStack.canStackWith(iStack) || iStack == null || iStack.stackSize >= iStack.getMaxStackSize() || (a = Math.max(0, Math.min(iStack.getMaxStackSize() - iStack.stackSize, itemStack.stackSize))) <= 0) continue;
            itemStack.stackSize -= a;
            iStack.stackSize += a;
            iSlot.onSlotChanged();
            if (itemStack.stackSize == 0) break;
        }
        if (itemStack.stackSize == 0) {
            return true;
        }
        for (i = 0; i < maxSlot - minSlot; ++i) {
            iSlot = this.getSlot(sendToLastSlot ? maxSlot - 1 - i : minSlot + i);
            iStack = iSlot.getStack();
            if (iStack != null) continue;
            iSlot.putStack(itemStack.copy());
            itemStack.stackSize = 0;
            iSlot.onSlotChanged();
            break;
        }
        return true;
    }
}

