/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Packet;
import net.minecraft.src.WatchableObject;

public class DataWatcher {
    private static final HashMap dataTypes = new HashMap();
    private final Map watchedObjects = new HashMap();
    private boolean objectChanged;

    public void addObject(int i, Object obj) {
        Integer integer = (Integer)dataTypes.get(obj.getClass());
        if (integer == null) {
            throw new IllegalArgumentException("Unknown data type: " + obj.getClass());
        }
        if (i > 31) {
            throw new IllegalArgumentException("Data value id is too big with " + i + "! (Max is " + 31 + ")");
        }
        if (this.watchedObjects.containsKey(i)) {
            throw new IllegalArgumentException("Duplicate id value for " + i + "!");
        }
        WatchableObject watchableobject = new WatchableObject(integer, i, obj);
        this.watchedObjects.put(i, watchableobject);
    }

    public byte getWatchableObjectByte(int i) {
        return (Byte)((WatchableObject)this.watchedObjects.get(i)).getObject();
    }

    public short getWatchableObjectShort(int i) {
        return (Short)((WatchableObject)this.watchedObjects.get(i)).getObject();
    }

    public int getWatchableObjectInt(int i) {
        return (Integer)((WatchableObject)this.watchedObjects.get(i)).getObject();
    }

    public String getWatchableObjectString(int i) {
        return (String)((WatchableObject)this.watchedObjects.get(i)).getObject();
    }

    public void updateObject(int i, Object obj) {
        WatchableObject watchableobject = (WatchableObject)this.watchedObjects.get(i);
        if (!obj.equals(watchableobject.getObject())) {
            watchableobject.setObject(obj);
            watchableobject.setWatching(true);
            this.objectChanged = true;
        }
    }

    public boolean hasObjectChanged() {
        return this.objectChanged;
    }

    public static void writeObjectsInListToStream(List list, DataOutputStream dataoutputstream) throws IOException {
        if (list != null) {
            for (WatchableObject watchableobject : list) {
                DataWatcher.writeWatchableObject(dataoutputstream, watchableobject);
            }
        }
        dataoutputstream.writeByte(127);
    }

    public ArrayList getChangedObjects() {
        ArrayList<WatchableObject> arraylist = null;
        if (this.objectChanged) {
            for (WatchableObject watchableobject : this.watchedObjects.values()) {
                if (!watchableobject.getWatching()) continue;
                watchableobject.setWatching(false);
                if (arraylist == null) {
                    arraylist = new ArrayList<WatchableObject>();
                }
                arraylist.add(watchableobject);
            }
        }
        this.objectChanged = false;
        return arraylist;
    }

    public void writeWatchableObjects(DataOutputStream dataoutputstream) throws IOException {
        for (WatchableObject watchableobject : this.watchedObjects.values()) {
            DataWatcher.writeWatchableObject(dataoutputstream, watchableobject);
        }
        dataoutputstream.writeByte(127);
    }

    private static void writeWatchableObject(DataOutputStream dataoutputstream, WatchableObject watchableobject) throws IOException {
        int i = (watchableobject.getObjectType() << 5 | watchableobject.getDataValueId() & 0x1F) & 0xFF;
        dataoutputstream.writeByte(i);
        switch (watchableobject.getObjectType()) {
            case 0: {
                dataoutputstream.writeByte(((Byte)watchableobject.getObject()).byteValue());
                break;
            }
            case 1: {
                dataoutputstream.writeShort(((Short)watchableobject.getObject()).shortValue());
                break;
            }
            case 2: {
                dataoutputstream.writeInt((Integer)watchableobject.getObject());
                break;
            }
            case 3: {
                dataoutputstream.writeFloat(((Float)watchableobject.getObject()).floatValue());
                break;
            }
            case 4: {
                Packet.writeString((String)watchableobject.getObject(), dataoutputstream);
                break;
            }
            case 5: {
                ItemStack itemstack = (ItemStack)watchableobject.getObject();
                dataoutputstream.writeShort(itemstack.getItem().itemID);
                dataoutputstream.writeByte(itemstack.stackSize);
                dataoutputstream.writeShort(itemstack.getMetadata());
                break;
            }
            case 6: {
                ChunkCoordinates chunkcoordinates = (ChunkCoordinates)watchableobject.getObject();
                dataoutputstream.writeInt(chunkcoordinates.x);
                dataoutputstream.writeInt(chunkcoordinates.y);
                dataoutputstream.writeInt(chunkcoordinates.z);
            }
        }
    }

    public static List readWatchableObjects(DataInputStream datainputstream) throws IOException {
        ArrayList<WatchableObject> arraylist = null;
        byte byte0 = datainputstream.readByte();
        while (byte0 != 127) {
            if (arraylist == null) {
                arraylist = new ArrayList<WatchableObject>();
            }
            int i = (byte0 & 0xE0) >> 5;
            int j = byte0 & 0x1F;
            WatchableObject watchableobject = null;
            switch (i) {
                case 0: {
                    watchableobject = new WatchableObject(i, j, datainputstream.readByte());
                    break;
                }
                case 1: {
                    watchableobject = new WatchableObject(i, j, datainputstream.readShort());
                    break;
                }
                case 2: {
                    watchableobject = new WatchableObject(i, j, datainputstream.readInt());
                    break;
                }
                case 3: {
                    watchableobject = new WatchableObject(i, j, Float.valueOf(datainputstream.readFloat()));
                    break;
                }
                case 4: {
                    watchableobject = new WatchableObject(i, j, Packet.readString(datainputstream, 64));
                    break;
                }
                case 5: {
                    short word0 = datainputstream.readShort();
                    byte byte1 = datainputstream.readByte();
                    short word1 = datainputstream.readShort();
                    watchableobject = new WatchableObject(i, j, new ItemStack(word0, (int)byte1, (int)word1));
                    break;
                }
                case 6: {
                    int k = datainputstream.readInt();
                    int l = datainputstream.readInt();
                    int i1 = datainputstream.readInt();
                    watchableobject = new WatchableObject(i, j, new ChunkCoordinates(k, l, i1));
                }
            }
            arraylist.add(watchableobject);
            byte0 = datainputstream.readByte();
        }
        return arraylist;
    }

    public void updateWatchedObjectsFromList(List list) {
        for (WatchableObject watchableobject : list) {
            WatchableObject watchableobject1 = (WatchableObject)this.watchedObjects.get(watchableobject.getDataValueId());
            if (watchableobject1 == null) continue;
            watchableobject1.setObject(watchableobject.getObject());
        }
    }

    static Class _mthclass$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }

    static {
        dataTypes.put(Byte.class, 0);
        dataTypes.put(Short.class, 1);
        dataTypes.put(Integer.class, 2);
        dataTypes.put(Float.class, 3);
        dataTypes.put(String.class, 4);
        dataTypes.put(ItemStack.class, 5);
        dataTypes.put(ChunkCoordinates.class, 6);
    }
}

