/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityCreature;
import net.minecraft.src.IAnimals;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Season;
import net.minecraft.src.World;

public abstract class EntityAnimal
extends EntityCreature
implements IAnimals {
    public EntityAnimal(World world) {
        super(world);
        this.scoreValue = 10;
    }

    @Override
    public int getMaxSpawnedInChunk() {
        if (this.worldObj.getCurrentSeason() == Season.surfaceSpring) {
            return 8;
        }
        if (this.worldObj.getCurrentSeason() == Season.surfaceWinter) {
            return 1;
        }
        return 4;
    }

    @Override
    protected float getBlockPathWeight(int i, int j, int k) {
        if (this.worldObj.getBlockId(i, j - 1, k) == Block.grass.blockID) {
            return 10.0f;
        }
        return this.worldObj.getLightBrightness(i, j, k) - 0.5f;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
    }

    @Override
    public boolean getCanSpawnHere() {
        int k;
        int j;
        int i = MathHelper.floor_double(this.posX);
        return this.worldObj.getBlockId(i, (j = MathHelper.floor_double(this.boundingBox.minY)) - 1, k = MathHelper.floor_double(this.posZ)) == Block.grass.blockID && this.worldObj.getFullBlockLightValue(i, j, k) > 8 && super.getCanSpawnHere();
    }

    @Override
    public int getTalkInterval() {
        return 120;
    }
}

