/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class EntityArrowGolden
extends EntityArrow {
    public EntityArrowGolden(World world) {
        super(world, 2);
        this.noClip = true;
    }

    public EntityArrowGolden(World world, double d, double d1, double d2) {
        super(world, d, d1, d2, 2);
        this.noClip = true;
    }

    public EntityArrowGolden(World world, EntityLiving entityliving, boolean doesArrowBelongToPlayer) {
        super(world, entityliving, doesArrowBelongToPlayer, 2);
        this.noClip = true;
    }

    @Override
    protected void entityInit() {
        this.arrowGravity = 0.02f;
        this.arrowSpeed = 1.0f;
        this.arrowDamage = 2;
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer entityplayer) {
        if (this.worldObj.isMultiplayerAndNotHost) {
            return;
        }
        if (this.inGround && this.arrowShake <= 0 && entityplayer.inventory.addItemStackToInventory(new ItemStack(Item.ammoArrowGold, 1))) {
            this.worldObj.playSoundAtEntity(this, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayer.onItemPickup(this, Item.ammoArrowGold.itemID);
            this.setEntityDead();
        }
    }
}

