/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.Entity;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityFallingSand
extends Entity {
    public int blockID;
    public int fallTime;

    public EntityFallingSand(World world) {
        super(world);
        this.blockID = Block.sand.blockID;
        this.fallTime = 0;
    }

    public EntityFallingSand(World world, double d, double d1, double d2, int i) {
        super(world);
        this.fallTime = 0;
        this.blockID = i;
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.98f);
        this.yOffset = this.height / 2.0f;
        this.setPosition(d, d1, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public void onUpdate() {
        if (this.blockID == 0) {
            this.setEntityDead();
            return;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        ++this.fallTime;
        this.motionY -= (double)0.04f;
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        int i = MathHelper.floor_double(this.posX);
        int j = MathHelper.floor_double(this.posY);
        int k = MathHelper.floor_double(this.posZ);
        if (this.worldObj.getBlockId(i, j, k) == this.blockID) {
            this.worldObj.setBlockWithNotify(i, j, k, 0);
        }
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
            this.motionY *= -0.5;
            this.setEntityDead();
            if (!(this.worldObj.canBlockBePlacedAt(this.blockID, i, j, k, true, 1) && !BlockSand.canFallBelow(this.worldObj, i, j - 1, k) && this.worldObj.setBlockWithNotify(i, j, k, this.blockID) || this.worldObj.isMultiplayerAndNotHost)) {
                this.dropItem(this.blockID, 1);
            }
        } else if (this.fallTime > 100 && !this.worldObj.isMultiplayerAndNotHost) {
            this.dropItem(this.blockID, 1);
            this.setEntityDead();
        }
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("Tile", (short)this.blockID);
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.blockID = nbttagcompound.getShort("Tile") & 0x3FFF;
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    public World getWorld() {
        return this.worldObj;
    }
}

