/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class EntityFireball
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile = 0;
    private boolean inGround = false;
    public int shake = 0;
    public EntityLiving owner;
    private int field_9396_k;
    private int ticksInAir = 0;
    public double field_9405_b;
    public double field_9404_c;
    public double field_9403_d;

    public EntityFireball(World world) {
        super(world);
        this.setSize(1.0f, 1.0f);
    }

    @Override
    protected void entityInit() {
    }

    @Override
    public boolean isInRangeToRenderDist(double d) {
        double d1 = this.boundingBox.getAverageEdgeLength() * 4.0;
        return d < (d1 *= 64.0) * d1;
    }

    public EntityFireball(World world, double d, double d1, double d2, double d3, double d4, double d5) {
        super(world);
        this.setSize(1.0f, 1.0f);
        this.setLocationAndAngles(d, d1, d2, this.rotationYaw, this.rotationPitch);
        this.setPosition(d, d1, d2);
        double d6 = MathHelper.sqrt_double(d3 * d3 + d4 * d4 + d5 * d5);
        this.field_9405_b = d3 / d6 * 0.1;
        this.field_9404_c = d4 / d6 * 0.1;
        this.field_9403_d = d5 / d6 * 0.1;
    }

    public EntityFireball(World world, EntityLiving entityliving, double d, double d1, double d2) {
        super(world);
        this.owner = entityliving;
        this.setSize(1.0f, 1.0f);
        this.setLocationAndAngles(entityliving.posX, entityliving.posY, entityliving.posZ, entityliving.rotationYaw, entityliving.rotationPitch);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        double d3 = MathHelper.sqrt_double((d += this.rand.nextGaussian() * 0.4) * d + (d1 += this.rand.nextGaussian() * 0.4) * d1 + (d2 += this.rand.nextGaussian() * 0.4) * d2);
        this.field_9405_b = d / d3 * 0.1;
        this.field_9404_c = d1 / d3 * 0.1;
        this.field_9403_d = d2 / d3 * 0.1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onUpdate() {
        block17: {
            super.onUpdate();
            this.fire = 10;
            if (this.shake > 0) {
                --this.shake;
            }
            if (this.inGround) {
                int i = this.worldObj.getBlockId(this.xTile, this.yTile, this.zTile);
                if (i != this.inTile) {
                    this.inGround = false;
                    this.motionX *= (double)(this.rand.nextFloat() * 0.5f);
                    this.motionY *= (double)(this.rand.nextFloat() * 0.5f);
                    this.motionZ *= (double)(this.rand.nextFloat() * 0.5f);
                    this.field_9396_k = 0;
                    this.ticksInAir = 0;
                    break block17;
                } else {
                    ++this.field_9396_k;
                    if (this.field_9396_k == 1200) {
                        this.setEntityDead();
                    }
                    return;
                }
            }
            ++this.ticksInAir;
        }
        Vec3D vec3d = Vec3D.createVector(this.posX, this.posY, this.posZ);
        Vec3D vec3d1 = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        MovingObjectPosition movingobjectposition = this.worldObj.rayTraceBlocks(vec3d, vec3d1);
        vec3d = Vec3D.createVector(this.posX, this.posY, this.posZ);
        vec3d1 = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (movingobjectposition != null) {
            vec3d1 = Vec3D.createVector(movingobjectposition.hitVec.xCoord, movingobjectposition.hitVec.yCoord, movingobjectposition.hitVec.zCoord);
        }
        Entity entity = null;
        List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
        double d = 0.0;
        for (int j = 0; j < list.size(); ++j) {
            double d1;
            float f2;
            AxisAlignedBB axisalignedbb;
            MovingObjectPosition movingobjectposition1;
            Entity entity1 = list.get(j);
            if (!entity1.canBeCollidedWith() || entity1 == this.owner && this.ticksInAir < 25 || (movingobjectposition1 = (axisalignedbb = entity1.boundingBox.expand(f2 = 0.3f, f2, f2)).func_1169_a(vec3d, vec3d1)) == null || !((d1 = vec3d.distanceTo(movingobjectposition1.hitVec)) < d) && d != 0.0) continue;
            entity = entity1;
            d = d1;
        }
        this.worldObj.spawnParticle("flame", this.posX, this.posY, this.posZ, this.motionX * (double)0.05f, this.motionY * (double)0.05f - (double)0.1f, this.motionZ * (double)0.05f);
        this.worldObj.spawnParticle("flame", this.posX + this.motionX * 0.5, this.posY + this.motionY * 0.5, this.posZ + this.motionZ * 0.5, this.motionX * (double)0.05f, this.motionY * (double)0.05f - (double)0.1f, this.motionZ * (double)0.05f);
        if (entity != null) {
            movingobjectposition = new MovingObjectPosition(entity);
        }
        if (movingobjectposition != null) {
            if (!this.worldObj.isMultiplayerAndNotHost) {
                if (movingobjectposition.entityHit == null || !movingobjectposition.entityHit.attackEntityFrom(this.owner, 0, DamageType.COMBAT)) {
                    // empty if block
                }
                this.worldObj.newExplosion(this, this.posX, this.posY, this.posZ, 1.5f, true, false);
            }
            this.setEntityDead();
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f) * 180.0 / 3.1415927410125732);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float f1 = 1.0f;
        if (this.isInWater()) {
            for (int k = 0; k < 4; ++k) {
                float f3 = 0.25f;
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f3, this.posY - this.motionY * (double)f3, this.posZ - this.motionZ * (double)f3, this.motionX, this.motionY, this.motionZ);
            }
            f1 = 0.8f;
        }
        this.motionX += this.field_9405_b;
        this.motionY += this.field_9404_c;
        this.motionZ += this.field_9403_d;
        this.motionX *= (double)f1;
        this.motionY *= (double)f1;
        this.motionZ *= (double)f1;
        this.worldObj.spawnParticle("largesmoke", this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("xTile", (short)this.xTile);
        nbttagcompound.setShort("yTile", (short)this.yTile);
        nbttagcompound.setShort("zTile", (short)this.zTile);
        nbttagcompound.setShort("inTile", (short)this.inTile);
        nbttagcompound.setByte("shake", (byte)this.shake);
        nbttagcompound.setByte("inGround", (byte)(this.inGround ? 1 : 0));
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.xTile = nbttagcompound.getShort("xTile");
        this.yTile = nbttagcompound.getShort("yTile");
        this.zTile = nbttagcompound.getShort("zTile");
        this.inTile = nbttagcompound.getShort("inTile") & 0x3FFF;
        this.shake = nbttagcompound.getByte("shake") & 0xFF;
        this.inGround = nbttagcompound.getByte("inGround") == 1;
    }

    @Override
    public boolean canBeCollidedWith() {
        return true;
    }

    @Override
    public float getCollisionBorderSize() {
        return 1.0f;
    }

    @Override
    public boolean attackEntityFrom(Entity entity, int i, DamageType type) {
        this.setBeenAttacked();
        if (entity != null) {
            Vec3D vec3d = entity.getLookVec();
            if (vec3d != null) {
                this.motionX = vec3d.xCoord;
                this.motionY = vec3d.yCoord;
                this.motionZ = vec3d.zCoord;
                this.field_9405_b = this.motionX * 0.1;
                this.field_9404_c = this.motionY * 0.1;
                this.field_9403_d = this.motionZ * 0.1;
            }
            return true;
        }
        return false;
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }
}

