/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AchievementList;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityLightningBolt;
import net.minecraft.src.EntityPigZombie;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityPig
extends EntityAnimal {
    public EntityPig(World world) {
        super(world);
        this.texture = "/mob/pig.png";
        this.setSize(0.9f, 0.9f);
    }

    @Override
    protected void entityInit() {
        this.dataWatcher.addObject(16, (byte)0);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setBoolean("Saddle", this.getSaddled());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setSaddled(nbttagcompound.getBoolean("Saddle"));
    }

    @Override
    protected String getLivingSound() {
        return "mob.pig";
    }

    @Override
    protected String getHurtSound() {
        return "mob.pig";
    }

    @Override
    protected String getDeathSound() {
        return "mob.pigdeath";
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        if (super.interact(entityplayer)) {
            return true;
        }
        if (this.getSaddled() && !this.worldObj.isMultiplayerAndNotHost && (this.riddenByEntity == null || this.riddenByEntity == entityplayer)) {
            entityplayer.mountEntity(this);
            return true;
        }
        return false;
    }

    @Override
    protected void dropFewItems() {
        if (this.getSaddled()) {
            this.dropItem(Item.saddle.itemID, 1);
        }
        super.dropFewItems();
    }

    @Override
    protected int getDropItemId() {
        if (this.fire > 0) {
            return Item.foodPorkchopCooked.itemID;
        }
        return Item.foodPorkchopRaw.itemID;
    }

    public boolean getSaddled() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void setSaddled(boolean flag) {
        if (flag) {
            this.dataWatcher.updateObject(16, (byte)1);
        } else {
            this.dataWatcher.updateObject(16, (byte)0);
        }
    }

    @Override
    public void onStruckByLightning(EntityLightningBolt entitylightningbolt) {
        if (this.worldObj.isMultiplayerAndNotHost) {
            return;
        }
        EntityPigZombie entitypigzombie = new EntityPigZombie(this.worldObj);
        entitypigzombie.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
        this.worldObj.entityJoinedWorld(entitypigzombie);
        this.setEntityDead();
    }

    @Override
    protected void fall(float f) {
        super.fall(f);
        if (f > 5.0f && this.riddenByEntity instanceof EntityPlayer) {
            ((EntityPlayer)this.riddenByEntity).triggerAchievement(AchievementList.flyPig);
        }
    }
}

