/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.nio.FloatBuffer;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkProviderLoadOrGenerate;
import net.minecraft.src.ClippingHelperImpl;
import net.minecraft.src.Dimension;
import net.minecraft.src.EffectRenderer;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityRainFX;
import net.minecraft.src.EntitySmokeFX;
import net.minecraft.src.Frustrum;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.ItemRenderer;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MouseFilter;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.PlayerControllerTest;
import net.minecraft.src.RenderGlobal;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.Tessellator;
import net.minecraft.src.Vec3D;
import net.minecraft.src.Weather;
import net.minecraft.src.World;
import net.minecraft.src.helper.Time;
import net.minecraft.src.input.InputType;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class EntityRenderer {
    public static boolean field_28135_a = false;
    public static int anaglyphField;
    private Minecraft mc;
    private float farPlaneDistance = 0.0f;
    public ItemRenderer itemRenderer;
    private int rendererUpdateCount;
    private Entity pointedEntity = null;
    private MouseFilter mouseFilterXAxis = new MouseFilter();
    private MouseFilter mouseFilterYAxis = new MouseFilter();
    private MouseFilter mouseFilterDummy1 = new MouseFilter();
    private MouseFilter mouseFilterDummy2 = new MouseFilter();
    private MouseFilter mouseFilterDummy3 = new MouseFilter();
    private MouseFilter mouseFilterDummy4 = new MouseFilter();
    private float field_22228_r = 4.0f;
    private float field_22227_s = 4.0f;
    private float field_22226_t = 0.0f;
    private float field_22225_u = 0.0f;
    private float field_22224_v = 0.0f;
    private float field_22223_w = 0.0f;
    private float field_22222_x = 0.0f;
    private float field_22221_y = 0.0f;
    private float field_22220_z = 0.0f;
    private float field_22230_A = 0.0f;
    private boolean cloudFog = false;
    private double cameraZoom = 1.0;
    private double cameraYaw = 0.0;
    private double cameraPitch = 0.0;
    private long prevFrameTime = System.currentTimeMillis();
    private long field_28133_I = 0L;
    private Random random = new Random();
    private int rainSoundCounter = 0;
    volatile int field_1394_b = 0;
    volatile int field_1393_c = 0;
    FloatBuffer fogColorBuffer = GLAllocation.createDirectFloatBuffer(16);
    float fogColorRed;
    float fogColorGreen;
    float fogColorBlue;
    private float fogColor2;
    private float fogColor1;

    public EntityRenderer(Minecraft minecraft) {
        this.mc = minecraft;
        this.itemRenderer = new ItemRenderer(minecraft);
    }

    public void updateRenderer() {
        this.fogColor2 = this.fogColor1;
        this.field_22227_s = this.field_22228_r;
        this.field_22225_u = this.field_22226_t;
        this.field_22223_w = this.field_22224_v;
        this.field_22221_y = this.field_22222_x;
        this.field_22230_A = this.field_22220_z;
        if (this.mc.renderViewEntity == null) {
            this.mc.renderViewEntity = this.mc.thePlayer;
        }
        float f = this.mc.theWorld.getLightBrightness(MathHelper.floor_double(this.mc.renderViewEntity.posX), MathHelper.floor_double(this.mc.renderViewEntity.posY), MathHelper.floor_double(this.mc.renderViewEntity.posZ));
        if (this.mc.fullbright) {
            f = 1.0f;
        }
        float f1 = (float)(4 - (Integer)this.mc.gameSettings.renderDistance.value) / 4.0f;
        float f2 = f * (1.0f - f1) + f1;
        this.fogColor1 += (f2 - this.fogColor1) * 0.1f;
        ++this.rendererUpdateCount;
        this.itemRenderer.updateEquippedItem();
        this.addRainParticles();
    }

    public void getMouseOver(float f) {
        if (this.mc.renderViewEntity == null) {
            return;
        }
        if (this.mc.theWorld == null) {
            return;
        }
        double d = this.mc.playerController.getBlockReachDistance();
        this.mc.objectMouseOver = this.mc.renderViewEntity.rayTrace(d, f);
        double d1 = d;
        Vec3D vec3d = this.mc.renderViewEntity.getPosition(f);
        if (this.mc.objectMouseOver != null) {
            d1 = this.mc.objectMouseOver.hitVec.distanceTo(vec3d);
        }
        if (this.mc.playerController instanceof PlayerControllerTest) {
            d = 32.0;
            d1 = 32.0;
        } else {
            if (d1 > 3.0) {
                d1 = 3.0;
            }
            d = d1;
        }
        Vec3D vec3d1 = this.mc.renderViewEntity.getLook(f);
        Vec3D vec3d2 = vec3d.addVector(vec3d1.xCoord * d, vec3d1.yCoord * d, vec3d1.zCoord * d);
        this.pointedEntity = null;
        float f1 = 1.0f;
        List<Entity> list = this.mc.theWorld.getEntitiesWithinAABBExcludingEntity(this.mc.renderViewEntity, this.mc.renderViewEntity.boundingBox.addCoord(vec3d1.xCoord * d, vec3d1.yCoord * d, vec3d1.zCoord * d).expand(f1, f1, f1));
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d3;
            Entity entity = list.get(i);
            if (!entity.canBeCollidedWith()) continue;
            float f2 = entity.getCollisionBorderSize();
            AxisAlignedBB axisalignedbb = entity.boundingBox.expand(f2, f2, f2);
            MovingObjectPosition movingobjectposition = axisalignedbb.func_1169_a(vec3d, vec3d2);
            if (axisalignedbb.isVecInside(vec3d)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                this.pointedEntity = entity;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3d.distanceTo(movingobjectposition.hitVec)) < d2) && d2 != 0.0) continue;
            this.pointedEntity = entity;
            d2 = d3;
        }
        if (this.pointedEntity != null && !(this.mc.playerController instanceof PlayerControllerTest)) {
            this.mc.objectMouseOver = new MovingObjectPosition(this.pointedEntity);
        }
    }

    private float getFOVModifier(float f, boolean isModifiedByFOV) {
        EntityLiving entityliving = this.mc.renderViewEntity;
        float f1 = 70.0f;
        if (isModifiedByFOV) {
            f1 = (int)(((Float)this.mc.gameSettings.FoV.value).floatValue() * 100.0f + 30.0f);
        }
        if (entityliving.isInsideOfMaterial(Material.water)) {
            f1 -= 10.0f;
        }
        if (entityliving.health <= 0) {
            float f2 = (float)entityliving.deathTime + f;
            f1 /= (1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f;
        }
        return f1 + this.field_22221_y + (this.field_22222_x - this.field_22221_y) * f;
    }

    private void hurtCameraEffect(float f) {
        EntityLiving entityliving = this.mc.renderViewEntity;
        float f1 = (float)entityliving.hurtTime - f;
        if (entityliving.health <= 0) {
            float f2 = (float)entityliving.deathTime + f;
            GL11.glRotatef(40.0f - 8000.0f / (f2 + 200.0f), 0.0f, 0.0f, 1.0f);
        }
        if (f1 < 0.0f) {
            return;
        }
        f1 /= (float)entityliving.maxHurtTime;
        f1 = MathHelper.sin(f1 * f1 * f1 * f1 * 3.141593f);
        float f3 = entityliving.attackedAtYaw;
        GL11.glRotatef(-f3, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(-f1 * 14.0f, 0.0f, 0.0f, 1.0f);
        GL11.glRotatef(f3, 0.0f, 1.0f, 0.0f);
    }

    private void setupViewBobbing(float f) {
        if (!(this.mc.renderViewEntity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityplayer = (EntityPlayer)this.mc.renderViewEntity;
        float f1 = entityplayer.distanceWalkedModified - entityplayer.prevDistanceWalkedModified;
        float f2 = -(entityplayer.distanceWalkedModified + f1 * f);
        float f3 = entityplayer.field_775_e + (entityplayer.field_774_f - entityplayer.field_775_e) * f;
        float f4 = entityplayer.cameraPitch + (entityplayer.field_9328_R - entityplayer.cameraPitch) * f;
        GL11.glTranslatef(MathHelper.sin(f2 * 3.141593f) * f3 * 0.5f, -Math.abs(MathHelper.cos(f2 * 3.141593f) * f3), 0.0f);
        GL11.glRotatef(MathHelper.sin(f2 * 3.141593f) * f3 * 3.0f, 0.0f, 0.0f, 1.0f);
        GL11.glRotatef(Math.abs(MathHelper.cos(f2 * 3.141593f - 0.2f) * f3) * 5.0f, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(f4, 1.0f, 0.0f, 0.0f);
    }

    private void orientCamera(float renderPartialTicks) {
        EntityLiving entityliving = this.mc.renderViewEntity;
        float f1 = entityliving.yOffset - 1.62f;
        double x = entityliving.prevPosX + (entityliving.posX - entityliving.prevPosX) * (double)renderPartialTicks;
        double y = entityliving.prevPosY + (entityliving.posY - entityliving.prevPosY) * (double)renderPartialTicks - (double)f1;
        double z = entityliving.prevPosZ + (entityliving.posZ - entityliving.prevPosZ) * (double)renderPartialTicks;
        GL11.glRotatef(this.field_22230_A + (this.field_22220_z - this.field_22230_A) * renderPartialTicks, 0.0f, 0.0f, 1.0f);
        if (entityliving.isPlayerSleeping()) {
            f1 = (float)((double)f1 + 1.0);
            GL11.glTranslatef(0.0f, 0.3f, 0.0f);
            if (!((Boolean)this.mc.gameSettings.lockCamera.value).booleanValue()) {
                int i = this.mc.theWorld.getBlockId(MathHelper.floor_double(entityliving.posX), MathHelper.floor_double(entityliving.posY), MathHelper.floor_double(entityliving.posZ));
                if (i == Block.bed.blockID) {
                    int j = this.mc.theWorld.getBlockMetadata(MathHelper.floor_double(entityliving.posX), MathHelper.floor_double(entityliving.posY), MathHelper.floor_double(entityliving.posZ));
                    int k = j & 3;
                    GL11.glRotatef(k * 90, 0.0f, 1.0f, 0.0f);
                }
                GL11.glRotatef(entityliving.prevRotationYaw + (entityliving.rotationYaw - entityliving.prevRotationYaw) * renderPartialTicks + 180.0f, 0.0f, -1.0f, 0.0f);
                GL11.glRotatef(entityliving.prevRotationPitch + (entityliving.rotationPitch - entityliving.prevRotationPitch) * renderPartialTicks, -1.0f, 0.0f, 0.0f);
            }
        } else if ((Integer)this.mc.gameSettings.thirdPersonView.value > 0) {
            double cameraDistanceZ = this.field_22227_s + (this.field_22228_r - this.field_22227_s) * renderPartialTicks;
            if (((Boolean)this.mc.gameSettings.lockCamera.value).booleanValue() || this.mc.isometricMode) {
                float f2 = this.field_22225_u + (this.field_22226_t - this.field_22225_u) * renderPartialTicks;
                float f4 = this.field_22223_w + (this.field_22224_v - this.field_22223_w) * renderPartialTicks;
                GL11.glTranslatef(0.0f, 0.0f, (float)(-cameraDistanceZ));
                GL11.glRotatef(f4, 1.0f, 0.0f, 0.0f);
                GL11.glRotatef(f2, 0.0f, 1.0f, 0.0f);
            } else {
                float pitchYawOffset = (Integer)this.mc.gameSettings.thirdPersonView.value == 2 ? 180.0f : 0.0f;
                float yaw = entityliving.rotationYaw;
                float pitch = entityliving.rotationPitch + pitchYawOffset;
                double dx = (double)(-MathHelper.sin(yaw / 180.0f * 3.141593f) * MathHelper.cos(pitch / 180.0f * 3.141593f)) * cameraDistanceZ;
                double dy = (double)(MathHelper.cos(yaw / 180.0f * 3.141593f) * MathHelper.cos(pitch / 180.0f * 3.141593f)) * cameraDistanceZ;
                double dz = (double)(-MathHelper.sin(pitch / 180.0f * 3.141593f)) * cameraDistanceZ;
                for (int l = 0; l < 8; ++l) {
                    double d7;
                    MovingObjectPosition movingobjectposition;
                    float ix = (l & 1) * 2 - 1;
                    float iy = (l >> 1 & 1) * 2 - 1;
                    float iz = (l >> 2 & 1) * 2 - 1;
                    if ((movingobjectposition = this.mc.theWorld.rayTraceBlocks(Vec3D.createVector(x + (double)(ix *= 0.1f), y + (double)(iy *= 0.1f), z + (double)(iz *= 0.1f)), Vec3D.createVector(x - dx + (double)ix + (double)iz, y - dz + (double)iy, z - dy + (double)iz))) == null || !((d7 = movingobjectposition.hitVec.distanceTo(Vec3D.createVector(x, y, z))) < cameraDistanceZ)) continue;
                    cameraDistanceZ = d7;
                }
                GL11.glRotatef(entityliving.rotationPitch + pitchYawOffset - pitch, 1.0f, 0.0f, 0.0f);
                GL11.glRotatef(entityliving.rotationYaw - yaw, 0.0f, 1.0f, 0.0f);
                if ((Integer)this.mc.gameSettings.thirdPersonView.value == 2) {
                    GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
                    GL11.glTranslatef(0.0f, 0.0f, (float)cameraDistanceZ);
                } else {
                    GL11.glTranslatef(0.0f, 0.0f, (float)(-cameraDistanceZ));
                }
                GL11.glRotatef(yaw - entityliving.rotationYaw, 0.0f, 1.0f, 0.0f);
                GL11.glRotatef(pitch - (entityliving.rotationPitch + pitchYawOffset), 1.0f, 0.0f, 0.0f);
            }
        } else {
            GL11.glTranslatef(0.0f, 0.0f, -0.1f);
        }
        if (!this.mc.isometricMode && !((Boolean)this.mc.gameSettings.lockCamera.value).booleanValue()) {
            GL11.glRotatef(entityliving.prevRotationPitch + (entityliving.rotationPitch - entityliving.prevRotationPitch) * renderPartialTicks, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(entityliving.prevRotationYaw + (entityliving.rotationYaw - entityliving.prevRotationYaw) * renderPartialTicks + 180.0f, 0.0f, 1.0f, 0.0f);
        }
        if (this.mc.isometricMode) {
            GL11.glRotatef(this.mc.isometricTilt, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(45.0f + 90.0f * this.mc.isometricRotation, 0.0f, 1.0f, 0.0f);
        }
        GL11.glTranslatef(0.0f, f1, 0.0f);
        x = entityliving.prevPosX + (entityliving.posX - entityliving.prevPosX) * (double)renderPartialTicks;
        y = entityliving.prevPosY + (entityliving.posY - entityliving.prevPosY) * (double)renderPartialTicks - (double)f1;
        z = entityliving.prevPosZ + (entityliving.posZ - entityliving.prevPosZ) * (double)renderPartialTicks;
        this.cloudFog = this.mc.renderGlobal.func_27307_a(x, y, z, renderPartialTicks);
    }

    private void setupCameraTransform(float f, int i) {
        float f2;
        this.farPlaneDistance = 512 >> (Integer)this.mc.gameSettings.renderDistance.value;
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        float f1 = 0.07f;
        if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
            GL11.glTranslatef((float)(-(i * 2 - 1)) * f1, 0.0f, 0.0f);
        }
        float fov = this.getFOVModifier(f, true);
        if (this.mc.gameSettings.keyZoom.isPressed() && this.mc.currentScreen == null) {
            fov *= 0.45f;
        }
        if (this.mc.isometricMode) {
            double div = Math.pow(2.0, this.mc.isometricZoom);
            GL11.glTranslatef(1.0f, 1.0f, 0.0f);
            GL11.glOrtho(0.0, (double)this.mc.resolution.width / div, 0.0, (double)this.mc.resolution.height / div, this.farPlaneDistance * -2.0f, this.farPlaneDistance * 2.0f);
        } else if (this.cameraZoom != 1.0) {
            GL11.glTranslatef((float)this.cameraYaw, (float)(-this.cameraPitch), 0.0f);
            GL11.glScaled(this.cameraZoom, this.cameraZoom, 1.0);
            GLU.gluPerspective(fov, (float)this.mc.resolution.width / (float)this.mc.resolution.height, 0.05f, this.farPlaneDistance * 2.0f);
        } else {
            GLU.gluPerspective(fov, (float)this.mc.resolution.width / (float)this.mc.resolution.height, 0.05f, this.farPlaneDistance * 2.0f);
        }
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
            GL11.glTranslatef((float)(i * 2 - 1) * 0.1f, 0.0f, 0.0f);
        }
        this.hurtCameraEffect(f);
        if (((Boolean)this.mc.gameSettings.viewBobbing.value).booleanValue() && !this.mc.isometricMode) {
            this.setupViewBobbing(f);
        }
        if ((f2 = this.mc.thePlayer.prevTimeInPortal + (this.mc.thePlayer.timeInPortal - this.mc.thePlayer.prevTimeInPortal) * f) > 0.0f) {
            float f3 = 5.0f / (f2 * f2 + 5.0f) - f2 * 0.04f;
            f3 *= f3;
            GL11.glRotatef(((float)this.rendererUpdateCount + f) * 20.0f, 0.0f, 1.0f, 1.0f);
            GL11.glScalef(1.0f / f3, 1.0f, 1.0f);
            GL11.glRotatef(-((float)this.rendererUpdateCount + f) * 20.0f, 0.0f, 1.0f, 1.0f);
        }
        this.orientCamera(f);
    }

    private void func_4135_b(float f, int i) {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        float fov = this.getFOVModifier(f, false);
        if (this.mc.gameSettings.keyZoom.isPressed() && this.mc.currentScreen == null) {
            fov *= 0.45f;
        }
        GL11.glScalef(1.0f, 1.0f, 0.1f);
        if (this.cameraZoom != 1.0) {
            GL11.glTranslatef((float)this.cameraYaw, (float)(-this.cameraPitch), 0.0f);
            GL11.glScaled(this.cameraZoom, this.cameraZoom, 1.0);
            GLU.gluPerspective(fov, (float)this.mc.resolution.width / (float)this.mc.resolution.height, 0.05f, this.farPlaneDistance * 2.0f);
        } else {
            GLU.gluPerspective(fov, (float)this.mc.resolution.width / (float)this.mc.resolution.height, 0.05f, this.farPlaneDistance * 2.0f);
        }
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
            GL11.glTranslatef((float)(i * 2 - 1) * 0.1f, 0.0f, 0.0f);
        }
        GL11.glPushMatrix();
        this.hurtCameraEffect(f);
        if (((Boolean)this.mc.gameSettings.viewBobbing.value).booleanValue()) {
            this.setupViewBobbing(f);
        }
        if (!((Integer)this.mc.gameSettings.thirdPersonView.value != 0 || this.mc.isometricMode || this.mc.renderViewEntity.isPlayerSleeping() || !this.mc.gameSettings.immersiveMode.drawHand() || this.mc.gameSettings.keyZoom.isPressed() && this.mc.currentScreen == null)) {
            this.itemRenderer.renderItemInFirstPerson(f);
        }
        GL11.glPopMatrix();
        if ((Integer)this.mc.gameSettings.thirdPersonView.value == 0 && !this.mc.renderViewEntity.isPlayerSleeping()) {
            this.itemRenderer.renderOverlays(f);
            this.hurtCameraEffect(f);
        }
        if (((Boolean)this.mc.gameSettings.viewBobbing.value).booleanValue()) {
            this.setupViewBobbing(f);
        }
    }

    public void updateCameraAndRender(float renderPartialTicks) {
        if (this.mc.inGameHasFocus) {
            if (this.mc.inputType == InputType.KEYBOARD && Mouse.isGrabbed()) {
                float f1 = ((Float)this.mc.gameSettings.mouseSensitivity.value).floatValue() * 0.6f + 0.2f;
                float f2 = f1 * f1 * f1 * 8.0f;
                if (this.mc.gameSettings.keyZoom.isPressed() && this.mc.currentScreen == null) {
                    f2 *= 0.25f;
                }
                float f3 = (float)this.mc.mouseInput.deltaX * f2;
                float f4 = (float)this.mc.mouseInput.deltaY * f2;
                int l = 1;
                if (((Boolean)this.mc.gameSettings.invertMouse.value).booleanValue()) {
                    l = -1;
                }
                if (((Boolean)this.mc.gameSettings.smoothCamera.value).booleanValue()) {
                    f3 = this.mouseFilterXAxis.func_22386_a(f3, 0.05f * f2);
                    f4 = this.mouseFilterYAxis.func_22386_a(f4, 0.05f * f2);
                }
                this.mc.thePlayer.rotate(f3, f4 * (float)l);
            }
            if (this.mc.inputType == InputType.CONTROLLER) {
                double speed = Time.delta * 2000.0 * (double)(((Float)this.mc.gameSettings.controllerSensitivity.value).floatValue() + 0.5f);
                double x = (double)this.mc.controllerInput.joyRight.getX() * speed;
                double y = (double)(-this.mc.controllerInput.joyRight.getY()) * speed;
                this.mc.thePlayer.rotate((float)x, (float)y);
            }
        }
        if (this.mc.skipRenderWorld) {
            return;
        }
        field_28135_a = (Boolean)this.mc.gameSettings.anaglyph.value;
        int width = this.mc.resolution.scaledWidth;
        int height = this.mc.resolution.scaledHeight;
        int mouseX = Mouse.getX() * width / this.mc.resolution.width;
        int mouseY = height - Mouse.getY() * height / this.mc.resolution.height - 1;
        int c = 200;
        if ((Integer)this.mc.gameSettings.limitFramerate.value == 1) {
            c = 120;
        }
        if ((Integer)this.mc.gameSettings.limitFramerate.value == 2) {
            c = 40;
        }
        if (this.mc.theWorld != null) {
            long l1;
            if (this.mc.shadersActive()) {
                this.mc.render.beginRenderWorld();
            }
            if ((Integer)this.mc.gameSettings.limitFramerate.value == 0) {
                this.renderWorld(renderPartialTicks, 0L);
            } else {
                this.renderWorld(renderPartialTicks, this.field_28133_I + (long)(1000000000 / c));
            }
            if ((Integer)this.mc.gameSettings.limitFramerate.value == 2 && (l1 = (this.field_28133_I + (long)(1000000000 / c) - System.nanoTime()) / 1000000L) > 0L && l1 < 500L) {
                try {
                    Thread.sleep(l1);
                }
                catch (InterruptedException interruptedexception) {
                    interruptedexception.printStackTrace();
                }
            }
            this.field_28133_I = System.nanoTime();
            if (this.mc.shadersActive()) {
                this.mc.render.endRenderWorld();
            }
            this.mc.ingameGUI.renderGameOverlay(renderPartialTicks, this.mc.currentScreen != null, mouseX, mouseY);
        } else {
            GL11.glViewport(0, 0, this.mc.resolution.width, this.mc.resolution.height);
            GL11.glMatrixMode(5889);
            GL11.glLoadIdentity();
            GL11.glMatrixMode(5888);
            GL11.glLoadIdentity();
            this.setupScaledResolution();
            if ((Integer)this.mc.gameSettings.limitFramerate.value == 2) {
                long l2 = (this.field_28133_I + (long)(1000000000 / c) - System.nanoTime()) / 1000000L;
                if (l2 < 0L) {
                    l2 += 10L;
                }
                if (l2 > 0L && l2 < 500L) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedexception1) {
                        interruptedexception1.printStackTrace();
                    }
                }
            }
            this.field_28133_I = System.nanoTime();
        }
        if (this.mc.currentScreen != null) {
            GL11.glClear(256);
            if (this.mc.inputType == InputType.CONTROLLER) {
                mouseX = (int)this.mc.controllerInput.cursorX;
                mouseY = (int)this.mc.controllerInput.cursorY;
            }
            this.mc.currentScreen.drawScreen(mouseX, mouseY, renderPartialTicks);
            if (this.mc.inputType == InputType.CONTROLLER && this.mc.currentScreen != null) {
                this.mc.currentScreen.drawCursor();
            }
            if (this.mc.currentScreen != null && this.mc.currentScreen.field_25091_h != null) {
                this.mc.currentScreen.field_25091_h.func_25087_a(renderPartialTicks);
            }
        }
    }

    public void renderWorld(float renderPartialTicks, long l) {
        GL11.glEnable(2884);
        GL11.glEnable(2929);
        if (this.mc.renderViewEntity == null) {
            this.mc.renderViewEntity = this.mc.thePlayer;
        }
        this.getMouseOver(renderPartialTicks);
        EntityLiving entityliving = this.mc.renderViewEntity;
        RenderGlobal renderglobal = this.mc.renderGlobal;
        EffectRenderer effectrenderer = this.mc.effectRenderer;
        double d = entityliving.lastTickPosX + (entityliving.posX - entityliving.lastTickPosX) * (double)renderPartialTicks;
        double d1 = entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * (double)renderPartialTicks;
        double d2 = entityliving.lastTickPosZ + (entityliving.posZ - entityliving.lastTickPosZ) * (double)renderPartialTicks;
        IChunkProvider ichunkprovider = this.mc.theWorld.getIChunkProvider();
        if (ichunkprovider instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
            int j = MathHelper.floor_float((int)d) >> 4;
            int k = MathHelper.floor_float((int)d2) >> 4;
            chunkproviderloadorgenerate.setCurrentChunkOver(j, k);
        }
        for (int i = 0; i < 2; ++i) {
            if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
                anaglyphField = i;
                if (anaglyphField == 0) {
                    GL11.glColorMask(false, true, true, false);
                } else {
                    GL11.glColorMask(true, false, false, false);
                }
            }
            GL11.glViewport(0, 0, this.mc.resolution.width, this.mc.resolution.height);
            this.updateFogColor(renderPartialTicks);
            GL11.glClear(16640);
            GL11.glEnable(2884);
            this.setupCameraTransform(renderPartialTicks, i);
            ClippingHelperImpl.getInstance();
            if ((Integer)this.mc.gameSettings.renderDistance.value < 3) {
                this.setupFog(-1, renderPartialTicks);
                renderglobal.renderSky(renderPartialTicks);
            }
            GL11.glEnable(2912);
            this.setupFog(1, renderPartialTicks);
            if (((Boolean)this.mc.gameSettings.ambientOcclusion.value).booleanValue()) {
                GL11.glShadeModel(7425);
            }
            Frustrum frustrum = new Frustrum();
            frustrum.setPosition(d, d1, d2);
            this.mc.renderGlobal.clipRenderersByFrustrum(frustrum, renderPartialTicks);
            if (i == 0) {
                long l1;
                while (!this.mc.renderGlobal.updateRenderers(entityliving, false) && l != 0L && (l1 = l - System.nanoTime()) >= 0L && l1 <= 1000000000L) {
                }
            }
            this.setupFog(0, renderPartialTicks);
            GL11.glEnable(2912);
            GL11.glBindTexture(3553, this.mc.renderEngine.getTexture("/terrain.png"));
            RenderHelper.disableStandardItemLighting();
            if (this.mc.shadersActive()) {
                this.mc.render.beginRenderTerrain();
            }
            renderglobal.sortAndRender(entityliving, 0, renderPartialTicks);
            if (this.mc.shadersActive()) {
                this.mc.render.endRenderTerrain();
            }
            GL11.glShadeModel(7424);
            RenderHelper.enableStandardItemLighting();
            renderglobal.renderEntities(entityliving.getPosition(renderPartialTicks), frustrum, renderPartialTicks);
            effectrenderer.func_1187_b(entityliving, renderPartialTicks);
            RenderHelper.disableStandardItemLighting();
            this.setupFog(0, renderPartialTicks);
            effectrenderer.renderParticles(entityliving, renderPartialTicks);
            if (this.mc.objectMouseOver != null && entityliving.isInsideOfMaterial(Material.water) && entityliving instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityliving;
                GL11.glDisable(3008);
                renderglobal.drawBlockBreaking(entityplayer, this.mc.objectMouseOver, 0, entityplayer.inventory.getCurrentItem(), renderPartialTicks);
                renderglobal.drawSelectionBox(entityplayer, this.mc.objectMouseOver, 0, entityplayer.inventory.getCurrentItem(), renderPartialTicks);
                GL11.glEnable(3008);
            }
            GL11.glBlendFunc(770, 771);
            this.setupFog(0, renderPartialTicks);
            GL11.glEnable(3042);
            GL11.glDisable(2884);
            GL11.glBindTexture(3553, this.mc.renderEngine.getTexture("/terrain.png"));
            if (((Boolean)this.mc.gameSettings.fancyGraphics.value).booleanValue()) {
                if (((Boolean)this.mc.gameSettings.ambientOcclusion.value).booleanValue()) {
                    GL11.glShadeModel(7425);
                }
                GL11.glColorMask(false, false, false, false);
                int i1 = renderglobal.sortAndRender(entityliving, 1, renderPartialTicks);
                if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
                    if (anaglyphField == 0) {
                        GL11.glColorMask(false, true, true, true);
                    } else {
                        GL11.glColorMask(true, false, false, true);
                    }
                } else {
                    GL11.glColorMask(true, true, true, true);
                }
                if (i1 > 0) {
                    renderglobal.renderAllRenderLists(1, renderPartialTicks);
                }
                GL11.glShadeModel(7424);
            } else {
                renderglobal.sortAndRender(entityliving, 1, renderPartialTicks);
            }
            GL11.glDepthMask(true);
            GL11.glEnable(2884);
            GL11.glDisable(3042);
            if (this.cameraZoom == 1.0 && entityliving instanceof EntityPlayer && this.mc.objectMouseOver != null && !entityliving.isInsideOfMaterial(Material.water)) {
                EntityPlayer entityplayer1 = (EntityPlayer)entityliving;
                GL11.glDisable(3008);
                renderglobal.drawBlockBreaking(entityplayer1, this.mc.objectMouseOver, 0, entityplayer1.inventory.getCurrentItem(), renderPartialTicks);
                renderglobal.drawSelectionBox(entityplayer1, this.mc.objectMouseOver, 0, entityplayer1.inventory.getCurrentItem(), renderPartialTicks);
                GL11.glEnable(3008);
            }
            this.renderRainSnow(renderPartialTicks);
            GL11.glDisable(2912);
            if (this.pointedEntity == null) {
                // empty if block
            }
            if (((Boolean)this.mc.gameSettings.clouds.value).booleanValue()) {
                this.setupFog(0, renderPartialTicks);
                GL11.glEnable(2912);
                renderglobal.renderClouds(renderPartialTicks);
                GL11.glDisable(2912);
            }
            this.setupFog(1, renderPartialTicks);
            if (this.cameraZoom == 1.0) {
                if (this.mc.shadersActive() && this.mc.render.clearDepthBeforeRenderHand() || !this.mc.shadersActive()) {
                    GL11.glClear(256);
                }
                this.func_4135_b(renderPartialTicks, i);
            }
            if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) continue;
            return;
        }
        GL11.glColorMask(true, true, true, false);
    }

    private void addRainParticles() {
        Weather weather = this.mc.theWorld.getCurrentWeather();
        if (weather == null || !weather.spawnRainParticles) {
            return;
        }
        float f = this.mc.theWorld.weatherIntensity * this.mc.theWorld.weatherPower;
        if (!((Boolean)this.mc.gameSettings.fancyGraphics.value).booleanValue()) {
            f /= 2.0f;
        }
        if (f == 0.0f) {
            return;
        }
        this.random.setSeed((long)this.rendererUpdateCount * 312987231L);
        EntityLiving entityliving = this.mc.renderViewEntity;
        World world = this.mc.theWorld;
        int i = MathHelper.floor_double(entityliving.posX);
        int j = MathHelper.floor_double(entityliving.posY);
        int k = MathHelper.floor_double(entityliving.posZ);
        int byte0 = 10;
        double d = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        int l = 0;
        block0: for (int i1 = 0; i1 < (int)(100.0f * f * f); ++i1) {
            int j1 = i + this.random.nextInt(byte0) - this.random.nextInt(byte0);
            int k1 = k + this.random.nextInt(byte0) - this.random.nextInt(byte0);
            int l1 = world.findTopSolidBlock(j1, k1);
            int i2 = world.getBlockId(j1, l1 - 1, k1);
            BiomeGenBase biome = world.getWorldChunkManager().getBiomeGenAt(j1, k1);
            for (int q = 0; q < biome.blockedWeathers.length; ++q) {
                if (biome.blockedWeathers[q] == weather) continue block0;
            }
            if (l1 > j + byte0 || l1 < j - byte0) continue;
            float f1 = this.random.nextFloat();
            float f2 = this.random.nextFloat();
            if (i2 <= 0) continue;
            if (Block.blocksList[i2].blockMaterial == Material.lava) {
                this.mc.effectRenderer.addEffect(new EntitySmokeFX(world, (float)j1 + f1, (double)((float)l1 + 0.1f) - Block.blocksList[i2].minY, (float)k1 + f2, 0.0, 0.0, 0.0));
                continue;
            }
            if (this.random.nextInt(++l) == 0) {
                d = (float)j1 + f1;
                d1 = (double)((float)l1 + 0.1f) - Block.blocksList[i2].minY;
                d2 = (float)k1 + f2;
            }
            this.mc.effectRenderer.addEffect(new EntityRainFX(world, (float)j1 + f1, (double)((float)l1 + 0.1f) - Block.blocksList[i2].minY, (float)k1 + f2));
        }
        if (l > 0 && this.random.nextInt(3) < this.rainSoundCounter++) {
            this.rainSoundCounter = 0;
            if (d1 > entityliving.posY + 1.0 && world.getHeightValue(MathHelper.floor_double(entityliving.posX), MathHelper.floor_double(entityliving.posZ)) > MathHelper.floor_double(entityliving.posY)) {
                this.mc.theWorld.playSoundEffect(d, d1, d2, "ambient.weather.rain", 0.1f * this.mc.theWorld.weatherIntensity * this.mc.theWorld.weatherPower * 0.5f, 0.5f);
            } else {
                this.mc.theWorld.playSoundEffect(d, d1, d2, "ambient.weather.rain", 0.2f * this.mc.theWorld.weatherIntensity * this.mc.theWorld.weatherPower * 0.5f, 1.0f);
            }
        }
    }

    protected void renderRainSnow(float f) {
        Weather weather = this.mc.theWorld.getCurrentWeather();
        if (weather == null || !weather.isPrecipitation) {
            return;
        }
        EntityLiving entityliving = this.mc.renderViewEntity;
        World world = this.mc.theWorld;
        int i = MathHelper.floor_double(entityliving.posX);
        int j = MathHelper.floor_double(entityliving.posY);
        int k = MathHelper.floor_double(entityliving.posZ);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable(2884);
        GL11.glNormal3f(0.0f, 1.0f, 0.0f);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glAlphaFunc(516, 0.01f);
        GL11.glBindTexture(3553, this.mc.renderEngine.getTexture(weather.texturePath));
        double d = entityliving.lastTickPosX + (entityliving.posX - entityliving.lastTickPosX) * (double)f;
        double d1 = entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * (double)f;
        double d2 = entityliving.lastTickPosZ + (entityliving.posZ - entityliving.lastTickPosZ) * (double)f;
        int l = MathHelper.floor_double(d1);
        int i1 = 10;
        boolean j1 = false;
        if (weather.precipitationType == 1) {
            for (int k1 = i - i1; k1 <= i + i1; ++k1) {
                block1: for (int i2 = k - i1; i2 <= k + i1; ++i2) {
                    int i3;
                    BiomeGenBase biomegenbase = world.getWorldChunkManager().getBiomeGenAt(k1, i2);
                    for (int q = 0; q < biomegenbase.blockedWeathers.length; ++q) {
                        if (biomegenbase.blockedWeathers[q] == weather) continue block1;
                    }
                    int k2 = world.findTopSolidBlock(k1, i2);
                    if (k2 < 0) {
                        k2 = 0;
                    }
                    if ((i3 = k2) < l) {
                        i3 = l;
                    }
                    int k3 = j - i1;
                    int i4 = j + i1;
                    if (k3 < k2) {
                        k3 = k2;
                    }
                    if (i4 < k2) {
                        i4 = k2;
                    }
                    float f3 = 1.0f;
                    if (k3 == i4) continue;
                    this.random.setSeed(k1 * k1 * 3121 + k1 * 45238971 + i2 * i2 * 418711 + i2 * 13761);
                    float f5 = (float)this.rendererUpdateCount + f;
                    float f6 = ((float)(this.rendererUpdateCount & 0x1FF) + f) / 512.0f;
                    float f7 = this.random.nextFloat() + f5 * 0.01f * (float)this.random.nextGaussian();
                    float f8 = this.random.nextFloat() + f5 * (float)this.random.nextGaussian() * 0.001f;
                    double d5 = (double)((float)k1 + 0.5f) - entityliving.posX;
                    double d6 = (double)((float)i2 + 0.5f) - entityliving.posZ;
                    float f11 = MathHelper.sqrt_double(d5 * d5 + d6 * d6) / (float)i1;
                    tessellator.startDrawingQuads();
                    float f12 = world.getLightBrightness(k1, i3, i2);
                    if (this.mc.fullbright) {
                        f12 = 1.0f;
                    }
                    GL11.glColor4f(f12, f12, f12, ((1.0f - f11 * f11) * 0.3f + 0.5f) * world.weatherIntensity * world.weatherPower);
                    tessellator.setTranslationD(-d * 1.0, -d1 * 1.0, -d2 * 1.0);
                    tessellator.addVertexWithUV(k1 + 0, k3, (double)i2 + 0.5, 0.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(k1 + 1, k3, (double)i2 + 0.5, 1.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(k1 + 1, i4, (double)i2 + 0.5, 1.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(k1 + 0, i4, (double)i2 + 0.5, 0.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)k1 + 0.5, k3, i2 + 0, 0.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)k1 + 0.5, k3, i2 + 1, 1.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)k1 + 0.5, i4, i2 + 1, 1.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)k1 + 0.5, i4, i2 + 0, 0.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.setTranslationD(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
            }
        } else if (weather.precipitationType == 0) {
            for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                block4: for (int j2 = k - i1; j2 <= k + i1; ++j2) {
                    BiomeGenBase biomegenbase1 = world.getWorldChunkManager().getBiomeGenAt(l1, j2);
                    for (int q = 0; q < biomegenbase1.blockedWeathers.length; ++q) {
                        if (biomegenbase1.blockedWeathers[q] == weather) continue block4;
                    }
                    int l2 = world.findTopSolidBlock(l1, j2);
                    int j3 = j - i1;
                    int l3 = j + i1;
                    if (j3 < l2) {
                        j3 = l2;
                    }
                    if (l3 < l2) {
                        l3 = l2;
                    }
                    float f2 = 1.0f;
                    if (j3 == l3) continue;
                    this.random.setSeed(l1 * l1 * 3121 + l1 * 45238971 + j2 * j2 * 418711 + j2 * 13761);
                    float f4 = ((float)(this.rendererUpdateCount + l1 * l1 * 3121 + l1 * 45238971 + j2 * j2 * 418711 + j2 * 13761 & 0x1F) + f) / 32.0f * (3.0f + this.random.nextFloat());
                    double d3 = (double)((float)l1 + 0.5f) - entityliving.posX;
                    double d4 = (double)((float)j2 + 0.5f) - entityliving.posZ;
                    float f9 = MathHelper.sqrt_double(d3 * d3 + d4 * d4) / (float)i1;
                    tessellator.startDrawingQuads();
                    float f10 = world.getLightBrightness(l1, net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS, j2) * 0.85f + 0.15f;
                    if (this.mc.fullbright) {
                        f10 = 1.0f;
                    }
                    GL11.glColor4f(f10, f10, f10, ((1.0f - f9 * f9) * 0.5f + 0.5f) * (world.weatherIntensity - 0.1f) * world.weatherPower);
                    tessellator.setTranslationD(-d * 1.0, -d1 * 1.0, -d2 * 1.0);
                    tessellator.addVertexWithUV(l1 + 0, j3, (double)j2 + 0.5, 0.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(l1 + 1, j3, (double)j2 + 0.5, 1.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(l1 + 1, l3, (double)j2 + 0.5, 1.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(l1 + 0, l3, (double)j2 + 0.5, 0.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)l1 + 0.5, j3, j2 + 0, 0.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)l1 + 0.5, j3, j2 + 1, 1.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)l1 + 0.5, l3, j2 + 1, 1.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)l1 + 0.5, l3, j2 + 0, 0.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.setTranslationD(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
            }
        }
        GL11.glEnable(2884);
        GL11.glDisable(3042);
        GL11.glAlphaFunc(516, 0.1f);
    }

    public void setupScaledResolution() {
        GL11.glClear(256);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.mc.resolution.scaledWidthExact, this.mc.resolution.scaledHeightExact, 0.0, 1000.0, 3000.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -2000.0f);
    }

    private void updateFogColor(float f) {
        World world = this.mc.theWorld;
        EntityLiving entityliving = this.mc.renderViewEntity;
        float f1 = 1.0f / (float)(5 - (Integer)this.mc.gameSettings.renderDistance.value);
        f1 = 1.0f - (float)Math.pow(f1, 0.25);
        Vec3D vec3d = world.getSkyColor(this.mc.renderViewEntity, f);
        float f2 = (float)vec3d.xCoord;
        float f3 = (float)vec3d.yCoord;
        float f4 = (float)vec3d.zCoord;
        Vec3D vec3d1 = world.getFogColor(f);
        this.fogColorRed = (float)vec3d1.xCoord;
        this.fogColorGreen = (float)vec3d1.yCoord;
        this.fogColorBlue = (float)vec3d1.zCoord;
        this.fogColorRed += (f2 - this.fogColorRed) * f1;
        this.fogColorGreen += (f3 - this.fogColorGreen) * f1;
        this.fogColorBlue += (f4 - this.fogColorBlue) * f1;
        if (world.getCurrentWeather() != null) {
            float[] out = world.getCurrentWeather().modifyFogColor(this.fogColorRed, this.fogColorGreen, this.fogColorBlue, world.weatherIntensity * world.weatherPower);
            this.fogColorRed = out[0];
            this.fogColorGreen = out[1];
            this.fogColorBlue = out[2];
        }
        if (this.cloudFog) {
            Vec3D vec3d2 = world.getDimensionColor(f);
            this.fogColorRed = (float)vec3d2.xCoord;
            this.fogColorGreen = (float)vec3d2.yCoord;
            this.fogColorBlue = (float)vec3d2.zCoord;
        } else if (entityliving.isInsideOfMaterial(Material.water)) {
            this.fogColorRed = 0.02f;
            this.fogColorGreen = 0.02f;
            this.fogColorBlue = 0.2f;
        } else if (entityliving.isInsideOfMaterial(Material.lava)) {
            this.fogColorRed = 0.6f;
            this.fogColorGreen = 0.1f;
            this.fogColorBlue = 0.0f;
        }
        float f10 = this.fogColor2 + (this.fogColor1 - this.fogColor2) * f;
        this.fogColorRed *= f10;
        this.fogColorGreen *= f10;
        this.fogColorBlue *= f10;
        if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
            float f11 = (this.fogColorRed * 30.0f + this.fogColorGreen * 59.0f + this.fogColorBlue * 11.0f) / 100.0f;
            float f12 = (this.fogColorRed * 30.0f + this.fogColorGreen * 70.0f) / 100.0f;
            float f13 = (this.fogColorRed * 30.0f + this.fogColorBlue * 70.0f) / 100.0f;
            this.fogColorRed = f11;
            this.fogColorGreen = f12;
            this.fogColorBlue = f13;
        }
        GL11.glClearColor(this.fogColorRed, this.fogColorGreen, this.fogColorBlue, 0.0f);
    }

    private void setupFog(int i, float f) {
        EntityLiving entityliving = this.mc.renderViewEntity;
        GL11.glFog(2918, this.func_908_a(this.fogColorRed, this.fogColorGreen, this.fogColorBlue, 0.5f));
        GL11.glNormal3f(0.0f, -1.0f, 0.0f);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.cloudFog) {
            GL11.glFogi(2917, 2048);
            GL11.glFogf(2914, 0.1f);
            float f1 = 1.0f;
            float f4 = 1.0f;
            float f7 = 1.0f;
            if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
                float f10 = (f1 * 30.0f + f4 * 59.0f + f7 * 11.0f) / 100.0f;
                float f13 = (f1 * 30.0f + f4 * 70.0f) / 100.0f;
                float f16 = (f1 * 30.0f + f7 * 70.0f) / 100.0f;
                f1 = f10;
                f4 = f13;
                f7 = f16;
            }
        } else if (entityliving.isInsideOfMaterial(Material.water)) {
            GL11.glFogi(2917, 2048);
            GL11.glFogf(2914, 0.1f);
            float f2 = 0.4f;
            float f5 = 0.4f;
            float f8 = 0.9f;
            if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
                float f11 = (f2 * 30.0f + f5 * 59.0f + f8 * 11.0f) / 100.0f;
                float f14 = (f2 * 30.0f + f5 * 70.0f) / 100.0f;
                float f17 = (f2 * 30.0f + f8 * 70.0f) / 100.0f;
                f2 = f11;
                f5 = f14;
                f8 = f17;
            }
        } else if (entityliving.isInsideOfMaterial(Material.lava)) {
            GL11.glFogi(2917, 2048);
            GL11.glFogf(2914, 2.0f);
            float f3 = 0.4f;
            float f6 = 0.3f;
            float f9 = 0.3f;
            if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
                float f12 = (f3 * 30.0f + f6 * 59.0f + f9 * 11.0f) / 100.0f;
                float f15 = (f3 * 30.0f + f6 * 70.0f) / 100.0f;
                float f18 = (f3 * 30.0f + f9 * 70.0f) / 100.0f;
                f3 = f12;
                f6 = f15;
                f9 = f18;
            }
        } else {
            float fogModifier = this.mc.theWorld.getCurrentWeather() != null ? this.mc.theWorld.getCurrentWeather().fogDistance : 1.0f;
            fogModifier = 1.0f - (1.0f - fogModifier) * this.mc.theWorld.weatherIntensity * this.mc.theWorld.weatherPower;
            if ((Integer)this.mc.gameSettings.renderDistance.value > 2) {
                fogModifier *= 1.5f;
            }
            GL11.glFogi(2917, 9729);
            GL11.glFogf(2915, this.farPlaneDistance * 0.25f * fogModifier * this.mc.fogOverride);
            GL11.glFogf(2916, this.farPlaneDistance * fogModifier * this.mc.fogOverride);
            if (i < 0) {
                GL11.glFogf(2915, 0.0f);
                GL11.glFogf(2916, this.farPlaneDistance * 0.8f * fogModifier);
            }
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GL11.glFogi(34138, 34139);
            }
            if (this.mc.theWorld.dimension == Dimension.nether) {
                GL11.glFogf(2915, 0.0f);
            }
        }
        GL11.glEnable(2903);
        GL11.glColorMaterial(1028, 4608);
    }

    private FloatBuffer func_908_a(float f, float f1, float f2, float f3) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(f).put(f1).put(f2).put(f3);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }
}

