/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import net.minecraft.src.ChatAllowedCharacters;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.GameSettings;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.Tessellator;
import net.minecraft.src.helper.Color;
import net.minecraft.src.helper.Colors;
import org.lwjgl.opengl.GL11;

public class FontRenderer {
    private int[] charWidth;
    public int fontTextureID = 0;
    private final int fontLists = GLAllocation.generateDisplayLists(288);
    private IntBuffer listBuffer;

    public FontRenderer(GameSettings gamesettings, String fontPath, RenderEngine renderengine) {
        BufferedImage image;
        this.charWidth = new int[256];
        this.listBuffer = GLAllocation.createDirectIntBuffer(1024);
        try {
            image = ImageIO.read(renderengine.texturePacks.selectedTexturePack.getResourceAsStream(fontPath));
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[] pixels = new int[width * height];
        image.getRGB(0, 0, width, height, pixels, 0, width);
        for (int charIndex = 0; charIndex < 256; ++charIndex) {
            int currentWidth;
            int charX = charIndex % 16;
            int charY = charIndex / 16;
            for (currentWidth = 8 * (width / 128) - 1; currentWidth >= 0; --currentWidth) {
                int xIndex = charX * (8 * (width / 128)) + currentWidth;
                boolean isPixelEmpty = true;
                for (int y = 0; y < 8 * (width / 128) && isPixelEmpty; ++y) {
                    int yIndex = (charY * (8 * (width / 128)) + y) * width;
                    int pixelRGB = pixels[xIndex + yIndex] & 0xFF;
                    if (pixelRGB <= 0) continue;
                    isPixelEmpty = false;
                }
                if (!isPixelEmpty) break;
            }
            if (charIndex == 32) {
                currentWidth = 2;
            }
            this.charWidth[charIndex] = currentWidth / (width / 128) + 2;
        }
        this.fontTextureID = renderengine.allocateAndSetupTexture(image);
        Tessellator t = Tessellator.instance;
        for (int charIndex = 0; charIndex < 256; ++charIndex) {
            GL11.glNewList(this.fontLists + charIndex, 4864);
            t.startDrawingQuads();
            int x = charIndex % 16 * 8;
            int y = charIndex / 16 * 8;
            float charSize = 7.99f;
            float xOffset = 0.0f;
            float yOffset = 0.0f;
            t.addVertexWithUV(0.0, 0.0f + charSize, 0.0, (float)x / 128.0f + xOffset, ((float)y + charSize) / 128.0f + yOffset);
            t.addVertexWithUV(0.0f + charSize, 0.0f + charSize, 0.0, ((float)x + charSize) / 128.0f + xOffset, ((float)y + charSize) / 128.0f + yOffset);
            t.addVertexWithUV(0.0f + charSize, 0.0, 0.0, ((float)x + charSize) / 128.0f + xOffset, (float)y / 128.0f + yOffset);
            t.addVertexWithUV(0.0, 0.0, 0.0, (float)x / 128.0f + xOffset, (float)y / 128.0f + yOffset);
            t.draw();
            GL11.glTranslatef(this.charWidth[charIndex], 0.0f, 0.0f);
            GL11.glEndList();
        }
        for (int i = 0; i < 32; ++i) {
            Color color = Colors.allChatColors[i & 0xF];
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            if (i >= 16) {
                r /= 4;
                g /= 4;
                b /= 4;
            }
            GL11.glNewList(this.fontLists + 256 + i, 4864);
            GL11.glColor3f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
            GL11.glEndList();
        }
    }

    public void drawCenteredString(String string, int x, int y, int color) {
        int length = this.getStringWidth(string);
        this.drawStringWithShadow(string, x - length / 2, y, color);
    }

    public void drawStringWithShadow(String string, int x, int y, int color) {
        this.renderString(string, x + 1, y + 1, color, true);
        this.drawString(string, x, y, color);
    }

    public void drawString(String string, int x, int y, int color) {
        this.renderString(string, x, y, color, false);
    }

    private void renderString(String string, int x, int y, int color, boolean isShadow) {
        if (string == null) {
            return;
        }
        if (isShadow) {
            int alphaChannelOnly = color & 0xFF000000;
            color = (color & 0xFCFCFC) >> 2;
            color += alphaChannelOnly;
        }
        GL11.glBindTexture(3553, this.fontTextureID);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        if (a == 0.0f) {
            a = 1.0f;
        }
        GL11.glColor4f(r, g, b, a);
        GL11.glPushMatrix();
        GL11.glTranslatef(x, y, 0.0f);
        this.listBuffer.clear();
        for (int i = 0; i < string.length(); ++i) {
            int charIndex;
            while (string.length() > i + 1 && string.charAt(i) == '\u00a7') {
                int colorCode = "0123456789abcdef".indexOf(string.toLowerCase().charAt(i + 1));
                this.bufferList(this.fontLists + 256 + colorCode + (isShadow ? 16 : 0));
                i += 2;
            }
            if (i >= string.length() || (charIndex = ChatAllowedCharacters.allowedCharacters.indexOf(string.charAt(i))) < 0) continue;
            this.bufferList(this.fontLists + charIndex + 32);
        }
        this.drawLists();
        GL11.glPopMatrix();
    }

    public void bufferList(int i) {
        this.listBuffer.put(i);
        if (this.listBuffer.remaining() == 0) {
            this.drawLists();
        }
    }

    public void drawLists() {
        this.listBuffer.flip();
        GL11.glCallLists(this.listBuffer);
        this.listBuffer.clear();
    }

    public int getStringWidth(String s) {
        if (s == null) {
            return 0;
        }
        int i = 0;
        for (int j = 0; j < s.length(); ++j) {
            if (s.charAt(j) == '\u00a7') {
                ++j;
                continue;
            }
            int k = ChatAllowedCharacters.allowedCharacters.indexOf(s.charAt(j));
            if (k < 0) continue;
            i += this.charWidth[k + 32];
        }
        return i;
    }

    public void func_27278_a(String s, int i, int j, int k, int l) {
        String[] as = s.split("\n");
        if (as.length > 1) {
            for (int i1 = 0; i1 < as.length; ++i1) {
                this.func_27278_a(as[i1], i, j, k, l);
                j += this.func_27277_a(as[i1], k);
            }
            return;
        }
        String[] as1 = s.split(" ");
        int j1 = 0;
        while (j1 < as1.length) {
            String s1 = as1[j1++] + " ";
            while (j1 < as1.length && this.getStringWidth(s1 + as1[j1]) < k) {
                s1 = s1 + as1[j1++] + " ";
            }
            while (this.getStringWidth(s1) > k) {
                int k1 = 0;
                while (this.getStringWidth(s1.substring(0, k1 + 1)) <= k) {
                    ++k1;
                }
                if (s1.substring(0, k1).trim().length() > 0) {
                    this.drawString(s1.substring(0, k1), i, j, l);
                    j += 8;
                }
                s1 = s1.substring(k1);
            }
            if (s1.trim().length() <= 0) continue;
            this.drawString(s1, i, j, l);
            j += 8;
        }
    }

    public int func_27277_a(String s, int i) {
        String[] as = s.split("\n");
        if (as.length > 1) {
            int j = 0;
            for (int k = 0; k < as.length; ++k) {
                j += this.func_27277_a(as[k], i);
            }
            return j;
        }
        String[] as1 = s.split(" ");
        int l = 0;
        int i1 = 0;
        while (l < as1.length) {
            String s1 = as1[l++] + " ";
            while (l < as1.length && this.getStringWidth(s1 + as1[l]) < i) {
                s1 = s1 + as1[l++] + " ";
            }
            while (this.getStringWidth(s1) > i) {
                int j1 = 0;
                while (this.getStringWidth(s1.substring(0, j1 + 1)) <= i) {
                    ++j1;
                }
                if (s1.substring(0, j1).trim().length() > 0) {
                    i1 += 8;
                }
                s1 = s1.substring(j1);
            }
            if (s1.trim().length() <= 0) continue;
            i1 += 8;
        }
        if (i1 < 8) {
            i1 += 8;
        }
        return i1;
    }
}

