/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class GLAllocation {
    public static List<Integer> displayLists = new ArrayList<Integer>();
    public static List<Integer> textureNames = new ArrayList<Integer>();

    public static synchronized int generateDisplayLists(int range) {
        int list = GL11.glGenLists(range);
        displayLists.add(list);
        displayLists.add(range);
        return list;
    }

    public static synchronized void generateTextureNames(IntBuffer intbuffer) {
        GL11.glGenTextures(intbuffer);
        for (int i = intbuffer.position(); i < intbuffer.limit(); ++i) {
            textureNames.add(intbuffer.get(i));
        }
    }

    public static synchronized int generateTexture() {
        int tex = GL11.glGenTextures();
        textureNames.add(tex);
        return tex;
    }

    public static synchronized void func_28194_b(int i) {
        int j = displayLists.indexOf(i);
        GL11.glDeleteLists(displayLists.get(j), displayLists.get(j + 1));
        displayLists.remove(j);
        displayLists.remove(j);
    }

    public static synchronized void deleteTexturesAndDisplayLists() {
        for (int i = 0; i < displayLists.size(); i += 2) {
            GL11.glDeleteLists(displayLists.get(i), displayLists.get(i + 1));
        }
        IntBuffer intbuffer = GLAllocation.createDirectIntBuffer(textureNames.size());
        intbuffer.flip();
        GL11.glDeleteTextures(intbuffer);
        for (int j = 0; j < textureNames.size(); ++j) {
            intbuffer.put(textureNames.get(j));
        }
        intbuffer.flip();
        GL11.glDeleteTextures(intbuffer);
        displayLists.clear();
        textureNames.clear();
    }

    public static synchronized ByteBuffer createDirectByteBuffer(int i) {
        ByteBuffer bytebuffer = ByteBuffer.allocateDirect(i).order(ByteOrder.nativeOrder());
        return bytebuffer;
    }

    public static IntBuffer createDirectIntBuffer(int i) {
        return GLAllocation.createDirectByteBuffer(i << 2).asIntBuffer();
    }

    public static FloatBuffer createDirectFloatBuffer(int i) {
        return GLAllocation.createDirectByteBuffer(i << 2).asFloatBuffer();
    }
}

