/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.time.LocalDateTime;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiTextField;
import net.minecraft.src.SavedServer;
import net.minecraft.src.SavedServerList;
import net.minecraft.src.StringTranslate;
import org.lwjgl.input.Keyboard;

public class GuiAddServer
extends GuiScreen {
    private GuiButton buttonSave;
    private GuiButton buttonCancel;
    private GuiTextField ipTextField;
    private GuiTextField serverNameTextField;
    private SavedServerList serverList;

    public GuiAddServer(GuiScreen guiscreen, SavedServerList serverList) {
        super(guiscreen);
        this.serverList = serverList;
    }

    @Override
    public void updateScreen() {
        this.ipTextField.updateCursorCounter();
        this.serverNameTextField.updateCursorCounter();
    }

    @Override
    public void initGui() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        Keyboard.enableRepeatEvents(true);
        this.controlList.clear();
        this.buttonSave = new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + 12, stringtranslate.translateKey("addServer.save"));
        this.controlList.add(this.buttonSave);
        this.buttonCancel = new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + 12, stringtranslate.translateKey("gui.cancel"));
        this.controlList.add(this.buttonCancel);
        this.serverNameTextField = new GuiTextField(this, this.fontRenderer, this.width / 2 - 100, this.height / 4 - 10 + 18, 200, 20, "");
        this.serverNameTextField.isFocused = true;
        this.serverNameTextField.setMaxStringLength(32);
        this.ipTextField = new GuiTextField(this, this.fontRenderer, this.width / 2 - 100, this.height / 4 - 10 + 50 + 18, 200, 20, "");
        this.ipTextField.setMaxStringLength(128);
        this.buttonSave.enabled = false;
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents(false);
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 1) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (guibutton.id == 0) {
            String serverName = this.serverNameTextField.getText().trim();
            String ipText = this.ipTextField.getText().trim();
            if (serverName.isEmpty()) {
                serverName = "Minecraft Server";
            }
            this.serverList.servers.add(new SavedServer(serverName, ipText, LocalDateTime.now()));
            this.serverList.writeToFile();
            this.mc.displayGuiScreen(this.parentScreen);
        }
    }

    @Override
    public void keyTyped(char c, int i) {
        if (i != 14) {
            super.keyTyped(c, i);
        }
        if (i == 15) {
            if (!this.ipTextField.isFocused && !this.serverNameTextField.isFocused) {
                this.serverNameTextField.isFocused = true;
            } else {
                this.ipTextField.isFocused = !this.ipTextField.isFocused;
                this.serverNameTextField.isFocused = !this.serverNameTextField.isFocused;
            }
            return;
        }
        if (i == 28 && this.buttonSave.enabled) {
            this.actionPerformed(this.buttonSave);
        }
        if (this.ipTextField.isFocused) {
            this.ipTextField.textboxKeyTyped(c, i);
        }
        if (this.serverNameTextField.isFocused) {
            this.serverNameTextField.textboxKeyTyped(c, i);
        }
        this.buttonSave.enabled = this.ipTextField.getText().length() > 0;
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        this.ipTextField.mouseClicked(x, y, button);
        this.serverNameTextField.mouseClicked(x, y, button);
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, stringtranslate.translateKey("addServer.title"), this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.drawString(this.fontRenderer, stringtranslate.translateKey("addServer.serverName"), this.serverNameTextField.xPosition, this.serverNameTextField.yPosition - 14, 0xA0A0A0);
        this.drawString(this.fontRenderer, stringtranslate.translateKey("addServer.ipAddress"), this.ipTextField.xPosition, this.ipTextField.yPosition - 14, 0xA0A0A0);
        this.ipTextField.drawTextBox();
        this.serverNameTextField.drawTextBox();
        super.drawScreen(x, y, renderPartialTicks);
    }
}

