/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiComponentButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.helper.Listener;
import org.lwjgl.opengl.GL11;

public class GuiComponentSelect
extends GuiScreen {
    private GuiScreen parent;
    private Controller controller;
    private Listener<Component> listener;
    private String title;

    public GuiComponentSelect(GuiScreen parent, String title, Controller controller, Listener<Component> listener) {
        this.controller = controller;
        this.listener = listener;
        this.parent = parent;
        this.title = title;
    }

    @Override
    public void initGui() {
        int i = 0;
        for (Component comp : this.controller.getComponents()) {
            int x = i % 8;
            int y = i / 8;
            int w = 50;
            int h = 20;
            this.controlList.add(new GuiComponentButton(i, 16 + x * (w + 1), 64 + y * (h + 1), w - 2, h - 2, comp));
            ++i;
        }
        this.controlList.add(new GuiButton(-1, this.width / 2 - 100, this.height - 40, "Back").setListener(e -> this.mc.displayGuiScreen(this.parent)));
    }

    @Override
    public void keyTyped(char c, int i) {
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(x, y, renderPartialTicks);
        GL11.glEnable(3553);
        this.mc.fontRenderer.drawCenteredString(this.title, this.width / 2, 16, 0xFFFFFF);
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (guibutton instanceof GuiComponentButton) {
            GuiComponentButton b = (GuiComponentButton)guibutton;
            if (this.listener != null) {
                this.listener.listen(b.component);
            }
            this.mc.displayGuiScreen(this.parent);
        }
    }
}

