/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.Container;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderItem;
import net.minecraft.src.Slot;
import net.minecraft.src.SlotCrafting;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.TextureFX;
import net.minecraft.src.command.ChatColor;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainer
extends GuiScreen {
    private static RenderItem itemRenderer = new RenderItem();
    public int xSize = 176;
    public int ySize = 166;
    public Container inventorySlots;

    public GuiContainer(Container container) {
        this.inventorySlots = container;
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }

    protected abstract void drawGuiContainerBackgroundLayer(float var1);

    protected void drawGuiContainerForegroundLayer() {
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        this.drawDefaultBackground();
        int centerX = (this.width - this.xSize) / 2;
        int centerY = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(renderPartialTicks);
        GL11.glPushMatrix();
        GL11.glRotatef(120.0f, 1.0f, 0.0f, 0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(centerX, centerY, 0.0f);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glEnable(32826);
        Slot slot = null;
        for (int i1 = 0; i1 < this.inventorySlots.inventorySlots.size(); ++i1) {
            Slot slot1 = this.inventorySlots.inventorySlots.get(i1);
            this.drawSlotInventory(slot1);
            if (!this.getIsMouseOverSlot(slot1, x, y)) continue;
            slot = slot1;
            GL11.glDisable(2896);
            GL11.glDisable(2929);
            int j1 = slot1.xDisplayPosition;
            int l1 = slot1.yDisplayPosition;
            this.drawGradientRect(j1, l1, j1 + 16, l1 + 16, -2130706433, -2130706433);
            GL11.glEnable(2896);
            GL11.glEnable(2929);
        }
        InventoryPlayer inventoryplayer = this.mc.thePlayer.inventory;
        if (inventoryplayer.getHeldItemStack() != null) {
            GL11.glTranslatef(0.0f, 0.0f, 32.0f);
            itemRenderer.renderItemIntoGUI(this.fontRenderer, this.mc.renderEngine, inventoryplayer.getHeldItemStack(), x - centerX - 8, y - centerY - 8, 1.0f);
            itemRenderer.renderItemOverlayIntoGUI(this.fontRenderer, this.mc.renderEngine, inventoryplayer.getHeldItemStack(), x - centerX - 8, y - centerY - 8, 1.0f);
        }
        GL11.glDisable(32826);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable(2896);
        GL11.glDisable(2929);
        this.drawGuiContainerForegroundLayer();
        GL11.glPopMatrix();
        super.drawScreen(x, y, renderPartialTicks);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (inventoryplayer.getHeldItemStack() == null && slot != null && slot.hasStack()) {
            StringTranslate trans = StringTranslate.getInstance();
            StringBuilder text = new StringBuilder();
            boolean multiLine = false;
            boolean control = Keyboard.isKeyDown(29) || Keyboard.isKeyDown(157);
            boolean shift = Keyboard.isKeyDown(42) || Keyboard.isKeyDown(54);
            boolean showDescription = control;
            if (slot.discovered) {
                boolean isCrafting = slot instanceof SlotCrafting;
                if (isCrafting) {
                    showDescription = false;
                    if (((Boolean)this.mc.gameSettings.swapCraftingButtons.value).booleanValue()) {
                        boolean a = shift;
                        shift = control;
                        control = a;
                    }
                }
                String itemName = trans.translateKey(slot.getStack().getItemName() + ".name");
                String itemNick = slot.getStack().getItem().getItemNickname(slot.getStack());
                if (itemNick != null && itemNick.length() > 0 && slot.getStack().tag.getBoolean("overrideName")) {
                    itemName = itemNick;
                }
                if (slot.getStack().tag.getBoolean("overrideColor")) {
                    text.append(ChatColor.get(slot.getStack().getItem().getItemNameColor(slot.getStack())));
                }
                text.append(itemName);
                boolean debug = (Boolean)this.mc.gameSettings.showDebugScreen.value;
                if (debug) {
                    text.append(" #" + slot.getStack().itemID + ":" + slot.getStack().getMetadata());
                }
                if (debug) {
                    multiLine = true;
                    text.append('\n').append(ChatColor.lightGray + slot.getStack().getItemName());
                }
                if (slot.getStack().isItemStackDamageable() && !showDescription && slot.discovered && ((Boolean)this.mc.gameSettings.showItemDurability.value).booleanValue()) {
                    multiLine = true;
                    int durability = slot.getStack().getMaxDamage();
                    int remainingUses = durability - slot.getStack().getMetadata();
                    text.append('\n').append(ChatColor.lightGray + "" + remainingUses + " / " + durability);
                }
                if (showDescription) {
                    multiLine = true;
                    text.append('\n').append(GuiContainer.formatDescription(trans.translateKey(slot.getStack().getItemName() + ".desc"), 16));
                }
                if (isCrafting) {
                    if (shift && !control) {
                        text.append('\n').append(ChatColor.lightGray).append("Craft Stack");
                    }
                    if (control && !shift) {
                        text.append('\n').append(ChatColor.lightGray).append("Craft Once");
                    }
                    if (control && shift) {
                        text.append('\n').append(ChatColor.lightGray).append("Craft All");
                    }
                }
            } else {
                text.append("???");
                if (showDescription) {
                    multiLine = true;
                    text.append("\n").append(trans.translateKey("item.unknown.desc"));
                }
            }
            String str = text.toString();
            if (str.length() > 0) {
                this.drawTooltip(str, x, y, 8, -8, multiLine);
            }
        }
        GL11.glEnable(2929);
    }

    public static String formatDescription(String description, int preferredLineLength) {
        StringBuilder string = new StringBuilder();
        string.append(ChatColor.lightGray);
        int lineLength = 0;
        for (int i = 0; i < description.length(); ++i) {
            char c = description.charAt(i);
            if (c == ' ') {
                if (lineLength > preferredLineLength) {
                    lineLength = 0;
                    string.append("\n").append(ChatColor.lightGray);
                    continue;
                }
                string.append(c);
                continue;
            }
            ++lineLength;
            string.append(c);
        }
        return string.toString();
    }

    public void drawTooltip(String string, int x, int y, int offsetX, int offsetY, boolean multiLine) {
        String[] lines = string.split("\n");
        if (lines.length == 0) {
            return;
        }
        int lineSpacing = 3;
        int padding = 3;
        int width = 0;
        for (int i = 0; i < lines.length; ++i) {
            width = Math.max(width, this.fontRenderer.getStringWidth(lines[i]));
        }
        int height = lines.length * 8 + (lines.length - 1) * lineSpacing;
        if (x + offsetX + width + padding * 2 > this.mc.resolution.scaledWidth) {
            offsetX = -offsetX - width;
        }
        offsetY -= Math.max(0, y + height + offsetY + padding * 2 - this.mc.resolution.scaledHeight);
        this.drawGradientRect(x += offsetX, y += offsetY, x + width + padding * 2, y + height + padding * 2, -1073741824, -1073741824);
        for (int i = 0; i < lines.length; ++i) {
            this.fontRenderer.drawStringWithShadow(lines[i], x + padding, y + padding + i * (8 + lineSpacing), 0xFFFFFF);
        }
    }

    private void drawSlotInventory(Slot slot) {
        int k;
        int i = slot.xDisplayPosition;
        int j = slot.yDisplayPosition;
        ItemStack itemstack = slot.getStack();
        if (itemstack == null && (k = slot.getBackgroundIconIndex()) >= 0) {
            GL11.glDisable(2896);
            this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture("/gui/items.png"));
            this.drawTexturedModalRect(i, j, k % Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthItems, k / Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthItems, 16, 16, TextureFX.tileWidthItems, 1.0f / (float)(Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthItems));
            GL11.glEnable(2896);
            return;
        }
        itemRenderer.renderItemIntoGUI(this.fontRenderer, this.mc.renderEngine, itemstack, i, j, slot.discovered ? 1.0f : 0.0f, 1.0f);
        itemRenderer.renderItemOverlayIntoGUI(this.fontRenderer, this.mc.renderEngine, itemstack, i, j, slot.discovered);
    }

    private boolean getIsMouseOverSlot(Slot slot, int i, int j) {
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        return (i -= k) >= slot.xDisplayPosition - 1 && i < slot.xDisplayPosition + 16 + 1 && (j -= l) >= slot.yDisplayPosition - 1 && j < slot.yDisplayPosition + 16 + 1;
    }

    private Slot getSlotAtPosition(int i, int j) {
        for (int k = 0; k < this.inventorySlots.inventorySlots.size(); ++k) {
            Slot slot = this.inventorySlots.inventorySlots.get(k);
            if (!this.getIsMouseOverSlot(slot, i, j)) continue;
            return slot;
        }
        return null;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.mc.thePlayer.craftingInventory = this.inventorySlots;
    }

    @Override
    public void keyTyped(char c, int i) {
        if (i == 1 || this.mc.gameSettings.keyInventory.isKey(i) || i == 14) {
            this.mc.thePlayer.closeScreen();
        }
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        if (button == 0 || button == 1 || button == 10) {
            Slot slot = this.getSlotAtPosition(x, y);
            int l = (this.width - this.xSize) / 2;
            int i1 = (this.height - this.ySize) / 2;
            boolean flag = x < l || y < i1 || x >= l + this.xSize || y >= i1 + this.ySize;
            int j1 = -1;
            if (slot != null) {
                j1 = slot.id;
            }
            if (flag) {
                j1 = -999;
            }
            if (j1 != -1) {
                boolean control;
                boolean shift = j1 != -999 && (Keyboard.isKeyDown(42) || Keyboard.isKeyDown(54) || button == 10);
                boolean bl = control = j1 != -999 && (Keyboard.isKeyDown(29) || Keyboard.isKeyDown(157));
                if (((Boolean)this.mc.gameSettings.swapCraftingButtons.value).booleanValue()) {
                    boolean a = shift;
                    shift = control;
                    control = a;
                }
                this.mc.playerController.itemPickUpFromInventory(this.inventorySlots.windowId, j1, button == 10 ? 0 : button, shift, control, this.mc.thePlayer);
            }
        }
    }

    @Override
    public void mouseMovedOrUp(int i, int j, int k) {
        if (k != 0) {
            // empty if block
        }
    }

    @Override
    public void onGuiClosed() {
        if (this.mc.thePlayer == null) {
            return;
        }
        this.mc.playerController.func_20086_a(this.inventorySlots.windowId, this.mc.thePlayer);
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (!this.mc.thePlayer.isEntityAlive() || this.mc.thePlayer.isDead) {
            this.mc.thePlayer.closeScreen();
        }
    }
}

