/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.ChatAllowedCharacters;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Packet134ItemData;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiEditLabel
extends GuiScreen {
    private static final String allowedCharacters = ChatAllowedCharacters.allowedCharacters;
    protected String screenTitle = "Edit label text:";
    protected ItemStack item;
    protected String text;
    protected int xSize;
    protected int ySize;
    protected int slot;

    public GuiEditLabel(ItemStack item, int slot) {
        this.item = item;
        this.text = item.tag.getString("name");
        this.xSize = 176;
        this.ySize = 166;
        this.slot = slot;
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 0) {
            this.item.tag.setBoolean("overrideName", true);
            this.item.tag.setString("name", this.text);
            this.mc.displayGuiScreen(null);
            if (this.mc.theWorld.isMultiplayerAndNotHost) {
                this.mc.getSendQueue().addToSendQueue(new Packet134ItemData(this.slot, this.item.tag));
            }
        }
    }

    @Override
    public void drawScreen(int i, int j, float f) {
        this.drawDefaultBackground();
        int bgTex = this.mc.renderEngine.getTexture("/gui/scroll.png");
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.renderEngine.bindTexture(bgTex);
        int widthBG = this.width / 2 - 56;
        int heightBG = 89;
        this.drawTexturedModalRect(widthBG, 89, 0, 0, 113, 34);
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 40, 0xFFFFFF);
        this.drawCenteredString(this.fontRenderer, "\u00a7" + "0123456789abcdef".charAt(this.item.tag.getByte("color")) + "> " + this.text + " <", this.width / 2, 100, 0xFFFFFF);
        super.drawScreen(i, j, f);
    }

    @Override
    public void initGui() {
        this.controlList.clear();
        Keyboard.enableRepeatEvents(true);
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120, "Done"));
    }

    @Override
    public void keyTyped(char c, int i) {
        if (i == 14 && this.text.length() > 0) {
            this.text = this.text.substring(0, this.text.length() - 1);
        }
        if (allowedCharacters.indexOf(c) >= 0 && this.text.length() < 15) {
            this.text = this.text + c;
        }
        if (i == 28) {
            this.actionPerformed((GuiButton)this.controlList.get(0));
        }
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents(false);
    }
}

