/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.AchievementList;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GameSettings;
import net.minecraft.src.Gamemode;
import net.minecraft.src.GuiAchievements;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiContainer;
import net.minecraft.src.GuiStats;
import net.minecraft.src.Item;
import net.minecraft.src.ItemArmor;
import net.minecraft.src.ItemStack;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderManager;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.gui.GuiElement;
import net.minecraft.src.gui.GuiOptionButton;
import net.minecraft.src.gui.ListLayout;
import net.minecraft.src.helper.Color;
import net.minecraft.src.helper.DamageType;
import net.minecraft.src.option.BooleanOption;
import net.minecraft.src.option.Option;
import org.lwjgl.opengl.GL11;

public class GuiInventory
extends GuiContainer {
    private GuiButton armorButton;
    protected int armourValuesFloat = 130;
    protected int armourButtonFloatX = 20;
    private ListLayout overlayButtonsLayout = new ListLayout(this).setAlign(0.5, 0.5).setVertical(false).setElementSize(11, 11).setOffset(-88, -94).setMargin(1);
    private List<Integer> uvs = new ArrayList<Integer>();
    private DamageType hoveredDamageType;
    protected Color protectionOverlayBgColor = new Color().setRGBA(0, 0, 0, 127);
    protected float xSize_lo;
    protected float ySize_lo;

    public GuiInventory(EntityPlayer entityplayer) {
        super(entityplayer.inventorySlots);
        this.field_948_f = true;
        entityplayer.addStat(AchievementList.openInventory, 1);
    }

    @Override
    public void initGui() {
        this.controlList.clear();
        this.armorButton = new GuiButton(100, this.width / 2 - this.armourButtonFloatX, this.height / 2 - 74, 9, 9, "");
        this.armorButton.visible = false;
        boolean enableArmorButton = false;
        for (int i = 0; i < this.mc.thePlayer.inventory.getSizeInventory(); ++i) {
            ItemStack itemStack = this.mc.thePlayer.inventory.getStackInSlot(i);
            if (itemStack == null || !(itemStack.getItem() instanceof ItemArmor)) continue;
            enableArmorButton = true;
            break;
        }
        if (enableArmorButton) {
            this.armorButton = new GuiButton(100, this.width / 2 - this.armourButtonFloatX, this.height / 2 - 74, 9, 9, "");
            this.armorButton.visible = false;
            this.controlList.add(this.armorButton);
        } else {
            this.armorButton = null;
        }
        this.updateOverlayButtons();
    }

    public void updateOverlayButtons() {
        GameSettings settings = this.mc.gameSettings;
        boolean clock = false;
        boolean compass = false;
        boolean rotaryCalendar = false;
        if (this.mc.thePlayer.getGamemode() == Gamemode.creative) {
            clock = true;
            compass = true;
            rotaryCalendar = true;
        } else {
            for (int iinv = 0; iinv < this.mc.thePlayer.inventory.getSizeInventory(); ++iinv) {
                ItemStack item = this.mc.thePlayer.inventory.getStackInSlot(iinv);
                if (item == null) continue;
                if (item.itemID == Item.toolClock.itemID) {
                    clock = true;
                }
                if (item.itemID == Item.toolCompass.itemID) {
                    compass = true;
                }
                if (item.itemID != Item.toolCalendar.itemID) continue;
                rotaryCalendar = true;
            }
        }
        this.overlayButtonsLayout.elements.clear();
        if (compass) {
            this.overlayButtonsLayout.addElement(new GuiOptionButton<BooleanOption>(settings, settings.overlayShowCoords));
            this.uvs.add(0);
            this.overlayButtonsLayout.addElement(new GuiOptionButton<BooleanOption>(settings, settings.overlayShowDirection));
            this.uvs.add(1);
        }
        if (clock) {
            this.overlayButtonsLayout.addElement(new GuiOptionButton<BooleanOption>(settings, settings.overlayShowTime));
            this.uvs.add(2);
        }
        if (rotaryCalendar) {
            this.overlayButtonsLayout.addElement(new GuiOptionButton<BooleanOption>(settings, settings.overlayShowSeason));
            this.uvs.add(3);
            this.overlayButtonsLayout.addElement(new GuiOptionButton<BooleanOption>(settings, settings.overlayShowWeather));
            this.uvs.add(4);
        }
        this.overlayButtonsLayout.updateElementPositions();
        for (GuiElement element : this.overlayButtonsLayout.elements) {
            GuiButton button = (GuiButton)element;
            button.visible = false;
            this.controlList.add(button);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        this.fontRenderer.drawString("Crafting", 86, 16, 0x404040);
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        GuiOptionButton button;
        int i;
        super.drawScreen(x, y, renderPartialTicks);
        this.xSize_lo = x;
        this.ySize_lo = y;
        if (((Boolean)this.mc.gameSettings.armorProtectionOverlay.value).booleanValue() && this.armorButton != null) {
            this.drawProtectionOverlay(x, y);
        }
        int inventoryTex = this.mc.renderEngine.getTexture("/gui/inventory.png");
        this.mc.renderEngine.bindTexture(inventoryTex);
        GL11.glColor4d(1.0, 1.0, 1.0, 1.0);
        GL11.glDisable(3042);
        GL11.glEnable(3553);
        if (this.armorButton != null) {
            if (this.armorButton.isHovered(x, y)) {
                this.drawTexturedModalRect(this.armorButton.xPosition, this.armorButton.yPosition, 185, 0, this.armorButton.width, this.armorButton.height);
            } else {
                this.drawTexturedModalRect(this.armorButton.xPosition, this.armorButton.yPosition, 176, 0, this.armorButton.width, this.armorButton.height);
            }
        }
        for (i = 0; i < this.overlayButtonsLayout.elements.size(); ++i) {
            button = (GuiOptionButton)this.overlayButtonsLayout.elements.get(i);
            this.drawTexturedModalRect(button.xPosition + 1, button.yPosition + 1, 176, 9 + 9 * this.uvs.get(i), 9, 9);
            boolean val = true;
            if (button.option instanceof BooleanOption) {
                val = (Boolean)((Option)button.option).value;
            }
            if (val) continue;
            this.drawTexturedModalRect(button.xPosition + 1, button.yPosition + 1, 194, 0, 9, 9);
        }
        for (i = 0; i < this.overlayButtonsLayout.elements.size(); ++i) {
            button = (GuiOptionButton)this.overlayButtonsLayout.elements.get(i);
            if (!button.isHovered(x, y)) continue;
            this.fontRenderer.drawStringWithShadow(button.displayString, x + 8, y - 8, 0xFFFFFF);
        }
    }

    public void drawProtectionOverlay(int mouseX, int mouseY) {
        this.hoveredDamageType = null;
        int x = this.width / 2 - this.armourValuesFloat - 4;
        int y = this.height / 2 - 79;
        int w = 44;
        int h = 44;
        GL11.glEnable(3042);
        this.drawGradientRect(x, y, x + w, y + h, this.protectionOverlayBgColor.getARGB(), this.protectionOverlayBgColor.getARGB());
        int iconsTex = this.mc.renderEngine.getTexture("/gui/icons.png");
        this.mc.renderEngine.bindTexture(iconsTex);
        GL11.glDisable(3042);
        GL11.glDisable(2884);
        int w2 = 26;
        int x2 = x;
        int h2 = 4;
        int i = 0;
        for (DamageType damageType : DamageType.values()) {
            if (damageType.display()) {
                int y2 = y + i * 10;
                float protection = this.mc.thePlayer.inventory.getTotalProtectionAmount(damageType);
                if (protection > 1.0f) {
                    protection = 1.0f;
                }
                int l = (int)(protection * 255.0f);
                int color = 255 - l << 16 | l << 8 | 0xFF000000;
                GL11.glEnable(3553);
                GL11.glColor4d(1.0, 1.0, 1.0, 1.0);
                this.drawTexturedModalRect(x2 + 2, y2 + 2, 0, 16 + 9 * damageType.getTexcoord(), 9, 9);
                GL11.glDisable(3553);
                this.drawRectBetter(x2 + 14, y2 + 4, w2 + 2, h2 + 1, -16777216);
                this.drawRectBetter(x2 + 15, y2 + 4, (int)(protection * (float)w2), h2, color);
                if (mouseX >= x2 && mouseY >= y2 + 2 && mouseX <= x2 + w && mouseY <= y2 + 12) {
                    this.hoveredDamageType = damageType;
                }
            }
            ++i;
        }
        GL11.glEnable(3553);
        if (this.hoveredDamageType != null) {
            int protection = Math.round(this.mc.thePlayer.inventory.getTotalProtectionAmount(this.hoveredDamageType) * 100.0f);
            if (protection < 0) {
                protection = 0;
            }
            if (protection > 100) {
                protection = 100;
            }
            String str = StringTranslate.getInstance().translateKey("damagetype." + this.hoveredDamageType.name().toLowerCase()) + ":\n" + protection + " / 100";
            this.drawTooltip(str, mouseX, mouseY, 8, -8, true);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f) {
        int inventoryTex = this.mc.renderEngine.getTexture("/gui/inventory.png");
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.renderEngine.bindTexture(inventoryTex);
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
        GL11.glEnable(32826);
        GL11.glEnable(2903);
        GL11.glPushMatrix();
        GL11.glTranslatef(j + 51, k + 75, 50.0f);
        float f1 = 30.0f;
        GL11.glScalef(-f1, f1, f1);
        GL11.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
        float f2 = this.mc.thePlayer.renderYawOffset;
        float f3 = this.mc.thePlayer.rotationYaw;
        float f4 = this.mc.thePlayer.rotationPitch;
        float f5 = (float)(j + 51) - this.xSize_lo;
        float f6 = (float)(k + 75 - 50) - this.ySize_lo;
        GL11.glRotatef(135.0f, 0.0f, 1.0f, 0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glRotatef(-135.0f, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(-((float)Math.atan(f6 / 40.0f)) * 20.0f, 1.0f, 0.0f, 0.0f);
        this.mc.thePlayer.renderYawOffset = (float)Math.atan(f5 / 40.0f) * 20.0f;
        this.mc.thePlayer.rotationYaw = (float)Math.atan(f5 / 40.0f) * 40.0f;
        this.mc.thePlayer.rotationPitch = -((float)Math.atan(f6 / 40.0f)) * 20.0f;
        this.mc.thePlayer.entityBrightness = 1.0f;
        GL11.glTranslatef(0.0f, this.mc.thePlayer.yOffset, 0.0f);
        RenderManager.instance.playerViewY = 180.0f;
        RenderManager.instance.renderEntityWithPosYaw(this.mc.thePlayer, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        this.mc.thePlayer.entityBrightness = 0.0f;
        this.mc.thePlayer.renderYawOffset = f2;
        this.mc.thePlayer.rotationYaw = f3;
        this.mc.thePlayer.rotationPitch = f4;
        GL11.glPopMatrix();
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable(32826);
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (guibutton.id == 0) {
            this.mc.displayGuiScreen(new GuiAchievements(this, this.mc.statFileWriter));
        }
        if (guibutton.id == 1) {
            this.mc.displayGuiScreen(new GuiStats(this, this.mc.statFileWriter));
        }
        if (guibutton == this.armorButton) {
            this.mc.gameSettings.armorProtectionOverlay.toggle();
        }
    }
}

