/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiSlider;
import net.minecraft.src.ScreenShotHelper;
import net.minecraft.src.render.IRenderer;
import net.minecraft.src.render.PhotoModeRenderer;
import net.minecraft.src.render.Shaders;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiPhotoMode
extends GuiScreen {
    private GuiButton buttonRotateLeft;
    private GuiButton buttonRotateRight;
    private GuiSlider sliderTimeOfDay;
    private GuiButton buttonSeason;
    private GuiButton buttonTakeScreenshot;
    private GuiButton buttonExit;
    private GuiSlider sliderFog;
    private GuiSlider sliderTilt;
    private GuiButton buttonShaders;
    private GuiSlider sliderIntensity;
    private long originalTOD;
    private long desiredTOD = -1L;
    private long desiredDay = -1L;
    private int desiredSeason = -1;
    public float intensityValue = 1.0f;
    boolean shouldScreenshot = false;
    private PhotoModeRenderer photoModeRenderer;
    public IRenderer renderer;

    public GuiPhotoMode() {
        Minecraft mc = Minecraft.getMinecraft();
        if (Shaders.shadersCompatible) {
            this.photoModeRenderer = new PhotoModeRenderer(mc, this);
        }
        this.renderer = mc.render;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.mc.isometricMode = true;
        this.buttonExit = new GuiButton(5, 0, 0, 20, 20, "X");
        this.buttonRotateLeft = new GuiButton(0, this.width / 2 - 49 - 2 - 20, this.height - 20, 20, 20, "<");
        this.buttonRotateRight = new GuiButton(1, this.width / 2 + 49 + 2, this.height - 20, 20, 20, ">");
        this.buttonTakeScreenshot = new GuiButton(4, this.width / 2 - 49, this.height - 20, 98, 20, "Take Screenshot");
        this.sliderTimeOfDay = new GuiSlider(2, this.width - 120, 0, 120, 20, "Time of Day: DEFAULT", 0.0f);
        this.buttonSeason = new GuiButton(3, this.width - 120, 0, 120, 20, "Season: DEFAULT");
        this.sliderFog = new GuiSlider(6, this.width - 120, 0, 120, 20, "Fog: 1.0", 1.0f);
        this.sliderTilt = new GuiSlider(7, this.width - 120, 0, 120, 20, "Tilt: Default", 0.33333334f);
        if (Shaders.shadersCompatible) {
            this.buttonShaders = new GuiButton(8, this.width - 120, 0, 120, 20, "Shader: None");
            this.sliderIntensity = new GuiSlider(9, this.width - 120, 0, 120, 20, "Intensity: 100%", this.intensityValue);
            if (this.photoModeRenderer.getActiveShader() == null) {
                this.sliderIntensity.enabled = false;
            }
        }
        this.controlList.add(this.sliderTilt);
        if (Shaders.shadersCompatible) {
            this.mc.setRenderer(this.photoModeRenderer);
        }
        if (!this.mc.theWorld.isMultiplayerAndNotHost) {
            this.controlList.add(this.sliderTimeOfDay);
            this.controlList.add(this.sliderFog);
            this.controlList.add(this.buttonSeason);
        }
        if (Shaders.shadersCompatible) {
            this.controlList.add(this.buttonShaders);
            this.controlList.add(this.sliderIntensity);
        }
        int i = 0;
        for (GuiButton button : this.controlList) {
            button.yPosition = i++ * 20;
        }
        this.controlList.add(this.buttonRotateLeft);
        this.controlList.add(this.buttonRotateRight);
        this.controlList.add(this.buttonTakeScreenshot);
        this.controlList.add(this.buttonExit);
        this.originalTOD = this.mc.theWorld.getWorldTime();
        if (this.desiredTOD == -1L) {
            this.desiredTOD = this.originalTOD % (long)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS;
        } else {
            this.sliderTimeOfDay.sliderValue = (float)this.desiredTOD / (float)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS;
        }
        if (this.desiredDay == -1L) {
            this.desiredDay = this.originalTOD / (long)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS;
        }
        this.updateButtonsText();
    }

    @Override
    public void onGuiClosed() {
        this.mc.isometricMode = false;
        this.mc.isometricRotation = 0.0f;
        this.mc.isometricRotationGoal = 0.0f;
        this.mc.isometricZoom = 1.0f;
        this.mc.isometricZoomGoal = 1.0f;
        this.mc.isometricTilt = 30.0f;
        this.mc.isometricTiltGoal = 30.0f;
        this.mc.fogOverride = 1.0f;
        this.mc.isometricFogGoal = 1.0f;
        this.mc.theWorld.setWorldTimeUpdateTicks(this.originalTOD);
        if (Shaders.shadersCompatible) {
            this.mc.setRenderer(this.renderer);
        }
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (guibutton == this.buttonRotateLeft) {
            this.mc.isometricRotationGoal += 0.5f;
        } else if (guibutton == this.buttonRotateRight) {
            this.mc.isometricRotationGoal -= 0.5f;
        } else if (guibutton == this.buttonSeason) {
            ++this.desiredSeason;
            if (this.desiredSeason > 3) {
                this.desiredSeason = -1;
            }
            this.desiredDay = this.desiredSeason == -1 ? this.originalTOD / (long)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS : (long)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS * 7L * (long)this.desiredSeason + (long)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS * 3L;
            this.mc.theWorld.setWorldTimeUpdateTicks(this.desiredDay + this.desiredTOD);
            this.mc.theWorld.doSeasonUpdate();
        } else if (guibutton == this.buttonTakeScreenshot) {
            this.shouldScreenshot = true;
        } else if (guibutton == this.buttonExit) {
            this.mc.displayGuiScreen(null);
        } else if (guibutton == this.buttonShaders) {
            boolean ctrl;
            boolean bl = ctrl = Keyboard.isKeyDown(29) || Keyboard.isKeyDown(157);
            if (ctrl) {
                this.photoModeRenderer.first();
            } else {
                this.photoModeRenderer.next();
            }
            this.sliderIntensity.enabled = this.photoModeRenderer.getActiveShader() != null;
        }
        this.updateButtonsText();
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        GL11.glViewport(0, 0, this.mc.resolution.width, this.mc.resolution.height);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glClear(256);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.mc.resolution.scaledWidth, this.mc.resolution.scaledHeight, 0.0, 1000.0, 3000.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -2000.0f);
        if (this.mc.isometricZoom != this.mc.isometricZoomGoal) {
            this.mc.isometricZoom += (this.mc.isometricZoomGoal - this.mc.isometricZoom) * 0.02f + (this.mc.isometricZoomGoal - this.mc.isometricZoom) * 0.02f * renderPartialTicks;
            if (Math.abs(this.mc.isometricZoom - this.mc.isometricZoomGoal) < 5.0E-4f) {
                this.mc.isometricZoom = this.mc.isometricZoomGoal;
            }
        }
        if (this.mc.isometricRotation != this.mc.isometricRotationGoal) {
            this.mc.isometricRotation += (this.mc.isometricRotationGoal - this.mc.isometricRotation) * 0.02f + (this.mc.isometricRotationGoal - this.mc.isometricRotation) * 0.02f * renderPartialTicks;
            if (Math.abs(this.mc.isometricRotation - this.mc.isometricRotationGoal) < 5.0E-4f) {
                this.mc.isometricRotation = this.mc.isometricRotationGoal;
            }
        }
        if (this.mc.isometricTilt != this.mc.isometricTiltGoal) {
            this.mc.isometricTilt += (this.mc.isometricTiltGoal - this.mc.isometricTilt) * 0.02f + (this.mc.isometricTiltGoal - this.mc.isometricTilt) * 0.02f * renderPartialTicks;
            if (Math.abs(this.mc.isometricTilt - this.mc.isometricTiltGoal) < 0.01f) {
                this.mc.isometricTilt = this.mc.isometricTiltGoal;
            }
        }
        if (this.mc.isometricFogGoal != this.mc.fogOverride) {
            this.mc.fogOverride += (this.mc.isometricFogGoal - this.mc.fogOverride) * 0.02f + (this.mc.isometricFogGoal - this.mc.fogOverride) * 0.02f * renderPartialTicks;
            if (Math.abs(this.mc.fogOverride - this.mc.isometricFogGoal) < 5.0E-5f) {
                this.mc.fogOverride = this.mc.isometricFogGoal;
            }
        }
        if (!this.shouldScreenshot) {
            super.drawScreen(x, y, renderPartialTicks);
        } else {
            ScreenShotHelper.saveScreenshot(Minecraft.getMinecraftDir(), this.mc.resolution.width, this.mc.resolution.height);
            this.shouldScreenshot = false;
        }
        this.scroll(Mouse.getDWheel());
        if (this.sliderTimeOfDay.dragging) {
            long sliderTOD = (long)(this.sliderTimeOfDay.sliderValue * (float)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS);
            this.desiredTOD = this.sliderTimeOfDay.sliderValue == 0.0f ? this.originalTOD % (long)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS : sliderTOD;
            this.mc.theWorld.setWorldTimeUpdateTicks(this.desiredDay + this.desiredTOD);
            this.mc.theWorld.doLightingUpdate();
            this.updateButtonsText();
        }
        if (this.sliderTilt.dragging) {
            float tiltAngle;
            this.mc.isometricTiltGoal = tiltAngle = (float)((int)(this.sliderTilt.sliderValue * 90.0f));
            this.updateButtonsText();
        }
        if (this.sliderFog.dragging) {
            this.mc.isometricFogGoal = (float)Math.pow(2.0, 8.0f * this.sliderFog.sliderValue - 8.0f);
            this.updateButtonsText();
        }
        if (Shaders.shadersCompatible && this.sliderIntensity.dragging) {
            this.intensityValue = this.sliderIntensity.sliderValue;
            this.updateButtonsText();
        }
    }

    private void updateButtonsText() {
        if (this.buttonSeason != null) {
            if (this.desiredSeason == -1) {
                this.buttonSeason.displayString = "Season: Default";
            } else if (this.desiredSeason == 0) {
                this.buttonSeason.displayString = "Season: Spring";
            } else if (this.desiredSeason == 1) {
                this.buttonSeason.displayString = "Season: Summer";
            } else if (this.desiredSeason == 2) {
                this.buttonSeason.displayString = "Season: Fall";
            } else if (this.desiredSeason == 3) {
                this.buttonSeason.displayString = "Season: Winter";
            }
        }
        this.sliderTimeOfDay.displayString = this.sliderTimeOfDay.sliderValue == 0.0f ? "Time of Day: Default" : "Time of Day: " + (long)(this.sliderTimeOfDay.sliderValue * (float)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS);
        this.sliderFog.displayString = "Fog Distance: " + (int)(this.sliderFog.sliderValue * 100.0f) + "%";
        this.sliderTilt.displayString = (int)(this.sliderTilt.sliderValue * 90.0f) == 30 ? "Tilt: Default" : "Tilt: " + (int)(this.sliderTilt.sliderValue * 90.0f) + " degrees";
        if (Shaders.shadersCompatible) {
            String activeShader = this.photoModeRenderer.getActiveShader();
            if (activeShader == null) {
                activeShader = "none";
            }
            activeShader = activeShader.substring(0, 1).toUpperCase() + activeShader.substring(1);
            this.buttonShaders.displayString = "Shader: " + activeShader;
            this.sliderIntensity.displayString = "Intensity: " + (int)(this.sliderIntensity.sliderValue * 100.0f) + "%";
        }
    }

    public void scroll(int i) {
        if (i < 0) {
            this.mc.isometricZoomGoal -= 0.25f;
        } else if (i > 0) {
            this.mc.isometricZoomGoal += 0.25f;
        }
    }
}

