/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiCreateWorld;
import net.minecraft.src.GuiRenameWorld;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiWorldSlot;
import net.minecraft.src.GuiYesNo;
import net.minecraft.src.ISaveFormat;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PlayerControllerSP;
import net.minecraft.src.SaveFormatComparator;
import net.minecraft.src.StringTranslate;

public class GuiSelectWorld
extends GuiScreen {
    private final DateFormat dateFormatter = new SimpleDateFormat();
    protected String screenTitle = "Select world";
    private boolean selected = false;
    private int selectedWorld;
    private List saveList;
    private GuiWorldSlot worldSlotContainer;
    private String field_22098_o;
    private String field_22097_p;
    private boolean deleting;
    private GuiButton buttonRename;
    private GuiButton buttonSelect;
    private GuiButton buttonDelete;

    public GuiSelectWorld(GuiScreen guiscreen) {
        super(guiscreen);
    }

    @Override
    public void initGui() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.screenTitle = stringtranslate.translateKey("selectWorld.title");
        this.field_22098_o = stringtranslate.translateKey("selectWorld.world");
        this.field_22097_p = stringtranslate.translateKey("selectWorld.conversion");
        this.loadSaves();
        this.worldSlotContainer = new GuiWorldSlot(this);
        this.worldSlotContainer.registerScrollButtons(this.controlList, 4, 5);
        this.initButtons();
    }

    private void loadSaves() {
        ISaveFormat isaveformat = this.mc.getSaveLoader();
        this.saveList = isaveformat.getSaveList();
        Collections.sort(this.saveList);
        this.selectedWorld = -1;
    }

    protected String getSaveFileName(int i) {
        return ((SaveFormatComparator)this.saveList.get(i)).getFileName();
    }

    protected String getSaveName(int i) {
        String s = ((SaveFormatComparator)this.saveList.get(i)).getDisplayName();
        if (s == null || MathHelper.stringNullOrLengthZero(s)) {
            StringTranslate stringtranslate = StringTranslate.getInstance();
            s = stringtranslate.translateKey("selectWorld.world") + " " + (i + 1);
        }
        return s;
    }

    public void initButtons() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.buttonSelect = new GuiButton(1, this.width / 2 - 154, this.height - 52, 150, 20, stringtranslate.translateKey("selectWorld.select"));
        this.controlList.add(this.buttonSelect);
        this.buttonRename = new GuiButton(6, this.width / 2 - 154, this.height - 28, 70, 20, stringtranslate.translateKey("selectWorld.rename"));
        this.controlList.add(this.buttonRename);
        this.buttonDelete = new GuiButton(2, this.width / 2 - 74, this.height - 28, 70, 20, stringtranslate.translateKey("selectWorld.delete"));
        this.controlList.add(this.buttonDelete);
        this.controlList.add(new GuiButton(3, this.width / 2 + 4, this.height - 52, 150, 20, stringtranslate.translateKey("selectWorld.create")));
        this.controlList.add(new GuiButton(0, this.width / 2 + 4, this.height - 28, 150, 20, stringtranslate.translateKey("gui.cancel")));
        this.buttonSelect.enabled = false;
        this.buttonRename.enabled = false;
        this.buttonDelete.enabled = false;
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 2) {
            String s = this.getSaveName(this.selectedWorld);
            if (s != null) {
                this.deleting = true;
                StringTranslate stringtranslate = StringTranslate.getInstance();
                String s1 = stringtranslate.translateKey("selectWorld.deleteQuestion");
                String s2 = "'" + s + "' " + stringtranslate.translateKey("selectWorld.deleteWarning");
                String s3 = stringtranslate.translateKey("selectWorld.deleteButton");
                String s4 = stringtranslate.translateKey("gui.cancel");
                GuiYesNo guiyesno = new GuiYesNo(this, s1, s2, s3, s4, this.selectedWorld);
                this.mc.displayGuiScreen(guiyesno);
            }
        } else if (guibutton.id == 1) {
            this.selectWorld(this.selectedWorld);
        } else if (guibutton.id == 3) {
            this.mc.displayGuiScreen(new GuiCreateWorld(this));
        } else if (guibutton.id == 6) {
            this.mc.displayGuiScreen(new GuiRenameWorld(this, this.getSaveFileName(this.selectedWorld)));
        } else if (guibutton.id == 0) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else {
            this.worldSlotContainer.actionPerformed(guibutton);
        }
    }

    public void selectWorld(int i) {
        this.mc.displayGuiScreen(null);
        if (this.selected) {
            return;
        }
        this.selected = true;
        this.mc.playerController = new PlayerControllerSP(this.mc);
        String s = this.getSaveFileName(i);
        if (s == null) {
            s = "World" + i;
        }
        this.mc.startWorld(s, this.getSaveName(i), 0L);
        this.mc.displayGuiScreen(null);
    }

    @Override
    public void deleteWorld(boolean flag, int i) {
        if (this.deleting) {
            this.deleting = false;
            if (flag) {
                ISaveFormat isaveformat = this.mc.getSaveLoader();
                isaveformat.flushCache();
                isaveformat.deleteSave(this.getSaveFileName(i));
                this.loadSaves();
            }
            this.mc.displayGuiScreen(this);
        }
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        this.worldSlotContainer.drawScreen(x, y, renderPartialTicks);
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(x, y, renderPartialTicks);
    }

    static List getSize(GuiSelectWorld guiselectworld) {
        return guiselectworld.saveList;
    }

    static int onElementSelected(GuiSelectWorld guiselectworld, int i) {
        guiselectworld.selectedWorld = i;
        return guiselectworld.selectedWorld;
    }

    static int getSelectedWorld(GuiSelectWorld guiselectworld) {
        return guiselectworld.selectedWorld;
    }

    static GuiButton getSelectButton(GuiSelectWorld guiselectworld) {
        return guiselectworld.buttonSelect;
    }

    static GuiButton getRenameButton(GuiSelectWorld guiselectworld) {
        return guiselectworld.buttonRename;
    }

    static GuiButton getDeleteButton(GuiSelectWorld guiselectworld) {
        return guiselectworld.buttonDelete;
    }

    static String func_22087_f(GuiSelectWorld guiselectworld) {
        return guiselectworld.field_22098_o;
    }

    static DateFormat getDateFormatter(GuiSelectWorld guiselectworld) {
        return guiselectworld.dateFormatter;
    }

    static String func_22088_h(GuiSelectWorld guiselectworld) {
        return guiselectworld.field_22097_p;
    }
}

