/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.src.GuiButton;
import net.minecraft.src.Tessellator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiSlot {
    private final Minecraft mc;
    private final int width;
    private final int height;
    protected final int top;
    protected final int bottom;
    private final int right;
    private final int left = 0;
    protected final int posZ;
    private int scrollUpButtonID;
    private int scrollDownButtonID;
    private float initialClickY = -2.0f;
    private float scrollMultiplier;
    private float amountScrolled;
    private int selectedElement = -1;
    private long lastClicked = 0L;
    private boolean field_25123_p = true;
    private boolean field_27262_q;
    private int field_27261_r;

    public GuiSlot(Minecraft minecraft, int i, int j, int k, int l, int i1) {
        this.mc = minecraft;
        this.width = i;
        this.height = j;
        this.top = k;
        this.bottom = l;
        this.posZ = i1;
        this.right = i;
    }

    public void func_27258_a(boolean flag) {
        this.field_25123_p = flag;
    }

    protected void func_27259_a(boolean flag, int i) {
        this.field_27262_q = flag;
        this.field_27261_r = i;
        if (!flag) {
            this.field_27261_r = 0;
        }
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2);

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        return this.getSize() * this.posZ + this.field_27261_r;
    }

    protected abstract void drawBackground();

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5);

    protected void func_27260_a(int i, int j, Tessellator tessellator) {
    }

    protected void func_27255_a(int i, int j) {
    }

    protected void func_27257_b(int i, int j) {
    }

    public int func_27256_c(int i, int j) {
        int k = this.width / 2 - 110;
        int l = this.width / 2 + 110;
        int i1 = j - this.top - this.field_27261_r + (int)this.amountScrolled - 4;
        int j1 = i1 / this.posZ;
        if (i >= k && i <= l && j1 >= 0 && i1 >= 0 && j1 < this.getSize()) {
            return j1;
        }
        return -1;
    }

    public void registerScrollButtons(List list, int i, int j) {
        this.scrollUpButtonID = i;
        this.scrollDownButtonID = j;
    }

    private void bindAmountScrolled() {
        int i = this.getContentHeight() - (this.bottom - this.top - 4);
        if (i < 0) {
            i /= 2;
        }
        if (this.amountScrolled < 0.0f) {
            this.amountScrolled = 0.0f;
        }
        if (this.amountScrolled > (float)i) {
            this.amountScrolled = i;
        }
    }

    public void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == this.scrollUpButtonID) {
            this.amountScrolled -= (float)(this.posZ * 2 / 3);
            this.initialClickY = -2.0f;
            this.bindAmountScrolled();
        } else if (guibutton.id == this.scrollDownButtonID) {
            this.amountScrolled += (float)(this.posZ * 2 / 3);
            this.initialClickY = -2.0f;
            this.bindAmountScrolled();
        }
    }

    public void drawScreen(int i, int j, float f) {
        this.drawBackground();
        int k = this.getSize();
        int l = this.width / 2 + 124;
        int i1 = l + 6;
        if (Mouse.isButtonDown(0) || this.mc.controllerInput != null && this.mc.controllerInput.buttonA.isPressed()) {
            if (this.initialClickY == -1.0f) {
                boolean flag = true;
                if (j >= this.top && j <= this.bottom) {
                    int j1 = this.width / 2 - 110;
                    int k1 = this.width / 2 + 110;
                    int i2 = j - this.top - this.field_27261_r + (int)this.amountScrolled - 4;
                    int k2 = i2 / this.posZ;
                    if (i >= j1 && i <= k1 && k2 >= 0 && i2 >= 0 && k2 < k) {
                        boolean flag1 = k2 == this.selectedElement && System.currentTimeMillis() - this.lastClicked < 250L;
                        this.elementClicked(k2, flag1);
                        this.selectedElement = k2;
                        this.lastClicked = System.currentTimeMillis();
                    } else if (i >= j1 && i <= k1 && i2 < 0) {
                        this.func_27255_a(i - j1, j - this.top + (int)this.amountScrolled - 4);
                        flag = false;
                    }
                    if (i >= l && i <= i1) {
                        int l3;
                        this.scrollMultiplier = -1.0f;
                        int i3 = this.getContentHeight() - (this.bottom - this.top - 4);
                        if (i3 < 1) {
                            i3 = 1;
                        }
                        if ((l3 = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                            l3 = 32;
                        }
                        if (l3 > this.bottom - this.top - 8) {
                            l3 = this.bottom - this.top - 8;
                        }
                        this.scrollMultiplier /= (float)(this.bottom - this.top - l3) / (float)i3;
                    } else {
                        this.scrollMultiplier = 1.0f;
                    }
                    this.initialClickY = flag ? (float)j : -2.0f;
                } else {
                    this.initialClickY = -2.0f;
                }
            } else if (this.initialClickY >= 0.0f) {
                this.amountScrolled -= ((float)j - this.initialClickY) * this.scrollMultiplier;
                this.initialClickY = j;
            }
        } else {
            this.initialClickY = -1.0f;
        }
        this.bindAmountScrolled();
        GL11.glDisable(2896);
        GL11.glDisable(2912);
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture(3553, this.mc.renderEngine.getTexture("/gui/background.png"));
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        float f1 = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x202020);
        tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0f / f1, (float)(this.bottom + (int)this.amountScrolled) / f1);
        tessellator.addVertexWithUV(this.right, this.bottom, 0.0, (float)this.right / f1, (float)(this.bottom + (int)this.amountScrolled) / f1);
        tessellator.addVertexWithUV(this.right, this.top, 0.0, (float)this.right / f1, (float)(this.top + (int)this.amountScrolled) / f1);
        tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0f / f1, (float)(this.top + (int)this.amountScrolled) / f1);
        tessellator.draw();
        int l1 = this.width / 2 - 92 - 16;
        int j2 = this.top + 4 - (int)this.amountScrolled;
        if (this.field_27262_q) {
            this.func_27260_a(l1, j2, tessellator);
        }
        for (int l2 = 0; l2 < k; ++l2) {
            int j3 = j2 + l2 * this.posZ + this.field_27261_r;
            int i4 = this.posZ - 4;
            if (j3 > this.bottom || j3 + i4 < this.top) continue;
            if (this.field_25123_p && this.isSelected(l2)) {
                int k4 = this.width / 2 - 110;
                int i5 = this.width / 2 + 110;
                GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                GL11.glDisable(3553);
                tessellator.startDrawingQuads();
                tessellator.setColorOpaque_I(0x808080);
                tessellator.addVertexWithUV(k4, j3 + i4 + 2, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(i5, j3 + i4 + 2, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(i5, j3 - 2, 0.0, 1.0, 0.0);
                tessellator.addVertexWithUV(k4, j3 - 2, 0.0, 0.0, 0.0);
                tessellator.setColorOpaque_I(0);
                tessellator.addVertexWithUV(k4 + 1, j3 + i4 + 1, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(i5 - 1, j3 + i4 + 1, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(i5 - 1, j3 - 1, 0.0, 1.0, 0.0);
                tessellator.addVertexWithUV(k4 + 1, j3 - 1, 0.0, 0.0, 0.0);
                tessellator.draw();
                GL11.glEnable(3553);
            }
            this.drawSlot(l2, l1, j3, i4, tessellator);
        }
        GL11.glDisable(2929);
        int byte0 = 4;
        this.overlayBackground(0, this.top, 255, 255);
        this.overlayBackground(this.bottom, this.height, 255, 255);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glDisable(3008);
        GL11.glShadeModel(7425);
        GL11.glDisable(3553);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0, 0);
        tessellator.addVertexWithUV(0.0, this.top + byte0, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(this.right, this.top + byte0, 0.0, 1.0, 1.0);
        tessellator.setColorRGBA_I(0, 255);
        tessellator.addVertexWithUV(this.right, this.top, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, 0.0);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0, 255);
        tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(this.right, this.bottom, 0.0, 1.0, 1.0);
        tessellator.setColorRGBA_I(0, 0);
        tessellator.addVertexWithUV(this.right, this.bottom - byte0, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, this.bottom - byte0, 0.0, 0.0, 0.0);
        tessellator.draw();
        int k3 = this.getContentHeight() - (this.bottom - this.top - 4);
        if (k3 > 0) {
            int l4;
            int j4 = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            if (j4 < 32) {
                j4 = 32;
            }
            if (j4 > this.bottom - this.top - 8) {
                j4 = this.bottom - this.top - 8;
            }
            if ((l4 = (int)this.amountScrolled * (this.bottom - this.top - j4) / k3 + this.top) < this.top) {
                l4 = this.top;
            }
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0, 255);
            tessellator.addVertexWithUV(l, this.bottom, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(i1, this.bottom, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(i1, this.top, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(l, this.top, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0x808080, 255);
            tessellator.addVertexWithUV(l, l4 + j4, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(i1, l4 + j4, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(i1, l4, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(l, l4, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0xC0C0C0, 255);
            tessellator.addVertexWithUV(l, l4 + j4 - 1, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(i1 - 1, l4 + j4 - 1, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(i1 - 1, l4, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(l, l4, 0.0, 0.0, 0.0);
            tessellator.draw();
        }
        this.func_27257_b(i, j);
        GL11.glEnable(3553);
        GL11.glShadeModel(7424);
        GL11.glEnable(3008);
        GL11.glDisable(3042);
    }

    private void overlayBackground(int i, int j, int k, int l) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture(3553, this.mc.renderEngine.getTexture("/gui/background.png"));
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0x404040, l);
        tessellator.addVertexWithUV(0.0, j, 0.0, 0.0, (float)j / f);
        tessellator.addVertexWithUV(this.width, j, 0.0, (float)this.width / f, (float)j / f);
        tessellator.setColorRGBA_I(0x404040, k);
        tessellator.addVertexWithUV(this.width, i, 0.0, (float)this.width / f, (float)i / f);
        tessellator.addVertexWithUV(0.0, i, 0.0, 0.0, (float)i / f);
        tessellator.draw();
    }
}

