/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.GameSettings;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiIngameMenu;
import net.minecraft.src.GuiInterface;
import net.minecraft.src.GuiOptions;
import net.minecraft.src.GuiOptionsButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiSettingsBase;
import net.minecraft.src.GuiVisuals;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.option.Option;

public class GuiVideoSettings
extends GuiSettingsBase {
    private boolean mipmapChanged = false;
    private boolean guiScaleChanged = false;

    public GuiVideoSettings(GuiScreen parent, GameSettings settings) {
        super(parent, settings);
        this.setOptions(this.gameSettings.fancyGraphics, this.gameSettings.renderDistance, this.gameSettings.ambientOcclusion, this.gameSettings.limitFramerate, this.gameSettings.guiScale, this.gameSettings.screenPadding, this.gameSettings.advancedOpenGL, this.gameSettings.chunkLoading, this.gameSettings.gamma, this.gameSettings.worldHoleFix, this.gameSettings.mipmapLevels, this.gameSettings.mipmapSmooth);
        this.languageKey = "options.videoTitle";
    }

    @Override
    public void initGui() {
        super.initGui();
        for (GuiButton button : this.controlList) {
            if (!(button instanceof GuiOptionsButton) || !(this.parentScreen instanceof GuiOptions) || !(((GuiOptions)this.parentScreen).parentScreen instanceof GuiIngameMenu) || ((GuiOptionsButton)button).returnEnumOptions() != this.gameSettings.chunkLoading) continue;
            button.enabled = false;
        }
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.controlList.add(new GuiButton(0, 0, 0, stringtranslate.translateKey("options.visuals")).setListener(e -> {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiVisuals(this, this.gameSettings));
        }));
        this.controlList.add(new GuiButton(0, 0, 0, stringtranslate.translateKey("options.interface")).setListener(e -> {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiInterface(this, this.gameSettings));
        }));
        this.autoAlignButtons();
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.guiScaleChanged) {
            this.guiScaleChanged = false;
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (this.guiScaleChanged) {
            return;
        }
        if (button instanceof GuiOptionsButton) {
            GuiOptionsButton optionsButton = (GuiOptionsButton)button;
            Option<?> option = optionsButton.returnEnumOptions();
            if (option == this.mc.gameSettings.guiScale) {
                this.mc.resolution.update();
                this.guiScaleChanged = true;
            }
            if (option == this.gameSettings.mipmapLevels || option == this.gameSettings.mipmapSmooth) {
                this.mipmapChanged = true;
            }
        }
        super.actionPerformed(button);
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        if (this.mipmapChanged) {
            this.mc.renderEngine.refreshTextures();
            this.mc.renderGlobal.loadRenderers();
        }
    }
}

