/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemArmor;
import net.minecraft.src.ItemBed;
import net.minecraft.src.ItemBoat;
import net.minecraft.src.ItemBow;
import net.minecraft.src.ItemBucket;
import net.minecraft.src.ItemBucketEmpty;
import net.minecraft.src.ItemBucketIceCream;
import net.minecraft.src.ItemCoal;
import net.minecraft.src.ItemDoor;
import net.minecraft.src.ItemDye;
import net.minecraft.src.ItemEgg;
import net.minecraft.src.ItemFishingRod;
import net.minecraft.src.ItemFlintAndSteel;
import net.minecraft.src.ItemFood;
import net.minecraft.src.ItemFoodStackable;
import net.minecraft.src.ItemHandCannonLoaded;
import net.minecraft.src.ItemHandCannonUnloaded;
import net.minecraft.src.ItemLabel;
import net.minecraft.src.ItemMap;
import net.minecraft.src.ItemMinecart;
import net.minecraft.src.ItemPainting;
import net.minecraft.src.ItemPebble;
import net.minecraft.src.ItemQuiver;
import net.minecraft.src.ItemQuiverEndless;
import net.minecraft.src.ItemRecord;
import net.minecraft.src.ItemRedstoneDust;
import net.minecraft.src.ItemSaddle;
import net.minecraft.src.ItemSeeds;
import net.minecraft.src.ItemShears;
import net.minecraft.src.ItemSign;
import net.minecraft.src.ItemSnowball;
import net.minecraft.src.ItemSoup;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ItemSugarcane;
import net.minecraft.src.ItemToolAxe;
import net.minecraft.src.ItemToolHoe;
import net.minecraft.src.ItemToolPickaxe;
import net.minecraft.src.ItemToolShovel;
import net.minecraft.src.ItemToolSword;
import net.minecraft.src.Material;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.StatList;
import net.minecraft.src.StatStringTranslate;
import net.minecraft.src.World;
import net.minecraft.src.material.ArmorMaterial;
import net.minecraft.src.material.ToolMaterial;

public class Item {
    protected static Random itemRand = new Random();
    public static final Map<String, Integer> nameToIdMap = new HashMap<String, Integer>();
    public static Item[] itemsList = new Item[32768];
    public static Item toolShovelIron = new ItemToolShovel(0, ToolMaterial.iron).setIconCoord(2, 5).setItemName("tool.shovel.iron");
    public static Item toolPickaxeIron = new ItemToolPickaxe(1, ToolMaterial.iron).setIconCoord(2, 6).setItemName("tool.pickaxe.iron");
    public static Item toolAxeIron = new ItemToolAxe(2, ToolMaterial.iron).setIconCoord(2, 7).setItemName("tool.axe.iron");
    public static Item toolFirestriker = new ItemFlintAndSteel(3).setIconCoord(5, 0).setItemName("tool.firestriker");
    public static Item foodApple = new ItemFood(4, 4, false).setIconCoord(10, 0).setItemName("food.apple");
    public static Item toolBow = new ItemBow(5).setIconCoord(5, 1).setItemName("tool.bow");
    public static Item ammoArrow = new Item(6).setIconCoord(5, 2).setItemName("ammo.arrow");
    public static Item coal = new ItemCoal(7).setIconCoord(7, 0).setItemName("coal");
    public static Item diamond = new Item(8).setIconCoord(7, 3).setItemName("diamond");
    public static Item ingotIron = new Item(9).setIconCoord(7, 1).setItemName("ingot.iron");
    public static Item ingotGold = new Item(10).setIconCoord(7, 2).setItemName("ingot.gold");
    public static Item toolSwordIron = new ItemToolSword(11, ToolMaterial.iron).setIconCoord(2, 4).setItemName("tool.sword.iron");
    public static Item toolSwordWood = new ItemToolSword(12, ToolMaterial.wood).setIconCoord(0, 4).setItemName("tool.sword.wood");
    public static Item toolShovelWood = new ItemToolShovel(13, ToolMaterial.wood).setIconCoord(0, 5).setItemName("tool.shovel.wood");
    public static Item toolPickaxeWood = new ItemToolPickaxe(14, ToolMaterial.wood).setIconCoord(0, 6).setItemName("tool.pickaxe.wood");
    public static Item toolAxeWood = new ItemToolAxe(15, ToolMaterial.wood).setIconCoord(0, 7).setItemName("tool.axe.wood");
    public static Item toolSwordStone = new ItemToolSword(16, ToolMaterial.stone).setIconCoord(1, 4).setItemName("tool.sword.stone");
    public static Item toolShovelStone = new ItemToolShovel(17, ToolMaterial.stone).setIconCoord(1, 5).setItemName("tool.shovel.stone");
    public static Item toolPickaxeStone = new ItemToolPickaxe(18, ToolMaterial.stone).setIconCoord(1, 6).setItemName("tool.pickaxe.stone");
    public static Item toolAxeStone = new ItemToolAxe(19, ToolMaterial.stone).setIconCoord(1, 7).setItemName("tool.axe.stone");
    public static Item toolSwordDiamond = new ItemToolSword(20, ToolMaterial.diamond).setIconCoord(3, 4).setItemName("tool.sword.diamond");
    public static Item toolShovelDiamond = new ItemToolShovel(21, ToolMaterial.diamond).setIconCoord(3, 5).setItemName("tool.shovel.diamond");
    public static Item toolPickaxeDiamond = new ItemToolPickaxe(22, ToolMaterial.diamond).setIconCoord(3, 6).setItemName("tool.pickaxe.diamond");
    public static Item toolAxeDiamond = new ItemToolAxe(23, ToolMaterial.diamond).setIconCoord(3, 7).setItemName("tool.axe.diamond");
    public static Item stick = new Item(24).setIconCoord(5, 3).setFull3D().setItemName("stick");
    public static Item bowl = new Item(25).setIconCoord(7, 4).setItemName("bowl");
    public static Item foodStewMushroom = new ItemSoup(26, 10).setIconCoord(8, 4).setItemName("food.stew.mushroom");
    public static Item toolSwordGold = new ItemToolSword(27, ToolMaterial.gold).setIconCoord(4, 4).setItemName("tool.sword.gold");
    public static Item toolShovelGold = new ItemToolShovel(28, ToolMaterial.gold).setIconCoord(4, 5).setItemName("tool.shovel.gold");
    public static Item toolPickaxeGold = new ItemToolPickaxe(29, ToolMaterial.gold).setIconCoord(4, 6).setItemName("tool.pickaxe.gold");
    public static Item toolAxeGold = new ItemToolAxe(30, ToolMaterial.gold).setIconCoord(4, 7).setItemName("tool.axe.gold");
    public static Item string = new Item(31).setIconCoord(8, 0).setItemName("string");
    public static Item featherChicken = new Item(32).setIconCoord(8, 1).setItemName("feather.chicken");
    public static Item sulphur = new Item(33).setIconCoord(8, 2).setItemName("sulphur");
    public static Item toolHoeWood = new ItemToolHoe(34, ToolMaterial.wood).setIconCoord(0, 8).setItemName("tool.hoe.wood");
    public static Item toolHoeStone = new ItemToolHoe(35, ToolMaterial.stone).setIconCoord(1, 8).setItemName("tool.hoe.stone");
    public static Item toolHoeIron = new ItemToolHoe(36, ToolMaterial.iron).setIconCoord(2, 8).setItemName("tool.hoe.iron");
    public static Item toolHoeDiamond = new ItemToolHoe(37, ToolMaterial.diamond).setIconCoord(3, 8).setItemName("tool.hoe.diamond");
    public static Item toolHoeGold = new ItemToolHoe(38, ToolMaterial.gold).setIconCoord(4, 8).setItemName("tool.hoe.gold");
    public static Item seedsWheat = new ItemSeeds(39, Block.cropsWheat.blockID).setIconCoord(9, 0).setItemName("seeds.wheat");
    public static Item wheat = new Item(40).setIconCoord(9, 1).setItemName("wheat");
    public static Item foodBread = new ItemFood(41, 5, false).setIconCoord(9, 2).setItemName("food.bread");
    public static Item armorHelmetLeather = new ItemArmor(42, ArmorMaterial.leather, 0).setIconCoord(0, 0).setItemName("armor.helmet.leather");
    public static Item armorChestplateLeather = new ItemArmor(43, ArmorMaterial.leather, 1).setIconCoord(0, 1).setItemName("armor.chestplate.leather");
    public static Item armorLeggingsLeather = new ItemArmor(44, ArmorMaterial.leather, 2).setIconCoord(0, 2).setItemName("armor.leggings.leather");
    public static Item armorBootsLeather = new ItemArmor(45, ArmorMaterial.leather, 3).setIconCoord(0, 3).setItemName("armor.boots.leather");
    public static Item armorHelmetChainmail = new ItemArmor(46, ArmorMaterial.chainmail, 0).setIconCoord(1, 0).setItemName("armor.helmet.chainmail");
    public static Item armorChestplateChainmail = new ItemArmor(47, ArmorMaterial.chainmail, 1).setIconCoord(1, 1).setItemName("armor.chestplate.chainmail");
    public static Item armorLeggingsChainmail = new ItemArmor(48, ArmorMaterial.chainmail, 2).setIconCoord(1, 2).setItemName("armor.leggings.chainmail");
    public static Item armorBootsChainmail = new ItemArmor(49, ArmorMaterial.chainmail, 3).setIconCoord(1, 3).setItemName("armor.boots.chainmail");
    public static Item armorHelmetIron = new ItemArmor(50, ArmorMaterial.iron, 0).setIconCoord(2, 0).setItemName("armor.helmet.iron");
    public static Item armorChestplateIron = new ItemArmor(51, ArmorMaterial.iron, 1).setIconCoord(2, 1).setItemName("armor.chestplate.iron");
    public static Item armorLeggingsIron = new ItemArmor(52, ArmorMaterial.iron, 2).setIconCoord(2, 2).setItemName("armor.leggings.iron");
    public static Item armorBootsIron = new ItemArmor(53, ArmorMaterial.iron, 3).setIconCoord(2, 3).setItemName("armor.boots.iron");
    public static Item armorHelmetDiamond = new ItemArmor(54, ArmorMaterial.diamond, 0).setIconCoord(3, 0).setItemName("armor.helmet.diamond");
    public static Item armorChestplateDiamond = new ItemArmor(55, ArmorMaterial.diamond, 1).setIconCoord(3, 1).setItemName("armor.chestplate.diamond");
    public static Item armorLeggingsDiamond = new ItemArmor(56, ArmorMaterial.diamond, 2).setIconCoord(3, 2).setItemName("armor.leggings.diamond");
    public static Item armorBootsDiamond = new ItemArmor(57, ArmorMaterial.diamond, 3).setIconCoord(3, 3).setItemName("armor.boots.diamond");
    public static Item armorHelmetGold = new ItemArmor(58, ArmorMaterial.gold, 0).setIconCoord(4, 0).setItemName("armor.helmet.gold");
    public static Item armorChestplateGold = new ItemArmor(59, ArmorMaterial.gold, 1).setIconCoord(4, 1).setItemName("armor.chestplate.gold");
    public static Item armorLeggingsGold = new ItemArmor(60, ArmorMaterial.gold, 2).setIconCoord(4, 2).setItemName("armor.leggings.gold");
    public static Item armorBootsGold = new ItemArmor(61, ArmorMaterial.gold, 3).setIconCoord(4, 3).setItemName("armor.boots.gold");
    public static Item flint = new Item(62).setIconCoord(6, 0).setItemName("flint");
    public static Item foodPorkchopRaw = new ItemFood(63, 3, true).setIconCoord(7, 5).setItemName("food.porkchop.raw");
    public static Item foodPorkchopCooked = new ItemFood(64, 8, true).setIconCoord(8, 5).setItemName("food.porkchop.cooked");
    public static Item painting = new ItemPainting(65).setIconCoord(10, 1).setItemName("painting");
    public static Item foodAppleGold = new ItemFood(66, 42, false).setIconCoord(11, 0).setItemName("food.apple.gold");
    public static Item sign = new ItemSign(67).setIconCoord(10, 2).setItemName("sign");
    public static Item doorOak = new ItemDoor(68, Material.wood).setIconCoord(11, 2).setItemName("door.oak");
    public static Item bucket = new ItemBucketEmpty(69, 0).setIconCoord(10, 4).setItemName("bucket");
    public static Item bucketWater = new ItemBucket(70, Block.fluidWaterFlowing.blockID).setIconCoord(11, 4).setItemName("bucket.water").setContainerItem(bucket);
    public static Item bucketLava = new ItemBucket(71, Block.fluidLavaFlowing.blockID).setIconCoord(12, 4).setItemName("bucket.lava").setContainerItem(bucket);
    public static Item minecart = new ItemMinecart(72, 0).setIconCoord(7, 8).setItemName("minecart");
    public static Item saddle = new ItemSaddle(73).setIconCoord(8, 6).setItemName("saddle");
    public static Item doorIron = new ItemDoor(74, Material.iron).setIconCoord(12, 2).setItemName("door.iron");
    public static Item dustRedstone = new ItemRedstoneDust(75).setIconCoord(8, 3).setItemName("dust.redstone");
    public static Item ammoSnowball = new ItemSnowball(76).setIconCoord(14, 0).setItemName("ammo.snowball");
    public static Item boat = new ItemBoat(77).setIconCoord(8, 8).setItemName("boat");
    public static Item leather = new Item(78).setIconCoord(7, 6).setItemName("leather");
    public static Item bucketMilk = new ItemBucket(79, -1).setIconCoord(13, 4).setItemName("bucket.milk").setContainerItem(bucket);
    public static Item brickClay = new Item(80).setIconCoord(6, 1).setItemName("brick.clay");
    public static Item clay = new Item(81).setIconCoord(9, 3).setItemName("clay");
    public static Item sugarcane = new ItemSugarcane(82, Block.sugarcane).setIconCoord(11, 1).setItemName("sugarcane");
    public static Item paper = new Item(83).setIconCoord(10, 3).setItemName("paper");
    public static Item book = new Item(84).setIconCoord(11, 3).setItemName("book");
    public static Item slimeball = new Item(85).setIconCoord(14, 1).setItemName("slimeball");
    public static Item minecartChest = new ItemMinecart(86, 1).setIconCoord(7, 9).setItemName("minecart.chest");
    public static Item minecartFurnace = new ItemMinecart(87, 2).setIconCoord(7, 10).setItemName("minecart.furnace");
    public static Item eggChicken = new ItemEgg(88).setIconCoord(12, 0).setItemName("egg.chicken");
    public static Item toolCompass = new Item(89).setIconCoord(6, 3).setItemName("tool.compass");
    public static Item toolFishingrod = new ItemFishingRod(90).setIconCoord(5, 4).setItemName("tool.fishingrod");
    public static Item toolClock = new Item(91).setIconCoord(6, 4).setItemName("tool.clock");
    public static Item dustGlowstone = new Item(92).setIconCoord(9, 4).setItemName("dust.glowstone");
    public static Item foodFishRaw = new ItemFoodStackable(93, 2, false, 4).setIconCoord(9, 5).setItemName("food.fish.raw");
    public static Item foodFishCooked = new ItemFoodStackable(94, 5, false, 4).setIconCoord(10, 5).setItemName("food.fish.cooked");
    public static Item dye = new ItemDye(95).setIconCoord(14, 4).setItemName("dye");
    public static Item bone = new Item(96).setIconCoord(12, 1).setItemName("bone").setFull3D();
    public static Item dustSugar = new Item(97).setIconCoord(13, 0).setItemName("dust.sugar").setFull3D();
    public static Item foodCake = new ItemSugarcane(98, Block.cake).setMaxStackSize(1).setIconCoord(13, 1).setItemName("food.cake");
    public static Item bed = new ItemBed(99).setMaxStackSize(1).setIconCoord(13, 2).setItemName("bed");
    public static Item repeater = new ItemSugarcane(100, Block.repeaterIdle).setIconCoord(6, 5).setItemName("repeater");
    public static Item foodCookie = new ItemFoodStackable(101, 1, false, 8).setIconCoord(12, 5).setItemName("food.cookie");
    public static ItemMap map = (ItemMap)new ItemMap(102).setIconCoord(12, 3).setItemName("map");
    public static ItemShears toolShears = (ItemShears)new ItemShears(103).setIconCoord(13, 5).setItemName("tool.shears");
    public static Item record13 = new ItemRecord(2000, "13").setIconCoord(0, 15).setItemName("record.13");
    public static Item recordCat = new ItemRecord(2001, "cat").setIconCoord(1, 15).setItemName("record.cat");
    public static Item recordBlocks = new ItemRecord(2002, "blocks").setIconCoord(2, 15).setItemName("record.blocks");
    public static Item recordChirp = new ItemRecord(2003, "chirp").setIconCoord(3, 15).setItemName("record.chirp");
    public static Item recordFar = new ItemRecord(2004, "far").setIconCoord(4, 15).setItemName("record.far");
    public static Item recordMall = new ItemRecord(2005, "mall").setIconCoord(5, 15).setItemName("record.mall");
    public static Item recordMellohi = new ItemRecord(2006, "mellohi").setIconCoord(6, 15).setItemName("record.mellohi");
    public static Item recordStal = new ItemRecord(2007, "stal").setIconCoord(7, 15).setItemName("record.stal");
    public static Item recordStrad = new ItemRecord(2008, "strad").setIconCoord(8, 15).setItemName("record.strad");
    public static Item recordWard = new ItemRecord(2009, "ward").setIconCoord(9, 15).setItemName("record.ward");
    public static Item recordWait = new ItemRecord(2010, "wait").setIconCoord(12, 15).setItemName("record.wait");
    public static Item recordCalm4 = new ItemRecord(2011, "calm4").setIconCoord(10, 15).setItemName("record.calm4");
    public static Item nethercoal = new Item(104).setIconCoord(5, 6).setItemName("nethercoal");
    public static Item armorHelmetSteel = new ItemArmor(105, ArmorMaterial.steel, 0).setIconCoord(1, 9).setItemName("armor.helmet.steel");
    public static Item armorChestplateSteel = new ItemArmor(106, ArmorMaterial.steel, 1).setIconCoord(1, 10).setItemName("armor.chestplate.steel");
    public static Item armorLeggingsSteel = new ItemArmor(107, ArmorMaterial.steel, 2).setIconCoord(1, 11).setItemName("armor.leggings.steel");
    public static Item armorBootsSteel = new ItemArmor(108, ArmorMaterial.steel, 3).setIconCoord(1, 12).setItemName("armor.boots.steel");
    public static Item toolSwordSteel = new ItemToolSword(109, ToolMaterial.steel).setIconCoord(0, 9).setItemName("tool.sword.steel");
    public static Item toolShovelSteel = new ItemToolShovel(110, ToolMaterial.steel).setIconCoord(0, 10).setItemName("tool.shovel.steel");
    public static Item toolPickaxeSteel = new ItemToolPickaxe(111, ToolMaterial.steel).setIconCoord(0, 11).setItemName("tool.pickaxe.steel");
    public static Item toolAxeSteel = new ItemToolAxe(112, ToolMaterial.steel).setIconCoord(0, 12).setItemName("tool.axe.steel");
    public static Item toolHoeSteel = new ItemToolHoe(113, ToolMaterial.steel).setIconCoord(0, 13).setItemName("tool.hoe.steel");
    public static Item ingotSteel = new Item(114).setIconCoord(7, 7).setItemName("ingot.steel");
    public static Item ingotSteelCrude = new Item(115).setIconCoord(8, 7).setItemName("ingot.steel.crude");
    public static Item ammoFireball = new Item(116).setIconCoord(14, 2).setItemName("ammo.fireball").setNotInCreativeMenu();
    public static Item armorQuiverGold = new ItemQuiverEndless(117).setIconCoord(4, 9).setItemName("armor.quiver.gold");
    public static Item handcannonUnloaded = new ItemHandCannonUnloaded(118).setIconCoord(5, 8).setItemName("handcannon.unloaded");
    public static Item chainlink = new Item(119).setIconCoord(9, 7).setItemName("chainlink");
    public static Item cloth = new Item(120).setIconCoord(9, 6).setItemName("cloth");
    public static Item ammoChargeExplosive = new Item(121).setIconCoord(6, 8).setItemName("ammo.charge.explosive").setMaxStackSize(16);
    public static Item handcannonLoaded = new ItemHandCannonLoaded(122).setIconCoord(5, 9).setItemName("handcannon.loaded").setNotInCreativeMenu();
    public static Item ammoArrowGold = new Item(123).setIconCoord(5, 7).setItemName("ammo.arrow.gold");
    public static Item armorQuiver = new ItemQuiver(124).setIconCoord(6, 2).setItemName("armor.quiver");
    public static Item toolCalendar = new Item(125).setIconCoord(6, 7).setItemName("tool.calendar");
    public static Item nuggetGold = new Item(126).setIconCoord(10, 8).setItemName("nugget.gold");
    public static Item nuggetIron = new Item(127).setIconCoord(9, 8).setItemName("nugget.iron");
    public static Item quartz = new Item(128).setIconCoord(11, 5).setItemName("quartz");
    public static Item olivine = new Item(129).setIconCoord(11, 6).setItemName("olivine");
    public static Item ammoPebble = new ItemPebble(130).setIconCoord(10, 6).setItemName("ammo.pebble");
    public static Item cherry = new ItemFoodStackable(131, 2, false, 2).setIconCoord(10, 7).setItemName("food.cherry");
    public static Item bucketIcecream = new ItemBucketIceCream(132, 10).setIconCoord(12, 6).setItemName("bucket.icecream").setContainerItem(bucket);
    public static Item ammoArrowPurple = new Item(133).setIconCoord(4, 10).setItemName("ammo.arrow.purple").setNotInCreativeMenu();
    public static Item label = new ItemLabel(134).setIconCoord(8, 9).setItemName("label");
    public final int itemID;
    protected int maxStackSize = 64;
    private int maxDamage = 0;
    protected int iconIndex;
    protected boolean bFull3D = false;
    protected boolean hasSubtypes = false;
    private Item containerItem = null;
    private String itemName;
    public boolean notInCreativeMenu;

    public Item(int i) {
        this.itemID = Block.blocksList.length + i;
        if (itemsList[Block.blocksList.length + i] != null) {
            System.out.println("CONFLICT @ " + i);
        }
        Item.itemsList[Block.blocksList.length + i] = this;
    }

    public Item setIconIndex(int i) {
        this.iconIndex = i;
        return this;
    }

    public Item setMaxStackSize(int i) {
        this.maxStackSize = i;
        return this;
    }

    public static int iconCoordToIndex(int x, int y) {
        return x + y * Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
    }

    public Item setIconCoord(int i, int j) {
        this.iconIndex = Item.iconCoordToIndex(i, j);
        return this;
    }

    public int getIconFromDamage(int i) {
        return this.iconIndex;
    }

    public int getIconIndex(ItemStack itemstack) {
        return this.getIconFromDamage(itemstack.getMetadata());
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, double heightPlaced) {
        return false;
    }

    public float getStrVsBlock(ItemStack itemstack, Block block) {
        return 1.0f;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        return itemstack;
    }

    public int getItemStackLimit() {
        return this.maxStackSize;
    }

    public int getPlacedBlockMetadata(int i) {
        return 0;
    }

    public boolean getHasSubtypes() {
        return this.hasSubtypes;
    }

    protected Item setHasSubtypes(boolean flag) {
        this.hasSubtypes = flag;
        return this;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    protected Item setMaxDamage(int i) {
        this.maxDamage = i;
        return this;
    }

    public boolean isDamagable() {
        return this.maxDamage > 0 && !this.hasSubtypes;
    }

    public boolean hitEntity(ItemStack itemstack, EntityLiving entityliving, EntityLiving entityliving1) {
        return false;
    }

    public boolean onBlockDestroyed(ItemStack itemstack, int id, int x, int y, int z, EntityLiving entityliving) {
        return false;
    }

    public int getDamageVsEntity(Entity entity) {
        return 1;
    }

    public boolean canHarvestBlock(Block block) {
        return false;
    }

    public boolean useItemOnEntity(ItemStack itemstack, EntityLiving entityliving, EntityPlayer entityPlayer) {
        return false;
    }

    public Item setFull3D() {
        this.bFull3D = true;
        return this;
    }

    public boolean isFull3D() {
        return this.bFull3D;
    }

    public boolean shouldRotateAroundWhenRendering() {
        return false;
    }

    public boolean shouldPointInFrontOfPlayer() {
        return false;
    }

    public Item setItemName(String s) {
        this.itemName = "item." + s;
        nameToIdMap.put(this.itemName, this.itemID);
        return this;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getItemNameIS(ItemStack itemstack) {
        return this.itemName;
    }

    public byte getItemNameColor(ItemStack itemstack) {
        return itemstack.tag.getByte("color");
    }

    public final String getItemNickname(ItemStack itemstack) {
        return itemstack.tag.getString("name");
    }

    public NBTTagCompound getDefaultTag() {
        return new NBTTagCompound();
    }

    public Item setContainerItem(Item item) {
        if (this.maxStackSize > 1) {
            throw new IllegalArgumentException("Max stack size must be 1 for items with crafting results");
        }
        this.containerItem = item;
        return this;
    }

    public Item getContainerItem() {
        return this.containerItem;
    }

    public boolean hasContainerItem() {
        return this.containerItem != null;
    }

    public String getStatName() {
        return StatStringTranslate.translateToLocal(this.getItemName() + ".name");
    }

    public int getColorFromDamage(int i) {
        return 0xFFFFFF;
    }

    public Item setNotInCreativeMenu() {
        this.notInCreativeMenu = true;
        return this;
    }

    public void onUpdate(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
    }

    public void onCreated(ItemStack itemstack, World world, EntityPlayer entityplayer) {
    }

    public boolean func_28019_b() {
        return false;
    }

    public boolean isSilkTouch() {
        return false;
    }

    public int getBlockHitDelay() {
        return 5;
    }

    static {
        StatList.onItemInit();
    }
}

