/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class ItemBlock
extends Item {
    protected int blockID;

    public ItemBlock(int i) {
        super(i);
        this.blockID = i + Block.blocksList.length;
        this.setIconIndex(Block.blocksList[i + Block.blocksList.length].getBlockTextureFromSide(2));
    }

    @Override
    public int getColorFromDamage(int i) {
        Block block = Block.blocksList[this.blockID];
        int colour = block.getRenderColor(i);
        return colour;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int side, double heightPlaced) {
        Direction dir = Direction.UP;
        if (Block.blocksList[world.getBlockId(x, y, z)] != null && Block.blocksList[world.getBlockId((int)x, (int)y, (int)z)].placeOverwrites) {
            side = 1;
        } else {
            if (side == 0) {
                --y;
                dir = Direction.UP;
            }
            if (side == 1) {
                ++y;
                dir = Direction.DOWN;
            }
            if (side == 2) {
                --z;
                dir = Direction.NORTH;
            }
            if (side == 3) {
                ++z;
                dir = Direction.SOUTH;
            }
            if (side == 4) {
                --x;
                dir = Direction.WEST;
            }
            if (side == 5) {
                ++x;
                dir = Direction.EAST;
            }
        }
        if (itemstack.stackSize == 0) {
            return false;
        }
        if (y == Minecraft.WORLD_HEIGHT_BLOCKS - 1 && Block.blocksList[this.blockID].blockMaterial.isSolid()) {
            return false;
        }
        if (world.canBlockBePlacedAt(this.blockID, x, y, z, false, side) && itemstack.consumeItem(entityplayer)) {
            Block block = Block.blocksList[this.blockID];
            if (world.setBlockAndMetadataWithNotify(x, y, z, this.blockID, this.getPlacedBlockMetadata(itemstack.getMetadata()))) {
                Block.blocksList[this.blockID].onBlockPlaced(world, x, y, z, dir, entityplayer, heightPlaced);
                world.playSoundEffect((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, block.stepSound.func_1145_d(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getItemNameIS(ItemStack itemstack) {
        return Block.blocksList[this.blockID].getBlockName(itemstack.getMetadata());
    }

    @Override
    public String getItemName() {
        return Block.blocksList[this.blockID].getBlockName(0);
    }
}

