/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLayerBase;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class ItemBlockLayer
extends ItemBlock {
    public ItemBlockLayer(int i) {
        super(i);
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, double heightPlaced) {
        int id = world.getBlockId(i, j, k);
        int meta = world.getBlockMetadata(i, j, k);
        if (id != this.blockID && Block.blocksList[id] != null && Block.blocksList[id].placeOverwrites) {
            id = 0;
            meta = 0;
        }
        if (itemstack.stackSize == 0) {
            return false;
        }
        if (j == Minecraft.WORLD_HEIGHT_BLOCKS - 1 && Block.blocksList[this.blockID].blockMaterial.isSolid()) {
            return false;
        }
        if (id == this.blockID && l == 1) {
            BlockLayerBase blockLayer = (BlockLayerBase)Block.blocksList[this.blockID];
            int newMeta = meta + 1;
            AxisAlignedBB bbBox = AxisAlignedBB.getBoundingBoxFromPool(i, j, k, (float)i + 1.0f, (float)j + (float)(2 * (newMeta + 1)) / 16.0f, (float)k + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            if (newMeta < 7) {
                world.setBlockAndMetadataWithNotify(i, j, k, this.blockID, newMeta);
            } else if (blockLayer.fullBlockID != -1) {
                world.setBlockAndMetadataWithNotify(i, j, k, blockLayer.fullBlockID, 0);
            } else {
                world.setBlockAndMetadataWithNotify(i, j + 1, k, this.blockID, 0);
            }
            world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, blockLayer.stepSound.func_1145_d(), (blockLayer.stepSound.getVolume() + 1.0f) / 2.0f, blockLayer.stepSound.getPitch() * 0.8f);
            itemstack.consumeItem(entityplayer);
            return true;
        }
        if (id != 0) {
            if (l == 0) {
                --j;
            }
            if (l == 1) {
                ++j;
            }
            if (l == 2) {
                --k;
            }
            if (l == 3) {
                ++k;
            }
            if (l == 4) {
                --i;
            }
            if (l == 5) {
                ++i;
            }
            id = world.getBlockId(i, j, k);
            meta = world.getBlockMetadata(i, j, k);
        }
        if (id == this.blockID) {
            BlockLayerBase blockLayer = (BlockLayerBase)Block.blocksList[this.blockID];
            int newMeta = meta + 1;
            AxisAlignedBB bbBox = AxisAlignedBB.getBoundingBoxFromPool(i, j, k, (float)i + 1.0f, (float)j + (float)(2 * (newMeta + 1)) / 16.0f, (float)k + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            if (newMeta < 7) {
                world.setBlockAndMetadataWithNotify(i, j, k, this.blockID, newMeta);
            } else if (blockLayer.fullBlockID != -1) {
                world.setBlockAndMetadataWithNotify(i, j, k, blockLayer.fullBlockID, 0);
            } else {
                world.setBlockAndMetadataWithNotify(i, j + 1, k, this.blockID, 0);
            }
            world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, blockLayer.stepSound.func_1145_d(), (blockLayer.stepSound.getVolume() + 1.0f) / 2.0f, blockLayer.stepSound.getPitch() * 0.8f);
            itemstack.consumeItem(entityplayer);
            return true;
        }
        if (world.canBlockBePlacedAt(this.blockID, i, j, k, false, l)) {
            Block block = Block.blocksList[this.blockID];
            if (world.setBlockAndMetadataWithNotify(i, j, k, this.blockID, this.getPlacedBlockMetadata(itemstack.getMetadata()))) {
                Block.blocksList[this.blockID].onBlockPlaced(world, i, j, k, null, entityplayer, heightPlaced);
                world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, block.stepSound.func_1145_d(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                itemstack.consumeItem(entityplayer);
            }
            return true;
        }
        return false;
    }
}

