/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Packet53BlockChange;
import net.minecraft.src.World;
import net.minecraft.src.WorldServer;

public class ItemInWorldManager {
    private WorldServer thisWorld;
    public EntityPlayer thisPlayer;
    private float field_672_d = 0.0f;
    private int field_22055_d;
    private int field_22054_g;
    private int field_22053_h;
    private int field_22052_i;
    private int field_22051_j;
    private boolean field_22050_k;
    private int field_22049_l;
    private int field_22048_m;
    private int field_22047_n;
    private int field_22046_o;

    public ItemInWorldManager(WorldServer worldserver) {
        this.thisWorld = worldserver;
    }

    public void func_328_a() {
        ++this.field_22051_j;
        if (this.field_22050_k) {
            int i = this.field_22051_j - this.field_22046_o;
            int j = this.thisWorld.getBlockId(this.field_22049_l, this.field_22048_m, this.field_22047_n);
            if (j != 0) {
                Block block = Block.blocksList[j];
                float f = block.blockStrength(this.thisPlayer) * (float)(i + 1);
                if (f >= 1.0f) {
                    this.field_22050_k = false;
                    this.func_325_c(this.field_22049_l, this.field_22048_m, this.field_22047_n);
                }
            } else {
                this.field_22050_k = false;
            }
        }
    }

    public void func_324_a(int i, int j, int k, int l) {
        this.thisWorld.onBlockHit(null, i, j, k, l);
        if (!this.thisPlayer.getGamemode().doBlockBreakingAnim) {
            this.func_325_c(i, j, k);
            return;
        }
        this.field_22055_d = this.field_22051_j;
        int i1 = this.thisWorld.getBlockId(i, j, k);
        if (i1 > 0) {
            Block.blocksList[i1].onBlockClicked(this.thisWorld, i, j, k, this.thisPlayer);
        }
        if (i1 > 0 && Block.blocksList[i1].blockStrength(this.thisPlayer) >= 1.0f) {
            this.func_325_c(i, j, k);
        } else {
            this.field_22054_g = i;
            this.field_22053_h = j;
            this.field_22052_i = k;
        }
    }

    public void func_22045_b(int i, int j, int k) {
        if (i == this.field_22054_g && j == this.field_22053_h && k == this.field_22052_i) {
            int l = this.field_22051_j - this.field_22055_d;
            int i1 = this.thisWorld.getBlockId(i, j, k);
            if (i1 != 0) {
                Block block = Block.blocksList[i1];
                float f = block.blockStrength(this.thisPlayer) * (float)(l + 1);
                if (f >= 0.7f) {
                    this.func_325_c(i, j, k);
                } else if (!this.field_22050_k) {
                    this.field_22050_k = true;
                    this.field_22049_l = i;
                    this.field_22048_m = j;
                    this.field_22047_n = k;
                    this.field_22046_o = this.field_22055_d;
                }
            }
        }
        this.field_672_d = 0.0f;
    }

    public boolean removeBlock(int i, int j, int k) {
        Block block = Block.blocksList[this.thisWorld.getBlockId(i, j, k)];
        int l = this.thisWorld.getBlockMetadata(i, j, k);
        boolean flag = this.thisWorld.setBlockWithNotify(i, j, k, 0);
        if (block != null && flag) {
            block.onBlockDestroyedByPlayer(this.thisWorld, i, j, k, l);
        }
        return flag;
    }

    public boolean func_325_c(int x, int y, int z) {
        ItemStack itemstack;
        int id = this.thisWorld.getBlockId(x, y, z);
        int meta = this.thisWorld.getBlockMetadata(x, y, z);
        this.thisWorld.playSoundEffectForPlayer(this.thisPlayer, 2001, x, y, z, id);
        boolean flag = this.removeBlock(x, y, z);
        if (flag && this.thisPlayer.canHarvestBlock(Block.blocksList[id]) && this.thisPlayer.getGamemode().dropBlockOnBreak) {
            Block.blocksList[id].harvestBlock(this.thisWorld, this.thisPlayer, x, y, z, meta);
            ((EntityPlayerMP)this.thisPlayer).playerNetServerHandler.sendPacket(new Packet53BlockChange(x, y, z, this.thisWorld));
        }
        if ((itemstack = this.thisPlayer.getCurrentEquippedItem()) != null) {
            itemstack.onDestroyBlock(id, x, y, z, this.thisPlayer);
            if (itemstack.stackSize == 0) {
                itemstack.func_1097_a(this.thisPlayer);
                this.thisPlayer.destroyCurrentEquippedItem();
            }
        }
        return flag;
    }

    public boolean func_6154_a(EntityPlayer entityplayer, World world, ItemStack itemstack) {
        int i = itemstack.stackSize;
        ItemStack itemstack1 = itemstack.useItemRightClick(world, entityplayer);
        if (itemstack1 != itemstack || itemstack1 != null && itemstack1.stackSize != i) {
            entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = itemstack1;
            if (itemstack1.stackSize == 0) {
                entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = null;
            }
            return true;
        }
        return false;
    }

    public boolean activeBlockOrUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack, int i, int j, int k, int l, double heightPlaced) {
        int i1 = world.getBlockId(i, j, k);
        if ((entityplayer.isSneaking() && entityplayer.getCurrentEquippedItem() == null || !entityplayer.isSneaking()) && i1 > 0 && Block.blocksList[i1].blockActivated(world, i, j, k, entityplayer)) {
            return true;
        }
        if (itemstack == null) {
            return false;
        }
        return itemstack.useItem(entityplayer, world, i, j, k, l, heightPlaced);
    }
}

