/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.Item;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MapData;
import net.minecraft.src.MapItemRenderer;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PlayerSkinParser;
import net.minecraft.src.Render;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderManager;
import net.minecraft.src.RenderPlayer;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TextureFX;
import org.lwjgl.opengl.GL11;

public class ItemRenderer {
    private Minecraft mc;
    private ItemStack itemToRender = null;
    private float equippedProgress = 0.0f;
    private float prevEquippedProgress = 0.0f;
    private RenderBlocks renderBlocksInstance = new RenderBlocks();
    private MapItemRenderer field_28131_f;
    private int field_20099_f = -1;

    public ItemRenderer(Minecraft minecraft) {
        this.mc = minecraft;
        this.field_28131_f = new MapItemRenderer(minecraft.fontRenderer, minecraft.gameSettings, minecraft.renderEngine);
    }

    public void renderItem(EntityLiving entityLiving, ItemStack itemStack) {
        this.renderItem(entityLiving, itemStack, true);
    }

    public void renderItem(Entity entity, ItemStack itemstack, boolean handheldTransform) {
        GL11.glPushMatrix();
        if (itemstack.itemID < Block.blocksList.length && RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType())) {
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glBindTexture(3553, this.mc.renderEngine.getTexture("/terrain.png"));
            float brightness = entity.getEntityBrightness(1.0f);
            if (this.mc.fullbright) {
                brightness = 1.0f;
            }
            this.renderBlocksInstance.renderBlockOnInventory(Block.blocksList[itemstack.itemID], itemstack.getMetadata(), brightness);
            GL11.glDisable(3042);
        } else {
            int tileWidth;
            if (itemstack.itemID < Block.blocksList.length) {
                GL11.glBindTexture(3553, this.mc.renderEngine.getTexture("/terrain.png"));
                tileWidth = TextureFX.tileWidthTerrain;
            } else {
                GL11.glBindTexture(3553, this.mc.renderEngine.getTexture("/gui/items.png"));
                tileWidth = TextureFX.tileWidthItems;
            }
            Tessellator tessellator = Tessellator.instance;
            int i = itemstack.getItem().getIconIndex(itemstack);
            if (entity instanceof EntityLiving) {
                i = ((EntityLiving)entity).getItemIcon(itemstack);
            }
            float f = ((float)(i % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + 0.0f) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f1 = ((float)(i % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + ((float)tileWidth - 0.01f)) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f2 = ((float)(i / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + 0.0f) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f3 = ((float)(i / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + ((float)tileWidth - 0.01f)) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f4 = 1.0f;
            float f5 = 0.0f;
            float f6 = 0.3f;
            float foon = 0.5f / (float)tileWidth / (float)net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
            float goon = 0.0625f * (16.0f / (float)tileWidth);
            GL11.glEnable(32826);
            if (handheldTransform) {
                GL11.glTranslatef(-f5, -f6, 0.0f);
                float f7 = 1.5f;
                GL11.glScalef(f7, f7, f7);
                GL11.glRotatef(50.0f, 0.0f, 1.0f, 0.0f);
                GL11.glRotatef(335.0f, 0.0f, 0.0f, 1.0f);
                GL11.glTranslatef(-0.9375f, -0.0625f, 0.0f);
            }
            float thickness = 0.0625f;
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, f1, f3);
            tessellator.addVertexWithUV(f4, 0.0, 0.0, f, f3);
            tessellator.addVertexWithUV(f4, 1.0, 0.0, f, f2);
            tessellator.addVertexWithUV(0.0, 1.0, 0.0, f1, f2);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            tessellator.addVertexWithUV(0.0, 1.0, 0.0f - thickness, f1, f2);
            tessellator.addVertexWithUV(f4, 1.0, 0.0f - thickness, f, f2);
            tessellator.addVertexWithUV(f4, 0.0, 0.0f - thickness, f, f3);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0f - thickness, f1, f3);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            for (int j = 0; j < tileWidth; ++j) {
                float f9 = (float)j / (float)tileWidth;
                float f13 = f1 + (f - f1) * f9 - foon;
                float f17 = f4 * f9;
                tessellator.addVertexWithUV(f17, 0.0, 0.0f - thickness, f13, f3);
                tessellator.addVertexWithUV(f17, 0.0, 0.0, f13, f3);
                tessellator.addVertexWithUV(f17, 1.0, 0.0, f13, f2);
                tessellator.addVertexWithUV(f17, 1.0, 0.0f - thickness, f13, f2);
            }
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            for (int k = 0; k < tileWidth; ++k) {
                float f10 = (float)k / (float)tileWidth;
                float f14 = f1 + (f - f1) * f10 - foon;
                float f18 = f4 * f10 + goon;
                tessellator.addVertexWithUV(f18, 1.0, 0.0f - thickness, f14, f2);
                tessellator.addVertexWithUV(f18, 1.0, 0.0, f14, f2);
                tessellator.addVertexWithUV(f18, 0.0, 0.0, f14, f3);
                tessellator.addVertexWithUV(f18, 0.0, 0.0f - thickness, f14, f3);
            }
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            for (int l = 0; l < tileWidth; ++l) {
                float f11 = (float)l / (float)tileWidth;
                float f15 = f3 + (f2 - f3) * f11 - foon;
                float f19 = f4 * f11 + goon;
                tessellator.addVertexWithUV(0.0, f19, 0.0, f1, f15);
                tessellator.addVertexWithUV(f4, f19, 0.0, f, f15);
                tessellator.addVertexWithUV(f4, f19, 0.0f - thickness, f, f15);
                tessellator.addVertexWithUV(0.0, f19, 0.0f - thickness, f1, f15);
            }
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            for (int i1 = 0; i1 < tileWidth; ++i1) {
                float f12 = (float)i1 / (float)tileWidth;
                float f16 = f3 + (f2 - f3) * f12 - foon;
                float f20 = f4 * f12;
                tessellator.addVertexWithUV(f4, f20, 0.0, f, f16);
                tessellator.addVertexWithUV(0.0, f20, 0.0, f1, f16);
                tessellator.addVertexWithUV(0.0, f20, 0.0f - thickness, f1, f16);
                tessellator.addVertexWithUV(f4, f20, 0.0f - thickness, f, f16);
            }
            tessellator.draw();
            GL11.glDisable(32826);
        }
        GL11.glPopMatrix();
    }

    public void renderItemInFirstPerson(float f) {
        float f1 = this.prevEquippedProgress + (this.equippedProgress - this.prevEquippedProgress) * f;
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        float f2 = entityplayersp.prevRotationPitch + (entityplayersp.rotationPitch - entityplayersp.prevRotationPitch) * f;
        GL11.glPushMatrix();
        GL11.glRotatef(f2, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(entityplayersp.prevRotationYaw + (entityplayersp.rotationYaw - entityplayersp.prevRotationYaw) * f, 0.0f, 1.0f, 0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glPopMatrix();
        ItemStack itemstack = this.itemToRender;
        float f3 = this.mc.theWorld.getLightBrightness(MathHelper.floor_double(entityplayersp.posX), MathHelper.floor_double(entityplayersp.posY), MathHelper.floor_double(entityplayersp.posZ));
        if (this.mc.fullbright) {
            f3 = 1.0f;
        }
        if (itemstack != null) {
            int i = Item.itemsList[itemstack.itemID].getColorFromDamage(itemstack.getMetadata());
            float f7 = (float)(i >> 16 & 0xFF) / 255.0f;
            float f11 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f15 = (float)(i & 0xFF) / 255.0f;
            GL11.glColor4f(f3 * f7, f3 * f11, f3 * f15, 1.0f);
        } else {
            GL11.glColor4f(f3, f3, f3, 1.0f);
        }
        if (itemstack != null && itemstack.itemID == Item.map.itemID) {
            GL11.glPushMatrix();
            float f4 = 0.8f;
            float f8 = entityplayersp.getSwingProgress(f);
            float f12 = MathHelper.sin(f8 * 3.141593f);
            float f16 = MathHelper.sin(MathHelper.sqrt_float(f8) * 3.141593f);
            GL11.glTranslatef(-f16 * 0.4f, MathHelper.sin(MathHelper.sqrt_float(f8) * 3.141593f * 2.0f) * 0.2f, -f12 * 0.2f);
            f8 = 1.0f - f2 / 45.0f + 0.1f;
            if (f8 < 0.0f) {
                f8 = 0.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
            f8 = -MathHelper.cos(f8 * 3.141593f) * 0.5f + 0.5f;
            GL11.glTranslatef(0.0f, 0.0f * f4 - (1.0f - f1) * 1.2f - f8 * 0.5f + 0.04f, -0.9f * f4);
            GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(f8 * -85.0f, 0.0f, 0.0f, 1.0f);
            GL11.glEnable(32826);
            this.mc.renderEngine.loadDownloadableTexture(this.mc.thePlayer.skinURL, this.mc.thePlayer.getEntityTexture(), PlayerSkinParser.instance);
            for (f12 = 0.0f; f12 < 2.0f; f12 += 1.0f) {
                f16 = f12 * 2.0f - 1.0f;
                GL11.glPushMatrix();
                GL11.glTranslatef(-0.0f, -0.6f, 1.1f * f16);
                GL11.glRotatef(-45.0f * f16, 1.0f, 0.0f, 0.0f);
                GL11.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
                GL11.glRotatef(59.0f, 0.0f, 0.0f, 1.0f);
                GL11.glRotatef(-65.0f * f16, 0.0f, 1.0f, 0.0f);
                Render render1 = RenderManager.instance.getEntityRenderObject(this.mc.thePlayer);
                RenderPlayer renderplayer1 = (RenderPlayer)render1;
                float f20 = 1.0f;
                GL11.glScalef(f20, f20, f20);
                renderplayer1.drawFirstPersonHand();
                GL11.glPopMatrix();
            }
            f12 = entityplayersp.getSwingProgress(f);
            f16 = MathHelper.sin(f12 * f12 * 3.141593f);
            float f19 = MathHelper.sin(MathHelper.sqrt_float(f12) * 3.141593f);
            GL11.glRotatef(-f16 * 20.0f, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(-f19 * 20.0f, 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(-f19 * 80.0f, 1.0f, 0.0f, 0.0f);
            f12 = 0.38f;
            GL11.glScalef(f12, f12, f12);
            GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
            GL11.glTranslatef(-1.0f, -1.0f, 0.0f);
            f16 = 0.015625f;
            GL11.glScalef(f16, f16, f16);
            this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture("/misc/mapbg.png"));
            Tessellator tessellator = Tessellator.instance;
            GL11.glNormal3f(0.0f, 0.0f, -1.0f);
            tessellator.startDrawingQuads();
            int byte0 = 7;
            tessellator.addVertexWithUV(0 - byte0, 128 + byte0, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(128 + byte0, 128 + byte0, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(128 + byte0, 0 - byte0, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(0 - byte0, 0 - byte0, 0.0, 0.0, 0.0);
            tessellator.draw();
            MapData mapdata = Item.map.getMapData(itemstack, this.mc.theWorld);
            this.field_28131_f.func_28157_a(this.mc.thePlayer, this.mc.renderEngine, mapdata);
            GL11.glPopMatrix();
        } else if (itemstack != null) {
            GL11.glPushMatrix();
            float f5 = 0.8f;
            float f9 = entityplayersp.getSwingProgress(f);
            float f13 = MathHelper.sin(f9 * 3.141593f);
            float f17 = MathHelper.sin(MathHelper.sqrt_float(f9) * 3.141593f);
            GL11.glTranslatef(-f17 * 0.4f, MathHelper.sin(MathHelper.sqrt_float(f9) * 3.141593f * 2.0f) * 0.2f, -f13 * 0.2f);
            GL11.glTranslatef(0.7f * f5, -0.65f * f5 - (1.0f - f1) * 0.6f, -0.9f * f5);
            GL11.glRotatef(45.0f, 0.0f, 1.0f, 0.0f);
            GL11.glEnable(32826);
            f9 = entityplayersp.getSwingProgress(f);
            f13 = MathHelper.sin(f9 * f9 * 3.141593f);
            f17 = MathHelper.sin(MathHelper.sqrt_float(f9) * 3.141593f);
            GL11.glRotatef(-f13 * 20.0f, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(-f17 * 20.0f, 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(-f17 * 80.0f, 1.0f, 0.0f, 0.0f);
            f9 = 0.4f;
            GL11.glScalef(f9, f9, f9);
            if (itemstack.getItem().shouldRotateAroundWhenRendering()) {
                GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
            }
            if (itemstack.getItem().shouldPointInFrontOfPlayer()) {
                GL11.glRotatef(-20.0f, 0.0f, 1.0f, 0.0f);
            }
            if (itemstack.getItem() instanceof ItemBlock && RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType())) {
                GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
            }
            this.renderItem(entityplayersp, itemstack);
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            float f6 = 0.8f;
            float f10 = entityplayersp.getSwingProgress(f);
            float f14 = MathHelper.sin(f10 * 3.141593f);
            float f18 = MathHelper.sin(MathHelper.sqrt_float(f10) * 3.141593f);
            GL11.glTranslatef(-f18 * 0.3f, MathHelper.sin(MathHelper.sqrt_float(f10) * 3.141593f * 2.0f) * 0.4f, -f14 * 0.4f);
            GL11.glTranslatef(0.8f * f6, -0.75f * f6 - (1.0f - f1) * 0.6f, -0.9f * f6);
            GL11.glRotatef(45.0f, 0.0f, 1.0f, 0.0f);
            GL11.glEnable(32826);
            f10 = entityplayersp.getSwingProgress(f);
            f14 = MathHelper.sin(f10 * f10 * 3.141593f);
            f18 = MathHelper.sin(MathHelper.sqrt_float(f10) * 3.141593f);
            GL11.glRotatef(f18 * 70.0f, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(-f14 * 20.0f, 0.0f, 0.0f, 1.0f);
            this.mc.renderEngine.loadDownloadableTexture(this.mc.thePlayer.skinURL, this.mc.thePlayer.getEntityTexture(), PlayerSkinParser.instance);
            GL11.glTranslatef(-1.0f, 3.6f, 3.5f);
            GL11.glRotatef(120.0f, 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(200.0f, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(-135.0f, 0.0f, 1.0f, 0.0f);
            GL11.glScalef(1.0f, 1.0f, 1.0f);
            GL11.glTranslatef(5.6f, 0.0f, 0.0f);
            Render render = RenderManager.instance.getEntityRenderObject(this.mc.thePlayer);
            RenderPlayer renderplayer = (RenderPlayer)render;
            f18 = 1.0f;
            renderplayer.drawFirstPersonHand();
            GL11.glPopMatrix();
        }
        GL11.glDisable(32826);
        RenderHelper.disableStandardItemLighting();
    }

    public void renderOverlays(float f) {
        GL11.glDisable(3008);
        if (this.mc.thePlayer.isBurning()) {
            int i = this.mc.renderEngine.getTexture("/terrain.png");
            GL11.glBindTexture(3553, i);
            this.renderFireInFirstPerson(f);
        }
        if (this.mc.thePlayer.isEntityInsideOpaqueBlock() && !this.mc.thePlayer.noClip) {
            int j = MathHelper.floor_double(this.mc.thePlayer.posX);
            int l = MathHelper.floor_double(this.mc.thePlayer.posY);
            int i1 = MathHelper.floor_double(this.mc.thePlayer.posZ);
            int j1 = this.mc.renderEngine.getTexture("/terrain.png");
            GL11.glBindTexture(3553, j1);
            int k1 = this.mc.theWorld.getBlockId(j, l, i1);
            if (this.mc.theWorld.isBlockNormalCube(j, l, i1)) {
                this.renderInsideOfBlock(f, Block.blocksList[k1].getBlockTextureFromSide(2));
            } else {
                for (int l1 = 0; l1 < 8; ++l1) {
                    int k2;
                    int j2;
                    float f1 = ((float)((l1 >> 0) % 2) - 0.5f) * this.mc.thePlayer.width * 0.9f;
                    float f2 = ((float)((l1 >> 1) % 2) - 0.5f) * this.mc.thePlayer.height * 0.2f;
                    float f3 = ((float)((l1 >> 2) % 2) - 0.5f) * this.mc.thePlayer.width * 0.9f;
                    int i2 = MathHelper.floor_float((float)j + f1);
                    if (!this.mc.theWorld.isBlockNormalCube(i2, j2 = MathHelper.floor_float((float)l + f2), k2 = MathHelper.floor_float((float)i1 + f3))) continue;
                    k1 = this.mc.theWorld.getBlockId(i2, j2, k2);
                }
            }
            if (Block.blocksList[k1] != null) {
                this.renderInsideOfBlock(f, Block.blocksList[k1].getBlockTextureFromSide(2));
            }
        }
        if (this.mc.thePlayer.isInsideOfMaterial(Material.water)) {
            int k = this.mc.renderEngine.getTexture("/misc/water.png");
            GL11.glBindTexture(3553, k);
            this.renderWarpedTextureOverlay(f);
        }
        GL11.glEnable(3008);
    }

    private void renderInsideOfBlock(float f, int i) {
        Tessellator tessellator = Tessellator.instance;
        float f1 = this.mc.thePlayer.getEntityBrightness(f);
        f1 = 0.1f;
        if (this.mc.fullbright) {
            f1 = 1.0f;
        }
        GL11.glColor4f(f1, f1, f1, 0.5f);
        GL11.glPushMatrix();
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = (float)TextureFX.tileWidthTerrain / (128.0f * (float)net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float f8 = (float)(i % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain) - f7;
        float f9 = ((float)(i % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES) + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain) + f7;
        float f10 = (float)(i / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain) - f7;
        float f11 = ((float)(i / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES) + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain) + f7;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(f2, f4, f6, f9, f11);
        tessellator.addVertexWithUV(f3, f4, f6, f8, f11);
        tessellator.addVertexWithUV(f3, f5, f6, f8, f10);
        tessellator.addVertexWithUV(f2, f5, f6, f9, f10);
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderWarpedTextureOverlay(float f) {
        Tessellator tessellator = Tessellator.instance;
        float f1 = this.mc.thePlayer.getEntityBrightness(f);
        if (this.mc.fullbright) {
            f1 = 1.0f;
        }
        GL11.glColor4f(f1, f1, f1, 0.5f);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glPushMatrix();
        float f2 = 4.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -1.0f;
        float f6 = 1.0f;
        float f7 = -0.5f;
        float f8 = -this.mc.thePlayer.rotationYaw / 64.0f;
        float f9 = this.mc.thePlayer.rotationPitch / 64.0f;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(f3, f5, f7, f2 + f8, f2 + f9);
        tessellator.addVertexWithUV(f4, f5, f7, 0.0f + f8, f2 + f9);
        tessellator.addVertexWithUV(f4, f6, f7, 0.0f + f8, 0.0f + f9);
        tessellator.addVertexWithUV(f3, f6, f7, f2 + f8, 0.0f + f9);
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3042);
    }

    private void renderFireInFirstPerson(float f) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.9f);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        float f1 = 1.0f;
        for (int i = 0; i < 2; ++i) {
            GL11.glPushMatrix();
            int j = Block.texCoordToIndex(15, 1 + i);
            int k = j % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            int l = j / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            float f2 = (float)k / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain);
            float f3 = ((float)k + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain);
            float f4 = (float)l / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain);
            float f5 = ((float)l + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain);
            float f6 = (0.0f - f1) / 2.0f;
            float f7 = f6 + f1;
            float f8 = 0.0f - f1 / 2.0f;
            float f9 = f8 + f1;
            float f10 = -0.5f;
            GL11.glTranslatef((float)(-(i * 2 - 1)) * 0.24f, -0.3f, 0.0f);
            GL11.glRotatef((float)(i * 2 - 1) * 10.0f, 0.0f, 1.0f, 0.0f);
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(f6, f8, f10, f3, f5);
            tessellator.addVertexWithUV(f7, f8, f10, f2, f5);
            tessellator.addVertexWithUV(f7, f9, f10, f2, f4);
            tessellator.addVertexWithUV(f6, f9, f10, f3, f4);
            tessellator.draw();
            GL11.glPopMatrix();
        }
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3042);
    }

    public void updateEquippedItem() {
        float f;
        float f1;
        float f2;
        boolean flag;
        ItemStack itemstack;
        this.prevEquippedProgress = this.equippedProgress;
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        ItemStack itemstack1 = itemstack = entityplayersp.inventory.getCurrentItem();
        boolean bl = flag = this.field_20099_f == entityplayersp.inventory.currentItem && itemstack1 == this.itemToRender;
        if (this.itemToRender == null && itemstack1 == null) {
            flag = true;
        }
        if (itemstack1 != null && this.itemToRender != null && itemstack1 != this.itemToRender && itemstack1.itemID == this.itemToRender.itemID && itemstack1.getMetadata() == this.itemToRender.getMetadata()) {
            this.itemToRender = itemstack1;
            flag = true;
        }
        if ((f2 = (f1 = flag ? 1.0f : 0.0f) - this.equippedProgress) < -(f = 0.4f)) {
            f2 = -f;
        }
        if (f2 > f) {
            f2 = f;
        }
        this.equippedProgress += f2;
        if (this.equippedProgress < 0.1f) {
            this.itemToRender = itemstack1;
            this.field_20099_f = entityplayersp.inventory.currentItem;
        }
    }

    public void func_9449_b() {
        this.equippedProgress = 0.0f;
    }

    public void func_9450_c() {
        this.equippedProgress = 0.0f;
    }
}

