/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ItemTool;
import net.minecraft.src.Material;
import net.minecraft.src.World;
import net.minecraft.src.material.ToolMaterial;

public class ItemToolShovel
extends ItemTool {
    private static Material[] materialsEffectiveAgainst = new Material[]{Material.grass, Material.ground, Material.sand, Material.snow, Material.builtSnow, Material.clay};

    public ItemToolShovel(int i, ToolMaterial enumtoolmaterial) {
        super(i, 1, enumtoolmaterial, materialsEffectiveAgainst);
    }

    @Override
    public boolean canHarvestBlock(Block block) {
        if (block == Block.layerSnow) {
            return true;
        }
        return block == Block.blockSnow;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, double heightPlaced) {
        int i1 = world.getBlockId(i, j, k);
        int j1 = world.getBlockId(i, j + 1, k);
        if (l != 0 && j1 == 0 && (i1 == Block.grass.blockID || i1 == Block.dirt.blockID || i1 == Block.grassRetro.blockID || i1 == Block.farmlandDirt.blockID)) {
            Block block = Block.pathDirt;
            world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, block.stepSound.func_1145_d(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
            if (!world.isMultiplayerAndNotHost) {
                world.setBlockWithNotify(i, j, k, block.blockID);
                itemstack.damageItem(1, entityplayer);
            }
            return true;
        }
        return false;
    }
}

