/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.material.ToolMaterial;

public class ItemToolSword
extends Item {
    private int weaponDamage;

    public ItemToolSword(int i, ToolMaterial enumtoolmaterial) {
        super(i);
        this.maxStackSize = 1;
        this.setMaxDamage(enumtoolmaterial.getDurability());
        this.weaponDamage = 4 + enumtoolmaterial.getDamage() * 2;
    }

    @Override
    public float getStrVsBlock(ItemStack itemstack, Block block) {
        return block.blockID != Block.cobweb.blockID ? 1.5f : 15.0f;
    }

    @Override
    public boolean hitEntity(ItemStack itemstack, EntityLiving entityliving, EntityLiving entityliving1) {
        itemstack.damageItem(1, entityliving1);
        return true;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, int i, int j, int k, int l, EntityLiving entityliving) {
        Block block = Block.blocksList[i];
        if (block != null && block.blockHardness > 0.0f) {
            itemstack.damageItem(2, entityliving);
        }
        return true;
    }

    @Override
    public int getDamageVsEntity(Entity entity) {
        return this.weaponDamage;
    }

    @Override
    public boolean isFull3D() {
        return true;
    }

    @Override
    public boolean canHarvestBlock(Block block) {
        return block.blockID == Block.cobweb.blockID;
    }
}

