/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.MinecraftError;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class LoadingScreenRenderer
implements IProgressUpdate {
    private String field_1004_a = "";
    private Minecraft mc;
    private String field_1007_c = "";
    private long field_1006_d = System.currentTimeMillis();
    private boolean field_1005_e = false;

    public LoadingScreenRenderer(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void printText(String s) {
        this.field_1005_e = false;
        this.func_597_c(s);
    }

    @Override
    public void func_594_b(String s) {
        this.field_1005_e = true;
        this.func_597_c(this.field_1007_c);
    }

    public void func_597_c(String s) {
        if (!this.mc.running) {
            if (this.field_1005_e) {
                return;
            }
            throw new MinecraftError();
        }
        this.field_1007_c = s;
        GL11.glClear(256);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.mc.resolution.scaledWidthExact, this.mc.resolution.scaledHeightExact, 0.0, 100.0, 300.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -200.0f);
    }

    @Override
    public void displayLoadingString(String s) {
        if (!this.mc.running) {
            if (this.field_1005_e) {
                return;
            }
            throw new MinecraftError();
        }
        this.field_1006_d = 0L;
        this.field_1004_a = s;
        this.setLoadingProgress(-1);
        this.field_1006_d = 0L;
    }

    @Override
    public void setLoadingProgress(int i) {
        if (!this.mc.running) {
            if (this.field_1005_e) {
                return;
            }
            throw new MinecraftError();
        }
        long l = System.currentTimeMillis();
        if (l - this.field_1006_d < 20L) {
            return;
        }
        this.field_1006_d = l;
        boolean isNether = this.field_1007_c.equals("Entering the Nether");
        if (this.mc.shadersActive()) {
            this.mc.render.beginRenderGame();
        }
        GL11.glEnable(3008);
        int j = this.mc.resolution.scaledWidth;
        int k = this.mc.resolution.scaledHeight;
        GL11.glClear(256);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.mc.resolution.scaledWidthExact, this.mc.resolution.scaledHeightExact, 0.0, 100.0, 300.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -200.0f);
        GL11.glClear(16640);
        Tessellator tessellator = Tessellator.instance;
        int bgTexture = isNether ? this.mc.renderEngine.getTexture("/gui/background-loading-nether.png") : this.mc.renderEngine.getTexture("/gui/background.png");
        GL11.glBindTexture(3553, bgTexture);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(0.0, k, 0.0, 0.0, (float)k / f);
        tessellator.addVertexWithUV(j, k, 0.0, (float)j / f, (float)k / f);
        tessellator.addVertexWithUV(j, 0.0, 0.0, (float)j / f, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        if (i >= 0) {
            int byte0 = 100;
            int byte1 = 2;
            int j1 = j / 2 - byte0 / 2;
            int k1 = k / 2 + 16;
            GL11.glDisable(3553);
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0x808080);
            tessellator.addVertex(j1, k1, 0.0);
            tessellator.addVertex(j1, k1 + byte1, 0.0);
            tessellator.addVertex(j1 + byte0, k1 + byte1, 0.0);
            tessellator.addVertex(j1 + byte0, k1, 0.0);
            tessellator.setColorOpaque_I(0x80FF80);
            tessellator.addVertex(j1, k1, 0.0);
            tessellator.addVertex(j1, k1 + byte1, 0.0);
            tessellator.addVertex(j1 + i, k1 + byte1, 0.0);
            tessellator.addVertex(j1 + i, k1, 0.0);
            tessellator.draw();
            GL11.glEnable(3553);
        }
        this.mc.fontRenderer.drawStringWithShadow(this.field_1007_c, (j - this.mc.fontRenderer.getStringWidth(this.field_1007_c)) / 2, k / 2 - 4 - 16, 0xFFFFFF);
        this.mc.fontRenderer.drawStringWithShadow(this.field_1004_a, (j - this.mc.fontRenderer.getStringWidth(this.field_1004_a)) / 2, k / 2 - 4 + 8, 0xFFFFFF);
        if (this.mc.shadersActive()) {
            this.mc.render.endRenderGame();
        }
        Display.update();
        try {
            Thread.yield();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

