/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.GameSettings;
import net.minecraft.src.MapColor;
import net.minecraft.src.MapCoord;
import net.minecraft.src.MapData;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class MapItemRenderer {
    private int[] field_28159_a = new int[16384];
    private int field_28158_b;
    private GameSettings field_28161_c;
    private FontRenderer field_28160_d;

    public MapItemRenderer(FontRenderer fontrenderer, GameSettings gamesettings, RenderEngine renderengine) {
        this.field_28161_c = gamesettings;
        this.field_28160_d = fontrenderer;
        this.field_28158_b = renderengine.allocateAndSetupTexture(new BufferedImage(128, 128, 2));
        for (int i = 0; i < 16384; ++i) {
            this.field_28159_a[i] = 0;
        }
    }

    public void func_28157_a(EntityPlayer entityplayer, RenderEngine renderengine, MapData mapdata) {
        for (int i = 0; i < 16384; ++i) {
            byte byte0 = mapdata.field_28176_f[i];
            if (byte0 / 4 == 0) {
                this.field_28159_a[i] = (i + i / 128 & 1) * 8 + 16 << 24;
                continue;
            }
            int l = MapColor.mapColorArray[byte0 / 4].colorValue;
            int i1 = byte0 & 3;
            int c = 220;
            if (i1 == 2) {
                c = 255;
            }
            if (i1 == 0) {
                c = 180;
            }
            int j1 = (l >> 16 & 0xFF) * c / 255;
            int k1 = (l >> 8 & 0xFF) * c / 255;
            int l1 = (l & 0xFF) * c / 255;
            if (((Boolean)this.field_28161_c.anaglyph.value).booleanValue()) {
                int i2 = (j1 * 30 + k1 * 59 + l1 * 11) / 100;
                int j2 = (j1 * 30 + k1 * 70) / 100;
                int k2 = (j1 * 30 + l1 * 70) / 100;
                j1 = i2;
                k1 = j2;
                l1 = k2;
            }
            this.field_28159_a[i] = 0xFF000000 | j1 << 16 | k1 << 8 | l1;
        }
        renderengine.func_28150_a(this.field_28159_a, 128, 128, this.field_28158_b);
        int j = 0;
        int k = 0;
        Tessellator tessellator = Tessellator.instance;
        float f = 0.0f;
        GL11.glBindTexture(3553, this.field_28158_b);
        GL11.glEnable(3042);
        GL11.glDisable(3008);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((float)(j + 0) + f, (float)(k + 128) - f, -0.01f, 0.0, 1.0);
        tessellator.addVertexWithUV((float)(j + 128) - f, (float)(k + 128) - f, -0.01f, 1.0, 1.0);
        tessellator.addVertexWithUV((float)(j + 128) - f, (float)(k + 0) + f, -0.01f, 1.0, 0.0);
        tessellator.addVertexWithUV((float)(j + 0) + f, (float)(k + 0) + f, -0.01f, 0.0, 0.0);
        tessellator.draw();
        GL11.glEnable(3008);
        GL11.glDisable(3042);
        renderengine.bindTexture(renderengine.getTexture("/misc/mapicons.png"));
        for (MapCoord mapcoord : mapdata.field_28173_i) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)j + (float)mapcoord.field_28216_b / 2.0f + 64.0f, (float)k + (float)mapcoord.field_28220_c / 2.0f + 64.0f, -0.02f);
            GL11.glRotatef((float)(mapcoord.field_28219_d * 360) / 16.0f, 0.0f, 0.0f, 1.0f);
            GL11.glScalef(4.0f, 4.0f, 3.0f);
            GL11.glTranslatef(-0.125f, 0.125f, 0.0f);
            float f1 = (float)(mapcoord.field_28217_a % 4 + 0) / 4.0f;
            float f2 = (float)(mapcoord.field_28217_a / 4 + 0) / 4.0f;
            float f3 = (float)(mapcoord.field_28217_a % 4 + 1) / 4.0f;
            float f4 = (float)(mapcoord.field_28217_a / 4 + 1) / 4.0f;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(-1.0, 1.0, 0.0, f1, f2);
            tessellator.addVertexWithUV(1.0, 1.0, 0.0, f3, f2);
            tessellator.addVertexWithUV(1.0, -1.0, 0.0, f3, f4);
            tessellator.addVertexWithUV(-1.0, -1.0, 0.0, f1, f4);
            tessellator.draw();
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(0.0f, 0.0f, -0.04f);
        GL11.glScalef(1.0f, 1.0f, 1.0f);
        GL11.glPopMatrix();
    }
}

