/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.src.NBTBase;

public class NBTTagDoubleArray
extends NBTBase {
    public double[] doubleArray;

    public NBTTagDoubleArray() {
    }

    public NBTTagDoubleArray(double[] adouble0) {
        this.doubleArray = adouble0;
    }

    @Override
    void writeTagContents(DataOutput dataoutput) throws IOException {
        dataoutput.writeInt(this.doubleArray.length);
        byte[] bytes = new byte[this.doubleArray.length * 8];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer().put(this.doubleArray);
        dataoutput.write(bytes);
    }

    @Override
    void readTagContents(DataInput datainput) throws IOException {
        int i = datainput.readInt();
        this.doubleArray = new double[i];
        byte[] bytes = new byte[i * 8];
        datainput.readFully(bytes);
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer().get(this.doubleArray);
    }

    @Override
    public byte getType() {
        return 12;
    }

    public String toString() {
        return "[" + this.doubleArray.length + " doubles]";
    }
}

